package datasync.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import datasync.model.OuInfoJavaModel;
import datasync.model.PositionJavaModel;
import datasync.model.UserInfoJavaModel;
import datasync.service.AbstractSyncJavaService;

import java.util.List;

public class JavaSyncService extends AbstractSyncJavaService implements JavaConfig {
    // 全量增量区分
    private static final String MODE_FULL = "1";
    private static final String MODE_UPDATE = "2";
    private String syncServiceName;
    // json解析用
    private ObjectMapper mapper;

    public JavaSyncService() {
        super.setApikey(JavaDemoTest.apikey);
        super.setSecretkey(JavaDemoTest.secretkey);
        super.setBaseUrl(JavaDemoTest.baseUrl);
        super.setModeFull(MODE_FULL);
        super.setModeUpdate(MODE_UPDATE);
        super.setIsPosIdProvided(false);
        syncServiceName = this.getClass().getSimpleName();
        super.setSyncServiceName(syncServiceName);

        // 创建用于json反序列化的对象
        mapper = new ObjectMapper();
        // 忽略json中多余的属性字段
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    @Override
    protected List<PositionJavaModel> getPositionsFromDB() throws Exception {
        return null;
    }

    @Override
    protected List<OuInfoJavaModel> getOuInfoListFromDB() throws Exception {
        return null;
    }

    @Override
    protected List<UserInfoJavaModel> getUserInfoListFromDB() throws Exception {
        return null;
    }

    @Override
    protected boolean isOrgExpired(OuInfoJavaModel org) {
        return false;
    }

    @Override
    protected boolean isPosExpired(PositionJavaModel pos) {
        return false;
    }

    @Override
    protected boolean isUserExpired(UserInfoJavaModel user) {
        return false;
    }

    @Override
    protected void setRootOrgParentId(List<OuInfoJavaModel> newList) {

    }

    @Override
    protected void changePropValues(List<UserInfoJavaModel> newList) {

    }

    @Override
    protected List<OuInfoJavaModel> getOuInfoModelList(String mode) throws Exception {
        return null;
    }

    @Override
    protected List<PositionJavaModel> getPositionModelList(String mode) throws Exception {
        return null;
    }

    @Override
    protected List<UserInfoJavaModel> getUserInfoModelList(String mode) throws Exception {
        return null;
    }
}
