<?php

/*
*
*	程式名稱：	訊息傳遞及轉址函式
*	說　　明：	傳遞訊息並且轉址至指定鏈結。
*	檔案名稱：	gotoUrl.php
*
*	參　　數：	$url			鏈結
*				$Message		訊息內容
*				$DelayTime		訊息顯示時間
*				$TemplateVars	其他有關訊息畫面的參數值, 方便針對不同的訊息畫面做進一步參數傳遞
*								目前可能用到的參數值有
*								FileName: 指定訊息顯示畫面
*								KeyMode:  訊息畫面的快速鍵模式
*								onloadJavascript: 訊息畫面下所用到的Javascripts
*				$ErrorLevel		錯誤等級
*				$ErrorCode		
*
*	版　　本：	1.0.1.
*	作　　者：	Hsiao Chuan Huang <dolly@price.com.tw>
*	著作聲明：	Price Co., Ltd.
*	起草日期：	2005.04.12.
*	更新日期：	
*				2005.04.12. 沿用die函式的概念, 合併原有GoTo及Dolly_show_err_page兩個函式的功能
*				2005.04.13. 將Javascripts, KeyMode, 及FileName的參數設定整合至變數TemplateVars
*				2005.05.17. 取消MessageTitle, 新增寫入Log的功能
*
*/

function gotoUrl($url, $Message='', $DelayTime=2, $TemplateVars=array(), $ErrorLevel=0, $ErrorCode='', $ErrorLog=array()) {

	global $GSID;

	if($Message):

		// Session初始化
		if(!session_is_registered("GSID")):
			session_register("GSID") OR die("Severely Error! Could NOT start session!!!");
		endif;

		// 訊息內容透過Session傳遞
		$msg = array();
		$msg[Message]=is_array($Message)?$Message:array($Message);
		if($ErrorCode) $msg[Message][]="錯誤代碼：{$ErrorCode}";
		$msg[RedirectUrl]=$url;
		$msg[DelayTime]=$DelayTime;
		$msg[TemplateVars]=$TemplateVars;
		$GSID[SystemMessage]=$msg;

		// 寫入Log
		if(($ErrorLevel & _ER_REPORTING_LEVEL) !=0):

			$log=array();
			$log[]="<ErrorLog>";
			$log[]="<ErrorTime>".date('Y-m-d H:i:s')."</ErrorTime>";
			$log[]="<ErrorCode>{$ErrorCode}</ErrorCode>";
			$log[]="<ErrorMessage>";
			if(is_array($ErrorLog)):
				$log=array_merge($log, $ErrorLog);
			else:
				$log[]=$ErrorLog;
			endif;
			$log[]="</ErrorMessage>";
			$log[]="</ErrorLog>";
			$log[]="";
			
			$fp=fopen(_ER_REPORTING_FILE, 'a');
			fwrite($fp, join("\r\n", $log));
			fclose($fp);

		endif;

	endif;

	header ("Location: $url"); 
	exit();

} 

?>