<?php 

##############################################################################################
# Short description: 用來layout的class，目前使用Smarty
#
# Detail description
#				
# @author       
# @version      1.3
# @copyright    
# @since        2002/01/29 : (1.1) 修正debug_console的錯誤
#							 (1.2) 加入讀取 $GLOBALS[CFG][LAYOUT_URL]的設定
#				2002/03/08 : (1.3) layout->display加上第二個參數 $op ，省略一次 assign 步驟
# @access       public
#
class  LAYOUT{

	
	##############################################################################################
	# Description
	# @var       
	# @since     1.0
	# 
	var $smarty ;
	
	
	##############################################################################################
	# Description
	# @var       
	# @since     1.0
	# 
	var $debug=0;
	
	##############################################################################################
	# Short description: initialize smarty. setting up some variable
	#
	# Detail description:
	# @param     
	# @since     1.0
	# @return    void
	#
	function LAYOUT() {
		$this->smarty = new Smarty;

										# 加入常用的函數
		$this->smarty->assign("PHP_SELF",$GLOBALS[PHP_SELF]);
		$this->smarty->assign("NOW",date("H : i | D , M  d , Y"));

		if ($GLOBALS[CFG][LAYOUT_USE_DEBUG_CONSOLE]) {
			$this->smarty->debugging = true;
		    
		}
		if ($GLOBALS[CFG][LAYOUT_DEBUG_CONSOLE_URL] ) {
		    $this->smarty->debugging_ctrl = "URL";
		}

		if (is_array($url_ary = $GLOBALS[CFG][LAYOUT_URL])) {
		    foreach ($url_ary AS  $key=>$val  ) {
		        $this->smarty->assign("URL_".$key,$val);
		    }
		    
		}

	} // end func
    

	
	##############################################################################################
	# Short description:
	#
	# Detail description:
	# @param     
	# @since     1.0
	# @return    void
	#
	function assign() {

		$numargs = func_num_args();
		$args = func_get_args();
//DEBUG:
//print "<P>[DEBUG] numargs:".$numargs;
//DEBUG:
//print "<P>[DEBUG] args".var_dump($args);


		if ($numargs==2) {
			$this->smarty->assign($args[0], $args[1]);	    
		}
		elseif ($numargs==1) {
			$this->smarty->assign($args[0]);	      
		}
		else {
			return false;
		    
		}
	    return true;
	} // end func

	
	##############################################################################################
	# Short description:對應到Smarty，generate page後傳回
	#
	# Detail description:
	# @param     
	# @since     1.0
	# @return    void
	#
	function fetch($tpl) {
		$smarty = $this->smarty;

 		$out=$smarty->fetch("$tpl");

		return $out;
	    
	} // end func

	
	##############################################################################################
	# Short description:對應到Smarty，generate page後秀出
	#
	# Detail description:
	# @param     
	# @since     1.0
	# @return    void
	#
	function display($tpl,$op=0) {

		//$smarty = $this->smarty;
	
		if (is_array($op)) {
		    $flag = $this->smarty->assign($op);
//DEBUG:
//print "<P>[DEBUG]  : ".D_dv($op );
		}


 		$this->smarty->display("$tpl");

		return true;
	    
	} // end func

} // end class








?>