<?php

#############################################################################################
#############################################################################################
#############################################################################################
#			class.db.php			DB物件 : (原PRODUCT物件)
#											1. class DB
#											3. function CMP_dolly_class1
#
#
#############################################################################################
#############################################################################################
#############################################################################################











##############################################################################################
# CLASS NAME: DB
#
# CLASS DESCRIPTION:
#				進/出資料庫物件
#
# @author       Ming-Hsien Lee (pipperl@pchome.com.tw)
# @version      1.0.0
#				1.1.0 :	把預先設定的設定值獨立Load進 $this->CFG
#				1.2.0 : 改名為DB
#				1.2.1 : 加入 DB_COLS_SORT 及 DB_CUSTOM_DECODE_DB_DATA_FUNCTION
#				1.2.2 : 加入 ROW_PER_PAGE , 把 chk_var_type收進class中
#				1.2.3 : 加快mysql的browse速度，加入 BROWSE_SQL_TITLE
#				1.2.4 (2002/05/11): 修正使用 BROWSE_SQL_TITLE 時 WHERE 可能會重覆的問題
#				1.2.5 (2002/06/20): db_modify 新增status ary的處理
#				1.2.6 (2002/06/20): db_browse 新增NOT_DELETED mode
#				1.2.7 (2002/07/07): chk_var_type 新增DT (datetime)
#				1.2.8 (2002/07/10): 加入 DB_COLS_GROUP
#				1.2.9 (2002/07/10): 加入 DB_BROWSE_LAYOUT_STYLE 及 DB_BROWSE_LAYOUT_STYLE_KEY
#									DB_BROWSE_LAYOUT_STYLE = ""
#									DB_BROWSE_LAYOUT_STYLE = "group" 
#										(搭配 DB_BROWSE_LAYOUT_STYLE_KEY)
#				1.3.0 (2002/07/13): 修正 add_where_condition 所造成的 bug
#				1.3.1 (2002/07/19): 修正 f)中對 DB_SEARCH_RULE 中 array value的處理
#				1.3.2 (2002/07/20): db_add()及db_modify()中對於欄位值是 false的話填入 NULL
#				1.3.3 (2002/07/20): 新增兩個class物件的設定值： class_col_id 及 class_col_name
#									在db_browse時若使用group layout 填入  GROUP_NAME
#				1.3.4 (2002/07/23): 去掉類別search的部份，改用設定值來search就好
#									db_browse() :除去使用 LIMIT 加速時 max_no 不正確顯示的問題
#									db_add() : 新增對status_ary的處理 (如同status為array時的處理)
#									db_modify() : 新增對status_ary的處理 (如同status為array時的處理)
#				1.3.5 (2002/07/27): db_browse的參數中 IS_ONWEB 改成要符合 IS_ONWEB + NOT_DELETED 才顯示!			
#				1.3.6 (2002/07/29): 修正 add_group_condition的BUG					
#				1.3.7 (2002/11/20): get_cgi_str () 增加array的判斷
#												 db_browse() 新增 參數 PARM_KEYS
#		
# @copyright    
# @since        2002/01/26
# @access       public
#
#

/*
cfg:
	DB_CLASS_DEF = array(	db_type : SQL/config....
				table			: 資料表的名稱
				class_data = array(...) : config時用
				name			: class的名稱，到時會放在 $this->db_class (物件) 
								  及 $this->db_class_data (資料) 中
				col_name		: 對應到主DB的欄位
				class_col_id	: 對應到 class 資料表的 id (預設： classid)
				class_col_name  : 對應到 class 資料表的 name(預設: name)


	DB_TABLE
	DB_BROWSE_LAYOUT_STYLE
	DB_STATUS_DEF
	DB_STATUS_NOT_NORMAL_DEF

	DB_COLS_BROWSE					: 在browse要抓出的欄位

	DB_FULLTEXT_SEARCH_COLS = array()		: fulltext 要找的欄位

	DB_SEARCH_RULE = array(
							# 在 search時的rule
							
							# KEY如果有值的話(其值會設給$str) :
							# 1. 執行 EXEC_1 
							# 2. RULE 中的變數要用'\' escape起來
							# 3. add_where_condition($RULE,$PARM_KEY,
							#    $PARM_VAL,$PARM_MSG)
							# 4. 執行EXEC_2
							#
							# 5. OPTION : T : trim $str
							#			  U : strtoupper
							#			  L : strtolower

$CFG[BOOK][PRODUCT_SEARCH_RULE]["PHP_sr_parm_qty_chk_err"] = array(
		"RULE" => "(qty<>qty2 AND (status & ".$CFG[BOOK][PRODUCT_STATUS_DEF][IS_CHECKED] .") !=0 )",
//					." OR (qty!=0 AND qty2=0)",
		"PARM_KEY" => "PHP_sr_parm_qty_chk_err",
		"PARM_VAL" => "1",
		"PARM_MSG" => "列出已盤點且數量不合的商品",
//		"EXEC_1"	=> 'print D_dv($test_key);',
//		"EXEC_2"	=> 'print "self:P";',
		"OPTION"	=> "T",
		);



				);


	DB_COLS_INSERT
	DB_COLS_UPDATE
	DB_COLS_UPDATE_KEY

	DB_COLS_SORT		// 排序的欄位
	DB_COLS_GROUP		// 要Group的欄位

	DB_CUSTOM_DECODE_DB_DATA_FUNCTION	// 自定 decode_db_data之函數

	ROW_PER_PAGE	// browse時傳回的列數

	BROWSE_SQL_TITLE	// 在browse時用來取代一般的 select ... from ....
						// 有 join 時特別好用!!!

argv:
	PHP_sr_parm_fulltext_search_str

*/

			    



class DB {

	var $sql;
	var $table;						# 主要的TABLE 名稱 
	var $browse_layout_style = 0;					# product_browse的layout style
													# 預設為 0 : 傳統的一列一列array
													#		1 :	Dolly式 class group法 
	var $msg;
 

	var $db_class;					# 類別物件 array
	var $db_class_data;				# 類別資料 array
								

	var $new_item_id;								# 新增 product之後的ID 

	var $CFG ;					# 設定值 
	var $debug;					# 
	
	##############################################################################################
	# FUNCTION NAME:	init
	#
	# FUNCTION DESCRIPTION:
	#				初始化物件：1. 設定好sql連線物件 2. 設定好class物件(DB_CLASS_TABLE)
	#
	# @param	$sql: sql物件 (depandent by MSSQL of MYSQL)
	#			$config: config
	#
	#				
	#
	# @version      1.0.0
	# @since        2002/01/26
	# @return       T/F
	#
	
	function init($sql, $config) {
	
		$this->sql = $sql;

		$this->msg = new MSG_HANDLE();

		if (!is_array($config)) {
		    $this->msg->add("錯誤：無法取得DB物件的參數設定");
			return false;
		}

		$this->CFG = $config;

		if (!is_array($this->CFG[DB_CLASS_DEF])) {
			$this->CFG[DB_CLASS_DEF] = array();	    
		}		


		/* 一開始不將CLASS資料Load進來~會影響執行的速度
						# 改在config中定義( DB_CLASS_TABLE[])

		foreach ($this->CFG[DB_CLASS_DEF] AS  $key=>$val  ) { // name -> config

		    $tmp_obj = new DB_CLASS();
																# 把自己的sql傳下去
			$val[sql] = $sql;
			if (!$tmp_obj->init($val)) {
				$this->msg->merge($tmp_obj->msg);
				return false;
			}
			$this->db_class[$val[name]] = $tmp_obj;
			$this->db_class_data[$val[name]] = $tmp_obj->get_class_list(0,$val[class_parent]);
//DEBUG:
//print "<P>[DEBUG]  : ".PIPPERL_dv($this->db_class_data[$val[name]] );
//print "<P>[DEBUG]  : ".$tmp_obj->msg->get(0);
			
			if (!is_array($this->db_class_data[$val[name]])) {
			    $this->db_class_data[$val[name]] = array("取得類別失敗( ".$val[name]." )"); 
			}

			unset($tmp_obj);

		} // end foreach
		
		*/

		$this->table = $this->CFG[DB_TABLE];
		

		if (isset($this->CFG[DB_BROWSE_LAYOUT_STYLE])) {
			$this->browse_layout_style = $this->CFG[DB_BROWSE_LAYOUT_STYLE];		    
		}

		if ($this->CFG[DEBUG]==true) {
		    $this->debug = true; 
		}

		return true;
	}


	#######################################################################################
	# FUNCTION NAME: load_class
	#
	# FUNCTION DESCRIPTION:
	#				讀取類別資料
	#
	# @param		
	#
	# @version      1.1.0
	# @since        2002/01/26
	# @return       T/F
	#

	function load_class_data($classname="")
	{
	

		foreach ($this->CFG[DB_CLASS_DEF] AS  $key=>$val  ) { // name -> config

			if(!$classname || ($classname && $val[name]==$classname)){

			    $tmp_obj = new DB_CLASS();
																# 把自己的sql傳下去
				$val[sql] = $this->sql;
				if (!$tmp_obj->init($val)) {
					 $this->db_class_data[$val[name]] = array("取得類別失敗( ".$val[name]." )"); 
					 break;
				}
				$this->db_class[$val[name]] = $tmp_obj;
				$this->db_class_data[$val[name]] = $tmp_obj->get_class_list(0,$val[class_parent]);
			
				if (!is_array($this->db_class_data[$val[name]])) {
				    $this->db_class_data[$val[name]] = array("取得類別失敗( ".$val[name]." )"); 
				}
	
				unset($tmp_obj);

			}

		} // end foreach

				
		return true;

	}
	##############################################################################################
	# FUNCTION NAME: add_class
	#
	# FUNCTION DESCRIPTION:
	#				新增分類類別
	#				02/03/06 :	檢查class是否存在
	#				02/03/31 :  rewrite 
	#
	# @param		$class, $name , $class_name
	#
	# @version      1.1.0
	# @since        2002/01/26
	# @return       T/F
	#
	
	function add_class($name,$class_name="") {
		 
//		 $class_table = "PRODUCT_CLASS".$class_no."_TABLE";
//		 $class_obj = "class".$class_no; 
//		 $class_name = "class".$class_no."_name";
//		 $class_dec = "class".$class_no."_dec";

					

		if (!is_object($this->db_class[$class_name])) {
			$this->msg->add("錯誤，找不到指定的類別。類別名稱： $class_name ");
			return false;
		}

		if (!$this->db_class[$class_name]->class_new($name)) {
			$this->msg->merge($this->db_class[$class_name]->msg);
			return false;	     
		}

		$this->db_class_data[$class_name] = $this->db_class[$class_name]->get_class_list();

//		$this->$class_name = $this->$class_obj->get_class_list();
//		$this->$class_dec = $this->$class_obj->get_class_list(1);

		 return true;

	} // end func




	##############################################################################################
	# FUNCTION NAME: modify_class
	#
	# FUNCTION DESCRIPTION:
	#				修改分類類別
	#
	# @param		$classid, $name, $class_name
	#
	# @version      1.1.0
	# @since        2002/01/26
	# @return       T/F
	#
		
	function modify_class($classid,$name,$class_name="") {
		 if (!is_object($this->db_class[$class_name])) {
		     $this->msg->add("錯誤，找不到指定的類別。類別名稱： $class_name ");
			 return false;
		 }

		 if (!$this->db_class[$class_name]->class_modify($classid,$name)) {
			 $this->msg->merge($this->db_class[$class_name]->msg);
			 return false;	     
		 }
		$this->db_class_data[$class_name] = $this->db_class[$class_name]->get_class_list();

		 return true;
	} // end func




	##############################################################################################
	# FUNCTION NAME: delete_class
	#
	# FUNCTION DESCRIPTION:
	#				刪除分類類別
	#
	# @param		$classid,$class_name
	#
	# @version      1.0.0
	# @since        2002/01/26
	# @return       T/F
	#
	
	function delete_class($classid,$class_name="") {
		 if (!is_object($this->db_class[$class_name])) {
		     $this->msg->add("錯誤，找不到指定的類別。類別名稱： $class_name ");
			 return false;
		 }

		 if (!$this->db_class[$class_name]->class_delete($classid)) {
			 $this->msg->merge($this->db_class[$class_name]->msg);
			 return false;	     
		 }
		$this->db_class_data[$class_name] = $this->db_class[$class_name]->get_class_list();

		 return true;
	    
	} // end func




	

	
	##############################################################################################
	# FUNCTION NAME: decode_status
	#
	# FUNCTION DESCRIPTION:
	#				將PRODUCT目前狀態解碼 (狀態定義於 $DB_STATUS_DEF 中)
	#
	# @param		$status
	#
	# @version      1.0.0
	# @since        2002/01/25
	# @return       ASSO_ARRAY decoded
	#
	
	function decode_status($status) {

		$status_def = $this->CFG[DB_STATUS_DEF];
	    
		$decoded = array();

		$not_normal_def = split(",",$this->CFG[DB_STATUS_NOT_NORMAL_DEF]);

		$not_normal_flag = 1;

		foreach ($status_def AS  $key=>$val  ) {
		    if ($status & $val) {
				$decoded[$key] = 1;
		        
		    }
			else {
				$decoded[$key] = 0;
			    
			}

							# 給is_normal用(如果item沒有特殊的狀態)
			if (in_array($key,$not_normal_def)) {
			    $not_normal_flag &= 0;
			}

		}
										
		
		$decoded[is_normal] = $not_normal_flag;
		

		return $decoded;

	} // end func


	
	
	##############################################################################################
	# FUNCTION NAME: decode_db_data
	#
	# FUNCTION DESCRIPTION:
	#				將db table中抓下來的row給 decode
	#
	# @param		$row
	#
	# @version      1.2.0
	# @since        2002/01/28
	#				2002/01/29 : (1.1.0) 加入自動判斷圖檔格式
	#				2002/03/31 : (1.2.0) 改回泛用DB
	# @return       $row
	#
	
	
	function decode_db_data($row) {

		$row[status_ary] = $this->decode_status($row[status]);


		
		foreach ($this->CFG[DB_CLASS_DEF] AS  $key=>$val  ) {
			$col_name = $val[col_name];
			$t_key = $row[$col_name];
			if (isset($row[$col_name]) && is_array($this->db_class_data[$val[name]])) {
				$row[$col_name."_dec"] = $this->db_class_data[$val[name]][$t_key];	
			}	
//DEBUG:
//print "<P>[DEBUG]  : ".PIPPERL_dv(array("col_name"=>$col_name,"t_key"=>$t_key,"array"=>$this->db_class_data[$val[name]]) );

			unset($col_name);
		} // end foreach
		
		
	
													# 自定 DB_CUSTOM_DECODE_DB_DATA_FUNCTION
		if (isset($this->CFG[DB_CUSTOM_DECODE_DB_DATA_FUNCTION]) && function_exists($this->CFG[DB_CUSTOM_DECODE_DB_DATA_FUNCTION])) {
		    $custom_func = $this->CFG[DB_CUSTOM_DECODE_DB_DATA_FUNCTION];

			$row = $custom_func($row);
		}



										
		//$row[price_buy] = $row[price];// 實際售價 = 上面標價


																# 解出圖檔
		$img_loc = $this->CFG[IMAGE_DEFAULT];

		if (is_array($this->CFG[IAMGE_POSSIBLE_TYPE])) {

			foreach ($this->CFG[IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
				$img_loc_tmp = $this->CFG[IMAGE_LOC]."/".$row[id].".".$val;
				if (file_exists($img_loc_tmp)) {
					$img_loc = $img_loc_tmp;
				}

			} // end foreach
			


			$row[img_link] = $img_loc;
		    
		}
		

	    return $row;

	} // end func




	
	##############################################################################################
	# FUNCTION NAME: db_browse
	#
	# FUNCTION DESCRIPTION:
	#				主要的產品瀏覽/列表功能 參照 DB_SEARCH_RULE
	#
	# @param		
	#				$mode : search 模式
	#				$argv = (DEFAULT) $_REQUEST (after PHP 4.1.0!!)
	#
	# @version      1.0.0
	#				1.1.0 rewrite
	#				1.2.0 新增 NOT_DELETED mode
	#
	# @since        2002/01/01
	# @return       void
	#
	
	function db_browse($mode="",$argv=0,$return=0) {

		$sql = $this->sql;
		$table = $this->table;

		if (!$argv) {
			$argv = $_REQUEST;
		}

		$srh = new DB_SEARCH();

		if (!$srh->set_sql($sql)) {
			$this->msg->merge($srh->msg);
			return false;
		}

		if (isset($this->CFG[BROWSE_SQL_TITLE])) {
			$q_header = $this->CFG[BROWSE_SQL_TITLE];   	
			if($this->CFG[DB_COLS_MORE]):
				$q_header = preg_replace("/(select )(.+ from .+)$/i","\\1 ".$this->CFG[DB_COLS_MORE].", \\2 ",$q_header);
			endif;
		}
		elseif (isset($this->CFG[DB_COLS_BROWSE])) {		 
			$q_header = "SELECT ".$this->CFG[DB_COLS_BROWSE]." FROM $table";   
		}
		else {
			$q_header = "SELECT * FROM $table";   
		}

		if (!$srh->add_q_header($q_header)) {
			$this->msg->merge($srh->msg);
			return false;

		}

		$sort_str=array();

		if (isset($this->CFG[DB_COLS_SORT])) {		// 排列
			$sort_str[]=$this->CFG[DB_COLS_SORT];
			//$srh->add_sort_condition($this->CFG[DB_COLS_SORT]);    
		}

		if (isset($this->CFG[DB_COLS_GROUP])) {		// group
			$srh->add_group_condition($this->CFG[DB_COLS_GROUP]);    
		}

		if (isset($this->CFG[DB_COLS_HAVING])) {		// having
			$srh->add_having_condition($this->CFG[DB_COLS_HAVING]);    
		}

	//	$srh->add_sort_condition("id");
		if (isset($this->CFG[ROW_PER_PAGE])) {		// 如果有設定換頁的話
			$srh->row_per_page=$this->CFG[ROW_PER_PAGE];    
		}
		else {
			$srh->row_per_page = 0;					// 預設不換頁
		}
	
		

		if ($argv[PHP_sr_startno]) {
			$srh->add_limit_condition($argv[PHP_sr_startno]);		    
		}


		if ($str = $argv[PHP_edit_flag]) {				// 加入edit_flag
			$srh->add_cgi_parm("PHP_edit_flag","1");		    
		}

		if ($str = $argv[PHP_dType]) {
			$srh->add_cgi_parm("PHP_dType",$str);		    // 加入PHP_dType
		}

		if ($str = $argv[PHP_action]) {
			$srh->add_cgi_parm("PHP_action",$str);		    // 加入PHP_action
		}

	
//		$to_browse_ids = array();
	


												# 依不同的$mode 加入where_str
												
		switch ($mode) {
		    case "0":
			case "IS_ONWEB":	// 上網頁 (IS_ONWEB + NOT_DELETED)
			default:
				$tmp_status = $this->CFG[DB_STATUS_DEF][IS_ONWEB];
				$srh->add_where_condition("(status & $tmp_status)!=0");
				$tmp_status = $this->CFG[DB_STATUS_DEF][IS_DELETED];
				$srh->add_where_condition("(status & $tmp_status)=0");
				$sort_str[]="status";
				break;
			case "1":
			case "LIST_ALL":	// 列出全部
				break;
			case "2":
			case "REFINE_SEARCH":	// 更進一步search	 // TODO!!
		        break;
			case "NOT_DELETED":		// 沒有status IS_DELETED 的
				$tmp_status =$this->CFG[DB_STATUS_DEF][IS_DELETED];
				$srh->add_where_condition("(status & $tmp_status)=0");
				$sort_str[]="status";
				break;
		} //end switch		


		if ($str = $argv[PHP_sr_parm_fulltext_search_str] 
			&& is_array($this->CFG[DB_FULLTEXT_SEARCH_COLS])) {	// 全文搜尋
		
			$where_str = "(id='$str')";
			foreach ($this->CFG[DB_FULLTEXT_SEARCH_COLS] AS  $key=>$val  ) {
			    $where_str .= "OR (".$val." LIKE '%$str%')";

			} // end foreach
			
			$srh->add_where_condition($where_str,"PHP_sr_parm_fulltext_search_str",$str,"全文搜尋: 含有 $str 的資料");

			$search_title = "含有 \" $str \" 的資料";
		    
		}
		

#														# 類別 search
#		foreach ($this->CFG[DB_CLASS_DEF] AS  $key=>$val  ) {
#			if (isset($argv["PHP_sr_parm_class_".$val[col_name]])) {
#				$str = $argv["PHP_sr_parm_class_".$val[col_name]];
#				if ($str) {
#					$tmp_col_name = $val[col_name];
#					$tmp_class_dec = $this->db_class_data[$val[name]][$str];
#					$srh->add_where_condition("$tmp_col_name='$str'", 
#											"PHP_sr_parm_class_".$val[col_name], 
#											$str, 
#											"搜尋 $tmp_class_dec 系列的");
#					$search_title = "$tmp_class_dec 系列";
#				    
#				}
#				
#			}
#			
#		} // end foreach
		

		//ORDER
		$srh->add_sort_condition(join(",",$sort_str),$this->CFG[DB_SORT_TYPE]);

		if (!is_array($this->CFG[DB_SEARCH_RULE])) {
		    $this->CFG[DB_SEARCH_RULE] = array();
		}
		
												# 把 search rule 移到conf中
												# 見 $this->CFG[DB_SEARCH_RULE];

		foreach ($this->CFG[DB_SEARCH_RULE] AS  $key=>$val  ) {

		    if ($str = $argv[$key]) {
										//對input作處理			#
																# 2002/07/19 對array作不同處理
				if (strchr($val[OPTION],"T")) { 
					if (!is_array($str)) {
					    $str = trim($str);					    
					}
					else {
					    foreach ($str AS  $key2=>$val2  ) {
					        $str[$key2] = trim($val2);
					    } // end foreach
					    
					}
				}

				if (strchr($val[OPTION],"U")) { 
					if (!is_array($str)) {
					    $str = strtoupper($str);					    
					}
					else {
					    foreach ($str AS  $key2=>$val2  ) {
					        $str[$key2] = strtoupper($val2);
					    } // end foreach
					    
					}
				}
				if (strchr($val[OPTION],"L")) { 
					if (!is_array($str)) {
					    $str = strtolower($str);					    
					}
					else {
					    foreach ($str AS  $key2=>$val2  ) {
					        $str[$key2] = strtolower($val2);
					    } // end foreach
					    
					}
				}

										
				if (isset($val[EXEC_1])) {	// 執行 EXEC_1
				    eval($val[EXEC_1]);
				}

											// 代換\$str 及其他
										
//print "<P>[DEBUG] PSR_str_RULE before: ".$val[PARM_VAL];
//print "<P>[DEBUG]  1: ".PIPPERL_dv($str );

				$val[RULE] = preg_replace('/\$([a-zA-Z0-9_]+)/e' , "$\\1", $val[RULE]);
//print "<P>[DEBUG]  2: ".PIPPERL_dv($str );


				$val[PARM_VAL] = preg_replace('/\$([a-zA-Z0-9_]+)/e' , "$\\1", $val[PARM_VAL]);
//print "<P>[DEBUG]  3: ".PIPPERL_dv($str );

//DEBUG:
//print "<P>[DEBUG] PSR_str_RULE after: ".$val[PARM_VAL];
//print "<P>";
				
				    
				

		        if (isset($val[PARM_KEY]) && isset($val[PARM_VAL])) {
		            if (isset($val[PARM_MSG])) {
						$srh->add_where_condition($val[RULE],
													$val[PARM_KEY],$val[PARM_VAL],
													$val[PARM_MSG]);
		                
		            }
					else {
						$srh->add_where_condition($val[RULE],$val[PARM_KEY],$val[PARM_VAL]);   
					}
		        }
				elseif(isset($val[PARM_KEYS])){					//added by dolly
						$srh->add_where_condition($val[RULE]);
						foreach($val[PARM_KEYS] AS $parm_key=>$exec)
						{
								if (isset($exec)) {	// 執行 EXEC
							    eval($exec);
								}

								if(trim($parm_value)<>""):
									$srh->add_cgi_parm($parm_key,$parm_value);
								endif;
						}
				}	
				else {
						$srh->add_where_condition($val[RULE]);  				    
				}

				if (isset($val[EXEC_2])) {	// 執行EXEC_2
				    eval($val[EXEC_2]);
				}

			}

		} // end foreach
		
		

												# 檢查 $this->browse_layout_style
												# 採取相對應的 sorttype
/*		if ($this->browse_layout_style == 1) {
			$srh->add_sort_condition("class1, name");
		    
		}
		else {
		    $srh->add_sort_condition("name");
		}
*/		

		if ($this->debug) {
			print date("H:i:s")."<br>";		
		}


		// 只回傳Query String
		if($return):
			return $srh->get_where_str();
		endif;

		if($this->nospeedup){
			if (!is_array($result= $srh->send_query3())) {
				$this->msg->merge($srh->msg);
				return false;		    
			}
		}
		elseif($this->is_oldversion){
			if (!is_array($result= $srh->send_query2step())) {
				$this->msg->merge($srh->msg);
				return false;		    
			}
		}
		else{
			if (!is_array($result= $srh->send_query2())) {
				$this->msg->merge($srh->msg);
				return false;		    
			}
		}

		if ($this->debug) {
			print "<P>[DB_DEBUG] q_str : ".PIPPERL_dv($srh->q_str );	
			print date("H:i:s")."<br>";					
		}

	
		foreach ($result AS  $key=>$val  ) {	// 把status解碼

			$result[$key] = $this->decode_db_data($val);
	    
		}
		

													# 決定layout的style
													# 取決於 $this->CFG[DB_BROWSE_LAYOUT_STYLE]
													# 其值 : 
													# "" :	傳統的一列一列array
													# "group" :	Dolly式 class group法 
													#		    要搭配 DB_BROWSE_LAYOUT_STYLE_KEY

		if ($this->browse_layout_style == 1) {	// Dolly式Layout Style
											
												// 先依class1分類
												// 再秀出

//		usort($result,"CMP_dolly_class1");		// 暫時用不到

			//$tmp_cls1=0;
			$tmp_group = array();
			foreach ($result AS  $key=>$val  ) {

				$tmp_cls1 = $val[class1];
				$tmp_group[$tmp_cls1][classid] = $tmp_cls1;
				$tmp_group[$tmp_cls1][class_name] = $val[class1_name];
				$tmp_group[$tmp_cls1][ROW][] = $val;
				
		    }
		    
			unset($result);	// 節省一點點記憶體

			$tmp_group = array_values($tmp_group);	// 去掉index方便layout顯示
			

			$op[pds] = $tmp_group;		    

		}
		elseif ($this->CFG[DB_BROWSE_LAYOUT_STYLE]=="group" && isset($this->CFG[DB_BROWSE_LAYOUT_STYLE_KEY])) {
			$tmp_group = array();
			$tmp_str = $this->CFG[DB_BROWSE_LAYOUT_STYLE_KEY];
																# 如果是 class內的內容的話
																# 找出來!
			foreach ($this->CFG[DB_CLASS_DEF] AS  $key=>$val  ) {
			    if ($val[col_name] == $tmp_str) {
					$db_class_name = $val[name];		        
			    }
			} // end foreach
			
			
			foreach ($result AS  $key=>$val  ) {
				$tmp_key = $val[$tmp_str];
				$tmp_group[$tmp_key][GROUP_KEY] = $tmp_key;
				if (isset($db_class_name)) {
				    $tmp_group[$tmp_key][GROUP_NAME] = $this->db_class_data[$db_class_name][$tmp_key];
				}
				$tmp_group[$tmp_key][ROW][] = $val;		
		    }
		    
			unset($result);	// 節省一點點記憶體

			$tmp_group = array_values($tmp_group);	// 去掉index方便layout顯示
			$op[pds] = $tmp_group;	
		}
		else {
			
			$op[pds] = $result;		    
		}


		$op[search_title] = $search_title;
		$op[show_category] = $show_category;

		$op = array_merge($op,$srh->get_result_info());		


		return $op;

	}


	
	##########################################################################################
	# FUNCTION NAME: get_db_detail
	#
	# FUNCTION DESCRIPTION:
	#				取得商品的詳細資料
	#
	# @param		$id
	#				$mode:	0 :	IS_ONWEB = 1 的商品
	#						1 : 全部商品
	#
	# @version      1.0.0
	# @since        2002/01/26
	# @return       $row / F
	#
	
		
	function get_db_detail($id=0 , $mode="") {
		$sql = $this->sql;
		$table = $this->table;
	    
		if (!$id) {
			$this->msg->add("錯誤!!您沒有指定編號");
		    return false;
		}



		switch ($mode) {
		    case "IS_ONWEB":
				$tmp_status = $this->CFG[DB_STATUS_DEF][IS_ONWEB];
				$q_str = "SELECT * FROM $table WHERE id='$id' and (status & '$tmp_status' )!=0";
				break;
		    case "NOT_DELETED":
				$tmp_status = $this->CFG[DB_STATUS_DEF][IS_DELETED];
				$q_str = "SELECT * FROM $table WHERE id='$id' and (status & '$tmp_status' )=0";
				break;
			default:
				$q_str = "SELECT * FROM $table WHERE id='$id' ";
				break;
		} //end switch


		if (!$q_result = $sql->query($q_str)) {
			$this->msg->add("錯誤! 無法存取資料庫!");
			$this->msg->merge($sql->msg);
			return false;    
		}

		if (!$row= $sql->fetch($q_result)) {
			$this->msg->add("錯誤! 無此資料。 資料編號 :$id!");
			return false;		    
		}

		$row = $this->decode_db_data($row);


		return $row;

	} // end func

	
	#######################################################################################
	# FUNCTION NAME: get_db_detail_by
	#
	# FUNCTION DESCRIPTION:
	#				取得欄位符合指定條件的商品詳細資料
	#
	# @param		$field :				指定欄位
	#						$value :			指定值
	#						$mode:			default(全部商品)/ IS_ONWEB(上網狀態為1)/NOT_DELETED(未被刪除狀態)
	#
	# @version      1.0.0
	# @since        2003/07/04
	# @return       $row / F
	#
	
		
	function get_db_detail_by($field , $value,$mode="") {

		$sql = $this->sql;
		$table = $this->table;
	    
		if (!$field) {
			$this->msg->add("錯誤!!您沒有指定欄位名稱");
		    return false;
		}

		if (!$value) {
			$this->msg->add("錯誤!!您沒有指定欄位內容");
		    return false;
		}


		switch ($mode) {
		    case "IS_ONWEB":
				$tmp_status = $this->CFG[DB_STATUS_DEF][IS_ONWEB];
				$q_str = "SELECT * FROM $table WHERE {$field}='{$value}' and (status & '$tmp_status' )!=0";
				break;
		    case "NOT_DELETED":
				$tmp_status = $this->CFG[DB_STATUS_DEF][IS_DELETED];
				$q_str = "SELECT * FROM $table WHERE {$field}='{$value}' and (status & '$tmp_status' )=0";
				break;
			default:
				$q_str = "SELECT * FROM $table WHERE {$field}='{$value}'";
				break;
		} //end switch


		if (!$q_result = $sql->query($q_str)) {
			$this->msg->add("錯誤! 無法存取資料庫!");
			$this->msg->merge($sql->msg);
			return false;    
		}

		if (!$row= $sql->fetch($q_result)) {
			$this->msg->add("錯誤! 資料庫中找不到您所輸入的資料: {$value}。");
			return false;		    
		}
		elseif($sql->num_rows($q_result)>1){
			$this->msg->add("錯誤! 有多筆資料符合您所輸入的條件。");
			$this->msg->add("請重新設定條件。");
			return false;		    
		}

		$row = $this->decode_db_data($row);


		return $row;

	} // end func

	##############################################################################################
	# FUNCTION NAME: db_add
	#
	# FUNCTION DESCRIPTION: 
	#				新增商品資料
	#
	# @param		$argv 
	#					要傳入的key有		1. $this->CFG[DB_COLS_INSERT]中所定義的KEY
	#									2. image_file : 產品圖檔
	#				
	#
	# @version      1.0.0
	# @since        2002/01/26
	# @return       T/F
	#
	
	function db_add($argv) {
		$sql = $this->sql;
		$table = $this->table;

		
												# 檢查變數
												# 使用$this->CFG[DB_COLS_INSERT]
												# 搭配 chk_var_type
		$err_msg = array();
		
		foreach ($this->CFG[DB_COLS_INSERT] AS  $key=>$val  ) {
		    
			if (isset($argv[$key])) {	$chk_flag = $this->chk_var_type($argv[$key], $val[CHK]); }
			else {  $chk_flag = true;	}
		
			if (!$chk_flag) {
			    $err_msg[] = (isset($val[MSG]))? $val[MSG] : "格式錯誤：KEY:".$argv[$key];
			}

		}
		
		if (count($err_msg)) {
			foreach ($err_msg AS  $key=>$val  ) {
			    $this->msg->add($val);
			}
			
		    return false;
		}

    

		
															# 製作要INSERT的SQL字串
		
		$q_str = "INSERT INTO $table (";

		$ins_ary = array();

		foreach ($this->CFG[DB_COLS_INSERT] AS  $key=>$val  ) {
			if (isset($argv[$key])) {	// 要在$argv中有設定的才丟進去
			    #$ins_ary[$key] = $argv[$key];			    
				if ($argv[$key] === false) {  $ins_ary[$key] = "NULL"; }		// 如果是 false的話填入NULL
				else {	$ins_ary[$key] = "'".$argv[$key]."'";	}

			}

		}
		

																# STATUS部份:
																# 當 status_ary為array時
																# 使用 and/or encode
																# ADD時只管 positive!

		if (is_array($argv[status_ary])) {
			$upd_status_str = "";
			$upd_status_bit_positive = 0;						#    把 正的跟負的分開放
			$upd_status_bit_negative = 0;
			foreach ($argv[status_ary] AS  $key=>$val  ) {
//print "$key ==> $val <BR>";
				if (isset($this->CFG[DB_STATUS_DEF][$key])) {
					$tmp_status_bit = $this->CFG[DB_STATUS_DEF][$key];
					if ($val) {
					    $upd_status_bit_positive |= $tmp_status_bit;
					}
					else {
					    $upd_status_bit_negative |= $tmp_status_bit;
					    
					}
				    
				}
			} // end foreach		
		}
																# 如果有 upd_status_bit_positive
																# 放入對應的字串
																# 要沒有設定 status的情況下
																# 才套用 status_ary的設定

		if ($upd_status_bit_positive && !isset($ins_ary[status])) {
			$ins_ary[status] = $upd_status_bit_positive;		    
		}



		$q_str .= join(",",array_keys($ins_ary));
		$q_str .= ") VALUES (";
		$q_str .= join(" , ",array_values($ins_ary));
		$q_str .= ")";

		if ($this->debug) {
			print "<P>[DB_DEBUG] q_str : ".PIPPERL_dv($q_str );		   
		}

		if (!$q_result = $sql->query($q_str)) {
			$this->msg->add("錯誤! 無法新增資料進資料庫!");
			$this->msg->merge($sql->msg);
			return false;    
		}


															# 處理上傳圖樣
		$id = $sql->insert_id();

/*

		if (($upload_img = $argv[image_file][tmp_name])!="none") {

													
													
			$image_orginal_filename = basename($argv[image_file][name]);

			$tmp_exts = split("\.",$image_orginal_filename);

			$image_filename_ext = strtolower(array_pop($tmp_exts));

			unset($tmp_exts);
			$image_orginal_type = $argv[image_file][type];
			list($image_type1,$image_type2) = split("/",$image_orginal_type);
			if ($image_type1 != "image") {
			    $this->msg->add("錯誤! 上傳的檔案格式不是圖檔");
				return false;
			}

			$id= $argv[id];

			if (!$id) {
				$this->msg->add("錯誤! 無法自引數中取得id此變數(\$argv[])中無此變數!");
				
				return false;    
			    
			}

//			$img_loc = $this->CFG[PRODUCT_IMAGE_LOC_ADMIN]."/".$id.".".$image_type2;
			$img_loc = $this->CFG[PRODUCT_IMAGE_LOC_ADMIN]."/".$id.".".$image_filename_ext;


			if (!is_uploaded_file($upload_img)) {
				$this->msg->add("錯誤!!上傳的產品圖檔不正確(系統找不到該檔)");
				return false;		    	    			    
			    
			}
													# 把舊的檔案KO掉
													# 可能有好幾種type
													# 見$this->CFG[PRODUCT_IAMGE_POSSIBLE_TYPE]
			foreach ($this->CFG[PRODUCT_IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
			    $fname_tmp = $this->CFG[PRODUCT_IMAGE_LOC_ADMIN]."/".$id.".".$val;
//DEBUG:
//print "<P>[DEBUG]  : ".D_dv($fname_tmp );

				if (file_exists($fname_tmp)) {
			        if (!unlink($fname_tmp)) {
						$this->msg->add("錯誤!!無法刪除原有的產品圖檔");
						return false;		    	    			    			            
			        }
					clearstatcache();
			    }
			} // end foreach
		

			if (!move_uploaded_file($upload_img,$img_loc) ) {
				$this->msg->add("錯誤! 無法寫入商品圖檔!");
				return false;    
			}		

			if (!chmod($img_loc,0666)) {
			    $this->msg->add("錯誤! 無法更改商品圖檔檔案權限!");
				return false;
			}
		}
*/
		$this->new_item_id = $id;

		return true;
		
	} // end func


	
	##############################################################################################
	# FUNCTION NAME:	get_new_id
	#
	# FUNCTION DESCRIPTION:
	#				取得新增資料庫之後的ID
	#
	# @param		
	#
	# @version      1.0.0
	# @since        2002/06/30
	# @return       void
	#
	
	function get_new_id() {
	    return $this->new_item_id;
	} // end func

	
	
	##############################################################################################
	# FUNCTION NAME: db_modify
	#
	# FUNCTION DESCRIPTION: 
	#				修改商品資料
	#
	# @param		$argv 
	#					要傳入的key有		1. $this->CFG[PRODUCT_COLS_INSERT]中所定義的KEY
	#									2. image_file : 產品圖檔
	#				
	#
	# @version      1.0.0
	# @since        2002/01/26
	# @return       T/F
	#
	
	function db_modify($argv) {
		$sql = $this->sql;
		$table = $this->table;


												# 檢查變數
												# 使用$this->CFG[DB_COLS_UPDATE]
												#   及$this->CFG[DB_COLS_UPDATE_KEY]
												# 搭配 chk_var_type
		$err_msg = array();
		
//DEBUG:
//print "<P>[DEBUG] argv:".D_dv($argv);

		foreach ($this->CFG[DB_COLS_UPDATE] AS  $key=>$val  ) {

			if (isset($argv[$key])) {
				$chk_flag = $this->chk_var_type($argv[$key], $val[CHK]);			    
			}
			else {
			  $chk_flag = true;
			}
		

			if (!$chk_flag) {
			    $err_msg[] = $val[MSG];

			}

		}

		foreach ($this->CFG[DB_COLS_UPDATE_KEY] AS  $key=>$val  ) {
		    
			$chk_flag = $this->chk_var_type($argv[$key], $val[CHK]);

			if (!$chk_flag) {
			    $err_msg[] = $val[MSG];

			}

		}
		

		if (count($err_msg)) {
			foreach ($err_msg AS  $key=>$val  ) {
			    $this->msg->add($val);
			}
			

		    return false;
		}


																# STATUS部份:
																# 當 status為array時
																# 使用 and/or encode
		if (is_array($argv[status])) {
			$upd_status_str = "";
			$upd_status_bit_positive = 0;						#    把 正的跟負的分開放
			$upd_status_bit_negative = 0;
			foreach ($argv[status] AS  $key=>$val  ) {
//print "$key ==> $val <BR>";
				if (isset($this->CFG[DB_STATUS_DEF][$key])) {
					$tmp_status_bit = $this->CFG[DB_STATUS_DEF][$key];
					
					if ($val) {
					    $upd_status_bit_positive |= $tmp_status_bit;
					}
					else {
					    $upd_status_bit_negative |= $tmp_status_bit;
					    
					}
				    
				}
			} // end foreach		

			unset($argv[status]);
		}
		
																# STATUS部份:
																# 當 status_ary為array時
																# 使用 and/or encode
		if (is_array($argv[status_ary])) {
			$upd_status_str = "";
			$upd_status_bit_positive = 0;						#    把 正的跟負的分開放
			$upd_status_bit_negative = 0;
			foreach ($argv[status_ary] AS  $key=>$val  ) {
//print "$key ==> $val <BR>";
				if (isset($this->CFG[DB_STATUS_DEF][$key])) {
					$tmp_status_bit = $this->CFG[DB_STATUS_DEF][$key];
					
					if ($val) {
					    $upd_status_bit_positive |= $tmp_status_bit;
					}
					else {
					    $upd_status_bit_negative |= $tmp_status_bit;
					    
					}
				    
				}
			} // end foreach		
		}

		
															# 製作要update 的SQL字串
		
		$q_str = "UPDATE $table SET ";

		$upd_ary = array();
		$upd_key_ary = array();

		foreach ($this->CFG[DB_COLS_UPDATE] AS  $key=>$val  ) {
			if (isset($argv[$key])) {	// 要在$argv中有設定的才丟進去
				if ($argv[$key] === false) {  $upd_ary[] = $key."=NULL"; }		// 如果是 false的話填入NULL
				else {	$upd_ary[] = $key."='".$argv[$key]."'";	}
			}
		}
																# 如果有 upd_status_bit_positive
																# 放入對應的字串
		if ($upd_status_bit_positive) {
			$upd_ary[] = "status = status | $upd_status_bit_positive";		    
		}

																# 如果有 upd_status_bit_negative
																# 放入對應的字串
		if ($upd_status_bit_negative) {
			$upd_ary[] = "status = status & ~".$upd_status_bit_negative;		    
		}
																


		foreach ($this->CFG[DB_COLS_UPDATE_KEY] AS  $key=>$val  ) {			
				$upd_key_ary[] = $key."='".$argv[$key]."'";
		}


		$q_str .= join(" , ",$upd_ary);

		$q_str .= " WHERE ".join(" AND ",$upd_key_ary);
		

//DEBUG:
//print "<P>[DEBUG] q_str".D_dv($q_str );
//return true;
		if ($this->debug) {
			print "<P>[DB_DEBUG] q_str : ".PIPPERL_dv($q_str );		   
		}

		if (!$q_result = $sql->query($q_str)) {
			$this->msg->add("錯誤! 無法更新資料進資料庫!");
			$this->msg->merge($sql->msg);
			return false;    
		}


/*															# 處理上傳圖樣
		

		if (($upload_img = $argv[image_file][tmp_name])!="none") {
//print "upload: $upload_img";		    

													
													
			$image_orginal_filename = basename($argv[image_file][name]);
//DEBUG:
//print "<P>[DEBUG]  image_original_filename: ".D_dv($image_orginal_filename );

			$tmp_exts = split("\.",$image_orginal_filename);
//DEBUG:
//print "<P>[DEBUG]  tmp_exts: ".D_dv($tmp_exts );

			$image_filename_ext = strtolower(array_pop($tmp_exts));
//DEBUG:
//print "<P>[DEBUG]  image_filename_ext: ".D_dv($image_filename_ext );

			unset($tmp_exts);
//return true;
			$image_orginal_type = $argv[image_file][type];
			list($image_type1,$image_type2) = split("/",$image_orginal_type);
			if ($image_type1 != "image") {
			    $this->msg->add("錯誤! 上傳的檔案格式不是圖檔");
				return false;
			}

			$id= $argv[id];

			if (!$id) {
				$this->msg->add("錯誤! 無法自引數中取得id此變數(\$argv[])中無此變數!");
				
				return false;    
			    
			}

//			$img_loc = $this->CFG[PRODUCT_IMAGE_LOC_ADMIN]."/".$id.".".$image_type2;
			$img_loc = $this->CFG[PRODUCT_IMAGE_LOC_ADMIN]."/".$id.".".$image_filename_ext;


			if (!is_uploaded_file($upload_img)) {
				$this->msg->add("錯誤!!上傳的產品圖檔不正確(系統找不到該檔)");
				return false;		    	    			    
			    
			}
		

													# 把舊的檔案KO掉
													# 可能有好幾種type
													# 見$this->CFG[PRODUCT_IAMGE_POSSIBLE_TYPE]
			foreach ($this->CFG[PRODUCT_IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
			    $fname_tmp = $this->CFG[PRODUCT_IMAGE_LOC_ADMIN]."/".$id.".".$val;
//DEBUG:
//print "<P>[DEBUG]  : ".D_dv($fname_tmp );

				if (file_exists($fname_tmp)) {
			        if (!unlink($fname_tmp)) {
						$this->msg->add("錯誤!!無法刪除原有的產品圖檔");
						return false;		    	    			    			            
			        }
					clearstatcache();
			    }
			} // end foreach
			


			if (!move_uploaded_file($upload_img,$img_loc) ) {
				$this->msg->add("錯誤! 無法寫入商品圖檔!");
				return false;    
			}		

			if (!chmod($img_loc,0666)) {
			    $this->msg->add("錯誤! 無法更改商品圖檔檔案權限!");
				return false;
			}
		}
*/		

		return true;


	    
	} // end func


	
	##############################################################################################
	# Short description:
	#
	# Detail description:
	# @param     
	# @since     1.0
	# @return    void
	#
	function db_delete($id) {
		$sql = $this->sql;
		$table = $this->table;

		if (!$id) {
			$this->msg->add("錯誤!!您沒有指定要刪除資料的id");
		    return false;		    
		}

		$q_str = "DELETE FROM $table WHERE id='$id' ";

		if (!$q_result = $sql->query($q_str)) {
			$this->msg->add("錯誤! 無法刪除資料庫中的資料!(ID: $id )");
			$this->msg->merge($sql->msg);
			return false;    
		}

														# 砍圖
												# 把舊的檔案KO掉
												# 可能有好幾種type
												# 見$this->CFG[PRODUCT_IAMGE_POSSIBLE_TYPE]
/*		foreach ($this->CFG[PRODUCT_IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
			$fname_tmp = $this->CFG[PRODUCT_IMAGE_LOC_ADMIN]."/".$id.".".$val;

			if (file_exists($fname_tmp)) {
				if (!unlink($fname_tmp)) {
					$this->msg->add("錯誤!!無法刪除產品圖檔");
					$this->msg->add("檔名： ".$fname_tmp." 。");

					return false;		    	    			    			            
				}
				clearstatcache();
			}
		} // end foreach

*/		    
		

	    return true;
	} // end func



	##############################################################################################
	# FUNCTION NAME: chk_var_type
	#
	# FUNCTION DESCRIPTION:
	#				檢查資料的格式
	#
	# @param		$str : 要檢查的變數
	#				$type: 要檢查的型態定義
	#
	# @version      1.0.0
	# @since        2002/01/26
	# @return       T/F
	#
	function chk_var_type($str,$type) {
	//DEBUG:
	//print "<P>[DEBUG] str:".D_dv($str );
	//DEBUG:
	//print "<P>[DEBUG] type".D_dv($type );

														# 字串型態定義
														#				B	可空白
														#				!B	不可空白
														#				N	可為數字
														#				!N	不可為數字	  
														#				D	可為日期
														#				DT  可為日期+時間
														#				AA	預設Accept Any
														#				DA	預設Deny Any

		$tp_ary = split(",",$type);	// 分離出type內容並處理
		$flag_if_AA = 0;	// 用來測試 AA (Accept Any)
		$flag_if_DA = 1;	// 用來測試 DA (Deny Any)
		$flag_choose_AA = 1;	// 選擇是否用AA (DA=0)
	//DEBUG:
	//print "<P>[DEBUG] tp_ary".D_dv($tp_ary );

		foreach ($tp_ary AS  $key=>$val  ) {
			$val = strtoupper(trim($val));
			switch ($val) {
				case "B":	// 可空白
					$flag_if_AA |= 1;
					//$flag_if_DA &= 1;
					break;

				case "!B":	// 不可空白
					if (trim($str)=='' || is_null($str) || !isset($str)) {
						//$flag_if_AA |= 0;
						$flag_if_DA &= 0;
					}
					else {
						$flag_if_AA |= 1;
						//$flag_if_DA &= 1;				    
					}
					break;

				case "N":	// 可為數字
	//DEBUG:
	//print "<P>[DEBUG] test here!! : ".$str;

					if (is_numeric($str)) {
						$flag_if_AA |= 1;
						//$flag_if_DA &= 1;

					}
					else {
						//$flag_if_AA |= 0;
						$flag_if_DA &= 0;				    
					}
					break;

				case "!N":	// 不可為數字
					if (!is_numeric($str)) {
						$flag_if_AA |= 1;
						//$flag_if_DA &= 1;
					}
					else {
						//$flag_if_AA |= 0;
						$flag_if_DA &= 0;				    
					}
					break;

				case "D":	// 可為日期
					$test_flag = 0 ;
	//DEBUG:
	//print "<P>[DEBUG] date : ".D_dv($str );

															# case: yy/mm/dd
					if (preg_match("/^(\d{2,4})[\/\-](\d{1,2})[\/\-](\d{1,2})$/",$str,$matches)) {	
						$test_flag = 1;
	//DEBUG:
	//print "<P>[DEBUG] Got date!  ";

						if ($matches[2] <1 || $matches[2]>2100) { // 假設不會用超過2100年:p
							$test_flag = 0;				        
						}

						if ($matches[2] >100 && $matches[2]<999) { // 把三位數的西元去掉
							$test_flag = 0;				        
						}
						


						if ($matches[2] <1 || $matches[2]>12) {
							$test_flag = 0;				        
						}
						
						if ($matches[3] < 1) {
							$test_flag = 0;
						}

						if (in_array($matches[2], array(1,3,5,7,8,10,12)) && $matches[3] >31) {
							$test_flag = 0;
						}

						if (in_array($matches[2], array(2,4,6,9,11)) && $matches[3] >30) {
							$test_flag = 0;
						}

					}		



					if ($test_flag) {
						$flag_if_AA |= 1;
						//$flag_if_DA &= 1;
					}
					else {
						//$flag_if_AA |= 0;
						$flag_if_DA &= 0;				    
					}
					break;

				case "DT":	// 可為日期+時間
					$test_flag = 0 ;
															# case: yy/mm/dd H:i:s
					if (preg_match("/^(\d{2,4})[\/\-](\d{1,2})[\/\-](\d{1,2})\s+(\d{1,2})\:(\d{1,2})\:(\d{1,2})$/",$str,$matches)) {	
						$test_flag = 1;
	//DEBUG:
	//print "<P>[DEBUG] Got date!  ";

						if ($matches[2] <1 || $matches[2]>2100) { // 假設不會用超過2100年:p
							$test_flag = 0;				        
						}

						if ($matches[2] >100 && $matches[2]<999) { // 把三位數的西元去掉
							$test_flag = 0;				        
						}						

						if ($matches[2] <1 || $matches[2]>12) {
							$test_flag = 0;				        
						}
						
						if ($matches[3] < 1) {
							$test_flag = 0;
						}

						if (in_array($matches[2], array(1,3,5,7,8,10,12)) && $matches[3] >31) {
							$test_flag = 0;
						}

						if (in_array($matches[2], array(2,4,6,9,11)) && $matches[3] >30) {
							$test_flag = 0;
						}

						if ($matches[4] <0 || $matches[4]>23) {
							$test_flag = 0;				        
						}

						if ($matches[5] <0 || $matches[5]>59) {
							$test_flag = 0;				        
						}
						if ($matches[6] <0 || $matches[6]>59) {
							$test_flag = 0;				        
						}

					}		



					if ($test_flag) {
						$flag_if_AA |= 1;
						//$flag_if_DA &= 1;
					}
					else {
						//$flag_if_AA |= 0;
						$flag_if_DA &= 0;				    
					}
					break;

				case "AA" : // Accept Any
					$flag_choose_AA = 1;
					break;

				case "DA" : // Deny Any
					$flag_choose_AA = 0;
					break;


			} //end switch
	//DEBUG:
	//print "<P>[DEBUG] <HR>";


		
		} // end foreach
		
		if ($flag_choose_AA) {
			return $flag_if_AA;
		}
		else {
			return $flag_if_DA;
		}
		
		


	} // end func
	



	#######################################################################################
	# FUNCTION NAME: upload_image
	#
	# FUNCTION DESCRIPTION:
	#										上傳圖檔
	#
	# @parm			file $file				 : 上傳檔案
	#						$basename : output圖檔名稱
	#
	# @version      1.0.0
	# @since        2003/05/20
	# @return       T/F
	#

	function upload_image($file,$basename,$overwrite=true,$is_upload=true)
	{

			$f = $file;

			if($is_upload):
				// 檢查檔案是否可上傳
				if (!is_uploaded_file($f[tmp_name])) {
					$this->msg->add("處理商品圖片時發生錯誤!!");
					$this->msg->add("錯誤訊息:上傳的產品圖檔不正確(系統找不到該檔)");
					return false;
				}
			endif;

			// 檢查上傳檔案格式
			$image_original_type = $f[type];
			list($image_type1,$image_type2) = split("/",$image_original_type);
			if ($image_type1 != "image") {
				$this->msg->add("處理商品圖片時發生錯誤!!");
				$this->msg->add("錯誤訊息:上傳的檔案格式不是圖檔");
				return false;
			}

			$image_original_filename = basename($f[name]);
			$tmp_exts = split("\.",$image_original_filename);
			$image_filename_ext = strtolower(array_pop($tmp_exts));
			$img_loc = $this->CFG[IMAGE_LOC_ADMIN]."/".$basename.".".$image_filename_ext;
			$icon_loc= $this->CFG[ICON_LOC_ADMIN]."/".$basename.".".$image_filename_ext;	
			$imginfo=getimagesize($f[tmp_name]);

			// 若檔案不可覆寫, 則檢查檔案是否存在
			if(!$overwrite):
				if(file_exists($img_loc)):
					$this->msg->add("錯誤訊息:檔案已經存在! 您沒有覆寫的權限!");
					return false;
				endif;
			endif;
		

			// 檢查圖檔是否有寬度限制
			if($this->CFG[IMAGE_WIDTH_CONSTRAINT] && $imginfo[0]>$this->CFG[IMAGE_WIDTH_CONSTRAINT]):
				if($imginfo[2]<>2 && $imginfo[2]<>3 ):		// 圖檔超過限制, 且系統無法自動產生小圖
					$this->msg->add("錯誤訊息: 圖檔寬度超過限制!");
					$this->msg->add("由於您上傳的檔案不是JPEG或PNG格式, 系統無法自動為您縮小圖檔!");
					return false;
				endif;
				$width=$this->CFG[IMAGE_WIDTH_CONSTRAINT];
				$height=($width/(double)$imginfo[0])*$imginfo[1];
				$oriwidth=$width;
				$oriheight=$height;
			else:
				$oriwidth=$imginfo[0];
				$oriheight=$imginfo[1];
			endif;

			// 檢查圖檔是否有高度限制
			if($this->CFG[IMAGE_HEIGHT_CONSTRAINT] && $oriheight>$this->CFG[IMAGE_HEIGHT_CONSTRAINT]):
				if($imginfo[2]<>2 && $imginfo[2]<>3 ):		// 圖檔超過限制, 且系統無法自動產生小圖
					$this->msg->add("錯誤訊息: 圖檔高度超過限制!");
					$this->msg->add("由於您上傳的檔案不是JPEG或PNG格式, 系統無法自動為您縮小圖檔!");
					return false;
				endif;
				$width=$this->CFG[IMAGE_WIDTH_CONSTRAINT];
				$height=($width/(double)$oriwidth)*$oriheight;
			endif;



			// 刪除舊有檔案
			foreach ($this->CFG[IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
			    $fname_tmp = $this->CFG[IMAGE_LOC_ADMIN]."/".$basename.".".$val;
				if (file_exists($fname_tmp)) {
			        if (!unlink($fname_tmp)) {
						$this->msg->add("無法刪除原有的產品圖檔");
						$this->msg->add("系統將於五秒後帶您回到編輯畫面");
						return false;
			        }
					clearstatcache();
			    }
			} // end foreach


			// 若圖檔超過限制, 則自動縮小圖(目前只支援Jpg,及Png兩種格式)
			if($width):
				$im=imageresize($f[tmp_name],$imginfo,$width,$height,$this->CFG[IMAGE_BGCOLOR],$this->CFG[IMAGE_MODE]);

				if($this->debug):
					$img_loc="";
				endif;

				if($im):
					if($imginfo[2]==2):
						imageJPEG($im,$img_loc,95);
					else:
						imagePNG($im,$img_loc);
					endif;
				endif;

			// 若上傳圖檔大小於限制範圍內, 直接另存檔案
			elseif (!copy($f[tmp_name],$img_loc) ) :
				$this->msg->add("錯誤訊息:無法寫入商品圖檔!");
				$this->msg->add("系統將於五秒後帶您回到編輯畫面");
				return false;
			endif;

			// 設定圖檔權限		
			if (!chmod($img_loc,0666)) :
					$this->msg->add("處理商品圖片時發生錯誤!!");
					$this->msg->add("錯誤訊息:無法更改商品圖檔檔案權限!");
					return false;
			endif;

			// 自動產生小圖示
			if($this->CFG[ICON_WIDTH_CONSTRAINT] || $this->CFG[ICON_HEIGHT_CONSTRAINT]):


				if($imginfo[0]>$this->CFG[ICON_WIDTH_CONSTRAINT] && $this->CFG[ICON_WIDTH_CONSTRAINT]):
					$width=$this->CFG[ICON_WIDTH_CONSTRAINT];
					$height=($width/(double)$imginfo[0])*$imginfo[1];
				else:
					$width=$imginfo[0];
					$height=$imginfo[1];
				endif;

				$oriwidth=$width;
				$oriheight=$height;

				if($oriheight>$this->CFG[ICON_HEIGHT_CONSTRAINT] && $this->CFG[ICON_HEIGHT_CONSTRAINT]):
					$height=$this->CFG[ICON_HEIGHT_CONSTRAINT];
					$width=($height/(double)$oriheight)*$oriwidth;
				else:
					$width=$oriwidth;
					$height=$oriheight;
				endif;

				// 刪除舊有小圖示
				foreach ($this->CFG[IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
					$fname_tmp = $this->CFG[ICON_LOC_ADMIN]."/".$basename.".".$val;
					if (file_exists($fname_tmp)) {
						if (!unlink($fname_tmp)) {
							$this->msg->add("無法刪除原有的小圖示");
							$this->msg->add("系統將於五秒後帶您回到編輯畫面");
							return false;
						}
						clearstatcache();
					}
				} // end foreach

				$im=imageresize($f[tmp_name],$imginfo,$width,$height,$this->CFG[ICON_BGCOLOR],$this->CFG[IMAGE_MODE]);
				if($im):
					if($imginfo[2]):
						imageJPEG($im,$icon_loc,95);
					else:
						imagePNG($im,$icon_loc);
					endif;
				endif;

				

			endif;



		return true;

	}	//end func


	#########################################################################################
	# FUNCTION NAME: upload_image
	#
	# FUNCTION DESCRIPTION:
	#				刪除圖檔
	#
	# @parm			$basename: 主檔名
	#
	# @version      1.0.0
	# @since        2003/05/20
	# @return       T/F
	#

	function delete_image($basename)
	{

			foreach ($this->CFG[IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
			    $fname_tmp = $this->CFG[IMAGE_LOC_ADMIN]."/".$basename.".".$val;
				if (file_exists($fname_tmp)) {
			        if (!unlink($fname_tmp)) {
						$this->msg->add("錯誤訊息:無法刪除原有的產品圖檔");
						return false;
					}
					clearstatcache();
			    }
			} // end foreach

			foreach ($this->CFG[IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
			    $fname_tmp = $this->CFG[ICON_LOC_ADMIN]."/".$basename.".".$val;
				if (file_exists($fname_tmp)) {
			        if (!unlink($fname_tmp)) {
						$this->msg->add("錯誤訊息:無法刪除原有的產品小圖示");
						return false;
					}
					clearstatcache();
			    }
			} // end foreach

			return true;

	}	//end func


	#########################################################################################
	# FUNCTION NAME: get_image
	#
	# FUNCTION DESCRIPTION:
	#				取得圖檔
	#
	# @parm			$basename : 圖檔主檔名
	#						$count:		   若同時有多個圖檔時,可指定產品可能的圖檔數量
	#
	# @version      1.0.0
	# @since        2003/05/20
	# @return       $img_links
	#
	function get_image($basename,$count=0)
	{
			$http_access=$this->CFG[IMAGE_LOC_HTTP]?$this->CFG[IMAGE_LOC_HTTP]:$this->CFG[IMAGE_LOC_ADMIN]."/";

			if($count):
				for($i=1;$i<=$count;$i++){
					foreach ($this->CFG[IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
					    $fname_tmp = $this->CFG[IMAGE_LOC_ADMIN]."/".$basename."_".$i.".".$val;
						if (file_exists($fname_tmp)) {
							$img_links[$i]=$http_access.$basename."_".$i.".".$val;
						}
					} // end foreach
				

					if(!$img_links[$i]){
						$img_links[$i]=$this->CFG[IMAGE_DEFAULT];
					}

				}
			else:

					foreach ($this->CFG[IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
					    $fname_tmp = $this->CFG[IMAGE_LOC_ADMIN]."/".$basename.".".$val;
						if($this->debug):
							echo $fname_tmp."<br>";
						endif;
						if (file_exists($fname_tmp)) {
							$img_links=$http_access.$basename.".".$val;
						}
					} // end foreach
				

					if(!$img_links){
						$img_links=$this->CFG[IMAGE_DEFAULT];
					}
			
			endif;


			return $img_links;
	} // end func



	#########################################################################################
	# FUNCTION NAME: get_icon
	#
	# FUNCTION DESCRIPTION:
	#				取得小圖示
	#
	# @parm			$basename : 圖檔主檔名
	#						$count:		   若同時有多個圖檔時,可指定產品可能的圖檔數量
	#
	# @version      1.0.0
	# @since        2003/05/20
	# @return       $img_links
	#
	function get_icon($basename,$count=0)
	{

		$http_access=$this->CFG[ICON_LOC_HTTP]?$this->CFG[ICON_LOC_HTTP]:$this->CFG[ICON_LOC_ADMIN]."/";

		if($count):
			for($i=1;$i<=$count;$i++){
				foreach ($this->CFG[IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
				    $fname_tmp = $this->CFG[ICON_LOC_ADMIN]."/".$basename."_".$i.".".$val;
					if (file_exists($fname_tmp)) {
						$img_links[$i]=$http_access.$basename.".".$val;
					}
				} // end foreach

				if(!$img_links[$i]){
					$img_links[$i]=$this->CFG[ICON_DEFAULT];
				}

			} 
		else:
				foreach ($this->CFG[IAMGE_POSSIBLE_TYPE] AS  $key=>$val  ) {
				    $fname_tmp = $this->CFG[ICON_LOC_ADMIN]."/".$basename.".".$val;
					if (file_exists($fname_tmp)) {
						$img_links=$http_access.$basename.".".$val;
					}
				} // end foreach

				if(!$img_links){
					$img_links=$this->CFG[ICON_DEFAULT];
				}

		endif;

			return $img_links;
	} // end func


}



##########################################################################################
#				CLASS DB_SEARCH
#
##########################################################################################
#
# 20020401: 產生給DB專用的SEARCH module，設定ROW_PER_PAGE預設=0(不換頁)
# 20020126: ver 1.4
#			加入 get_result_info()，把常用的資料傳回 中
# 20010713: ver 1.3
#			修改 set_link()的bug，改set_link為set_sql
#			加入send_query2()，加入start_no,row_per_page供add_limit_condition使用
#			
# 20010518: 加入 set_link(),改用MSG_HANDLE,send_query()加入mode=2(傳回所有match的資料)，
# 20010517: 之前不可考....
#
#
##########################################################################################




class DB_SEARCH {


//init()
//add_q_header($q_header_str="")
//add_where_condition($where_condition,$sr_parm_name,$sr_parm_value,$msg)
//add_sort_condition($sort_condition,$sr_sorttype,$msg)
//add_limit_condition($from_no,$row_per_page)
//send_query($mode=0)
//add_cgi_parm($parm_name,$parm_value)
//get_cgi_str($mode=0)
//get_display_msg($mode=0)
//get_sql_link_id()
//get_total_row_num()

	var $sql;
	var $q_result;

    var $where_ary;
	var $cgi_parm_ary;
	var $display_msg_ary;
	var $msg;

	var $q_str;
	var $q_header;
	var $q_sorttype;
	var $q_group_str;
	var $q_having_str;
	var $q_limit;

	
	/**
	 * Description: 從第幾筆資料開始顯示
	 * @var       
	 * @since     1.3
	 * @access    private
	 */
	var $start_no="0";
	
	/**
	 * Description: 一頁要傳回幾筆
	 * @var       
	 * @since     1.3
	 * @access    private
	 */
	var $row_per_page = 0;


	
	##############################################################################################
	# Description: 總共的筆數
	# @var       
	# @since     1.3
	# 
	var $max_no;

	
	##############################################################################################
	# Description: 給browse用，上一頁開始的列
	# @var       
	# @since     1.3
	# 
	var $prev_no ;

	
	##############################################################################################
	# Description:給browse用，下一頁開始的列
	# @var       
	# @since     1.3
	# 
	var $next_no;
	
	##############################################################################################
	# Description: 給browse用，最後一頁開始的列
	# @var       
	# @since     1.3
	# 
	var $last_no ;


	var $max_page ;				# 總共頁數 (2002/01/29)
	var $cur_page ;				# 目前頁數 (2002/01/29)


	##############################################################################################
	# Description: 記錄排序類型
	# @var       
	# @since     2003/10/01
	# 
	var $sorttype ;


	############################################################# 初始化資料庫連結等

																#如果有Link則使用之
																
	function init($server, $user, $passwd, $db,$link=0) {

									# 清空必要的array

		$this->where_ary=array();
		$this->cgi_parm_ary = array();

									# 向下相容
		$this->display_msg_ary = array();


		$sql = new msSQL();						# 依情況而定

		$this->msg = new MSG_HANDLE();

		if ($link) {
			$sql->set_link_id($link);
		}
		else if (!$sql->connect($server, $user, $passwd, $db)) {
			$this->msg->merge($sql->msg);
			return false;
		}



		$this->sql = $sql;
		return true;

	}

################################################################ 傳入弄成的link
	function set_sql($sql) {

		$this->msg = new MSG_HANDLE();

		if (!$sql) {
			$this->msg->add("錯誤! 你沒有指定資料庫連線..");
			return false;
		}

		$this->where_ary=array();
		$this->cgi_parm_ary = array();

		$this->sql = $sql;
		return true;
	}


################################################################# 清理所有buffer #######
	function clean_all_condition() {
		$this->where_ary=array();
		$this->cgi_parm_ary=array();
		$this->msg->clean();
		$this->q_str="";
		$this->q_header="";
		$this->q_sorttype="";
		$this->q_limit="";

		return true;
	}


	############################################################# 寫入q_header_str

	function add_q_header($q_header_str="") {

		if ($q_header_str) {
		
			$this->q_header = $q_header_str;
			return true;

		}
		else  {
		    $this->msg->add("錯誤!! 空白的SQL Header");
			return false;
		}

	}


	############################################################# 寫入where_ary

	function add_where_condition($where_condition,$sr_parm_name=false,$sr_parm_value=false,$msg=0) {
//DEBUG:
//print "<P>[DEBUG]  : $where_condition $sr_parm_name ,$sr_parm_value ,$msg";

		if (!$where_condition) {
		    $this->msg->add("錯誤!! 空白的Where_Str");
			return false;
		}
		$this->where_ary[] = $where_condition;

		if ($sr_parm_name != false && $sr_parm_value !=false) {

			if(is_array($sr_parm_value)):
				foreach($sr_parm_value AS $key=>$val){
					$this->cgi_parm_ary[$sr_parm_name."[]"] = $val;
				}
			else:
				$this->cgi_parm_ary[$sr_parm_name] = $sr_parm_value;
			endif;
		}

		if ($msg) {
			$this->msg->add($msg);
		}

		return true;
	}


	############################################################# 寫入q_sort_str

	function add_sort_condition($sort_condition,$sr_sorttype=0,$msg=0) {

		if (!$sort_condition) {
		    $this->msg->add("錯誤!! 空白的搜尋類別");
			return false;
		}

		$this->q_sorttype = "ORDER BY ".$sort_condition;

		if ($sr_sorttype) {

		//$this->cgi_parm_ary[PHP_sr_sorttype] = $sr_sorttype;
		$this->sorttype=$sr_sorttype;

		}

		if ($msg) {
			$this->display_msg_ary[] = $msg;   
		}



		return true;
	}


	############################################################# 寫入q_group_str

	function add_group_condition($group_condition) {

		if (!$group_condition) {
		    $this->msg->add("錯誤!! 空白的群組類別");
			return false;
		}

		$this->q_group_str = "GROUP BY ".$group_condition;

		return true;
	}

	############################################################# 寫入q_having_str

	function add_having_condition($having_condition) {

		if (!$having_condition) {
		    $this->msg->add("錯誤!! 空白的Having條件");
			return false;
		}

		$this->q_having_str = "HAVING ".$having_condition;

		return true;
	}


	############################################################# 寫入q_limit_str
	#								如果沒有指定 $row_per_page的話，預設不換頁
	#								暫時廢棄
	#
	#
	function add_limit_condition($from_no=0,$row_per_page=0) {

		if ($from_no) {
			$this->start_no = $from_no;		    
		}
		else {
		    $this->start_no = $from_no = 0;
		}

		if (!$row_per_page) {

			$row_per_page = $this->row_per_page;
		}
		else {
       		$this->row_per_page = $row_per_page;

		}

//		if (!$from_no || !$row_per_page) {
//			return false;
//		}
		

		$this->q_limit = "LIMIT ".$from_no.",".$row_per_page;


		return true;
	}
	

	############################################################# 加入CGI用參數
	function add_cgi_parm($parm_name,$parm_value) {

		if (!$parm_name) {
			$this->msg->add("錯誤!! 指定了錯誤的CGI參數，請洽程式設計者解決");
			return false;
		}

		$this->cgi_parm_ary[$parm_name]=$parm_value;
	
		return true;
	
	}


	############################################################# 執行檢索 (第二代!!)
	#	20020410: 如果sql是 mysql的話，用LIMIT offset,rows 加快速度!!
	#
	#
																
																
	function send_query2() {

										# 做出where_str

		$where_ary = $this->where_ary;
		$start_no = $this->start_no;
		$row_per_page = $this->row_per_page;


										# 檢查是否 mysql
		if (strtolower(get_class($this->sql))=="mysql") {
			$is_mysql = true;
		}
		else {
		    $is_mysql = false;
		}

		if ($where_ary) {
										# 替每個where加上括號，避免誤判
			foreach ($where_ary AS $key=>$val)
			{
				$where_ary[$key]='('.$val.')';
			}
										# 用 AND　把 where連起來
										# 2002/05/12 :
										# 如果 $q_header中已有WHERE的話，則不加WHERE

			if (preg_match('/\sWHERE\s/i',$this->q_header)) {
				$where_str= " AND ".join(" AND ", $where_ary);
		    
			}
			else {
				$where_str= "WHERE ".join(" AND ", $where_ary);
			    
			}


			
		}


										# 作出q_str

		$q_str = $this->q_header . " $where_str ".$this->q_group_str." ".$this->q_having_str." ".$this->q_sorttype;
		$this->q_str = $q_str;

		$sql= $this->sql;
		if (!$sql) {
			$this->msg->add("錯誤!! 資料庫尚未連接");
			return false;
		}
		

										# 如果是mysql用LIMIT加速!
		if ($is_mysql ) {
		    if ($start_no && $row_per_page) {
		        $q_str .= " LIMIT $start_no, $row_per_page";
		    }
			elseif ($row_per_page) {
		        $q_str .= " LIMIT $row_per_page";			    
			}

/*	原先的寫法: 先利用COUNT(*) 取得符合條件的總筆數
//						  再加入LIMIT取的所需的筆數

																# 取得 DATA COUNT (without limit)
			$t = preg_replace("/(select ).+( from .+)LIMIT .+$/i","\\1 COUNT(*) AS COLCNT \\2 ",$q_str);
			$t = preg_replace("/(select .+from .+)ORDER .+$/i","\\1",$t);
			
//DEBUG:
//print "<P>[DEBUG]  : ".PIPPERL_dv($t );
*/

			if($row_per_page): 
				$q_str = preg_replace("/(select )(.+ from .+)$/i","\\1 SQL_CALC_FOUND_ROWS \\2 ",$q_str);
			endif;

		}



//DEBUG:
//print "<P>[DEBUG]:".$t."<BR>";


/*		
																# 先取得 DATA COUNT

		if (!$q_result= $sql->query($t)) {
			$this->msg->add("無法取得符合資料筆數");
			$this->msg->merge($sql->msg);
			return false;
		}
		if (!$t_row = $sql->fetch($q_result)) {
			$t_row[COLCNT] = 0;
#			$this->msg->add("無法取得符合資料筆數");
#			$this->msg->merge($sql->msg);
#			return false;
		}
//DEBUG:
//print "<P>[DEBUG]  : ".PIPPERL_dv($t_row );
		
		$this->max_no = $t_row[COLCNT];
		if (!$this->max_no) {
		    $this->max_no = 0;
		}


		if (!($q_result= $sql->query($q_str))) {
			$this->msg->merge($sql->msg);
			return false;
		}

*/

		if (!($q_result= $sql->query($q_str))) {
			$this->msg->merge($sql->msg);
			return false;
		}

		$this->q_result = $q_result;

		//取得符合條件總筆數
		if($is_mysql && $row_per_page){
			$q_str2="select FOUND_ROWS()";
			if (!($q_result2= $sql->query($q_str2))) {
				$this->msg->merge($sql->msg);
				return false;
			}
			if (!$t_row = $sql->fetch($q_result2)) {
			    $this->max_no = 0;
			}	
			else{
				$this->max_no=$t_row[0]?$t_row[0]:0;
			}
		}
		else{
			$this->max_no=0;
		}


												# 計算並填入有關工具列要用的值
												# 如果 $row_per_page 沒設 (==0)的話
												# 不計算
		if ($row_per_page >0) {
			#$this->max_no = $sql->num_rows($q_result);
			$max_no = $this->max_no;
			$this->prev_no = (($start_no - $row_per_page) >0)?($start_no - $row_per_page) : 0 ;
			$this->last_no = (($max_no-$row_per_page)>0) ?  ($max_no-$row_per_page) : 0;
			$this->next_no =(($start_no + $row_per_page)<$max_no)?($start_no + $row_per_page):$this->last_no ;

			$tmp_num1 = $max_no % $row_per_page;

			$this->max_page = $tmp_num1 ? ($max_no - $tmp_num1 )/ $row_per_page +1 : ($max_no / $row_per_page ) ;
			
			$tmp_num2 = ($start_no  +1 )% $row_per_page;


			$this->cur_page = $tmp_num2 ? ($start_no +1 - $tmp_num2) / $row_per_page + 1  : ($start_no / $row_per_page);
		    
		}


												# 移至開始的那一筆資料
		if ($start_no ) {
			$maxnum = $this->max_no - 1;
			if ($start_no > $maxnum) {			// 檢查並修正超出範圍的start_no
				$start_no = $maxnum;
			}

			if ($start_no < 0) {
				$start_no = 0;
			    
			}

			$this->start_no = $start_no;		// 把修正完的start_no 寫回去


			if (!$is_mysql  || ($is_mysql && !$row_per_page) ) {	// 如果是mysql就省了

				if (!$sql->seek($start_no,$q_result)) {
					$this->msg->add("錯誤!!無法跳至第'$start_no'筆!!");
					return false;
				}			    
			}

		    
		}


												# 傳回所有match的資料(可能很大!!!!)
												# 如果沒有設定row_per_page的話，上限無限大 
											
												# 找時間再寫程式
		$match_limit = $this->row_per_page;

		$match = 0;
		$return_ary = array();


//DEBUG:
//print "<P>[DEBUG] match_limit: $match_limit";



		while ($row = $sql->fetch($q_result)) {
			$return_ary[] = $row;
			$match++;
//DEBUG:
//print "<P>[DEBUG] match: $match";

			if ($match_limit>0 && $match >= $match_limit) {	// 如果match_limit=0的話不設限
				break;
			}

		}
		$sql->free_result($q_result);
		$result =0;
		$this->q_result = $q_result;
			
		return $return_ary;

	
	}

	############################################################# 執行檢索 (第二代!!)
	#	2004/2/2 不支援SQL_CAL_ 時用
	#
	#
																
																
	function send_query2step() {

										# 做出where_str

		$where_ary = $this->where_ary;
		$start_no = $this->start_no;
		$row_per_page = $this->row_per_page;


										# 檢查是否 mysql
		if (strtolower(get_class($this->sql))=="mysql") {
			$is_mysql = true;
		}
		else {
		    $is_mysql = false;
		}

		if ($where_ary) {
										# 替每個where加上括號，避免誤判
			foreach ($where_ary AS $key=>$val)
			{
				$where_ary[$key]='('.$val.')';
			}
										# 用 AND　把 where連起來
										# 2002/05/12 :
										# 如果 $q_header中已有WHERE的話，則不加WHERE

			if (preg_match('/\sWHERE\s/i',$this->q_header)) {
				$where_str= " AND ".join(" AND ", $where_ary);
		    
			}
			else {
				$where_str= "WHERE ".join(" AND ", $where_ary);
			    
			}


			
		}


										# 作出q_str

		$q_str = $this->q_header . " $where_str ".$this->q_group_str." ".$this->q_having_str." ".$this->q_sorttype;
		$this->q_str = $q_str;

		$sql= $this->sql;
		if (!$sql) {
			$this->msg->add("錯誤!! 資料庫尚未連接");
			return false;
		}
		

										# 如果是mysql用LIMIT加速!
		if ($is_mysql ) {
		    if ($start_no && $row_per_page) {
		        $q_str .= " LIMIT $start_no, $row_per_page";
		    }
			elseif ($row_per_page) {
		        $q_str .= " LIMIT $row_per_page";			    
			}

//	原先的寫法: 先利用COUNT(*) 取得符合條件的總筆數
//						  再加入LIMIT取的所需的筆數

																# 取得 DATA COUNT (without limit)
			$t = preg_replace("/(select ).+( from .+)LIMIT .+$/i","\\1 COUNT(*) AS COLCNT \\2 ",$q_str);
			$t = preg_replace("/(select .+from .+)ORDER .+$/i","\\1",$t);
			
		}


		if($row_per_page){
			if (!$q_result= $sql->query($t)) {
				$this->msg->add("無法取得符合資料筆數");
				$this->msg->merge($sql->msg);
				return false;
			}
			if (!$t_row = $sql->fetch($q_result)) {
				$t_row[COLCNT] = 0;
			}
			$this->max_no = $t_row[COLCNT];
			if (!$this->max_no) {
				$this->max_no = 0;
			}
			if (!($q_result= $sql->query($q_str))) {
				$this->msg->merge($sql->msg);
				return false;
			}
		}
		else{
			$this->max_no=0;
		}

		if (!($q_result= $sql->query($q_str))) {
			$this->msg->merge($sql->msg);
			return false;
		}

		$this->q_result = $q_result;



												# 計算並填入有關工具列要用的值
												# 如果 $row_per_page 沒設 (==0)的話
												# 不計算
		if ($row_per_page >0) {
			#$this->max_no = $sql->num_rows($q_result);
			$max_no = $this->max_no;
			$this->prev_no = (($start_no - $row_per_page) >0)?($start_no - $row_per_page) : 0 ;
			$this->last_no = (($max_no-$row_per_page)>0) ?  ($max_no-$row_per_page) : 0;
			$this->next_no =(($start_no + $row_per_page)<$max_no)?($start_no + $row_per_page):$this->last_no ;

			$tmp_num1 = $max_no % $row_per_page;

			$this->max_page = $tmp_num1 ? ($max_no - $tmp_num1 )/ $row_per_page +1 : ($max_no / $row_per_page ) ;
			
			$tmp_num2 = ($start_no  +1 )% $row_per_page;


			$this->cur_page = $tmp_num2 ? ($start_no +1 - $tmp_num2) / $row_per_page + 1  : ($start_no / $row_per_page);
		    
		}


												# 移至開始的那一筆資料
		if ($start_no ) {
			$maxnum = $this->max_no - 1;
			if ($start_no > $maxnum) {			// 檢查並修正超出範圍的start_no
				$start_no = $maxnum;
			}

			if ($start_no < 0) {
				$start_no = 0;
			    
			}

			$this->start_no = $start_no;		// 把修正完的start_no 寫回去


			if (!$is_mysql  || ($is_mysql && !$row_per_page) ) {	// 如果是mysql就省了

				if (!$sql->seek($start_no,$q_result)) {
					$this->msg->add("錯誤!!無法跳至第'$start_no'筆!!");
					return false;
				}			    
			}

		    
		}


												# 傳回所有match的資料(可能很大!!!!)
												# 如果沒有設定row_per_page的話，上限無限大 
											
												# 找時間再寫程式
		$match_limit = $this->row_per_page;

		$match = 0;
		$return_ary = array();


//DEBUG:
//print "<P>[DEBUG] match_limit: $match_limit";



		while ($row = $sql->fetch($q_result)) {
			$return_ary[] = $row;
			$match++;
//DEBUG:
//print "<P>[DEBUG] match: $match";

			if ($match_limit>0 && $match >= $match_limit) {	// 如果match_limit=0的話不設限
				break;
			}

		}
		$sql->free_result($q_result);
		$result =0;
		$this->q_result = $q_result;
			
		return $return_ary;

	
	}


	############################################################# 執行檢索 (測試中!!)
	#	不使用LIMIT
	#
	#
																
																
	function send_query3() {

										# 做出where_str

		$where_ary = $this->where_ary;
		$start_no = $this->start_no;
		$row_per_page = $this->row_per_page;

/*
										# 檢查是否 mysql
		if (get_class($this->sql)=="mysql") {
			$is_mysql = true;
		    
		}
		else {
		    $is_mysql = false;
		}
*/

		if ($where_ary) {
										# 替每個where加上括號，避免誤判
			foreach ($where_ary AS $key=>$val)
			{
				$where_ary[$key]='('.$val.')';
			}
										# 用 AND　把 where連起來
										# 2002/05/12 :
										# 如果 $q_header中已有WHERE的話，則不加WHERE

			if (preg_match('/\sWHERE\s/i',$this->q_header)) {
				$where_str= " AND ".join(" AND ", $where_ary);
		    
			}
			else {
				$where_str= "WHERE ".join(" AND ", $where_ary);
			    
			}


			
		}


										# 作出q_str

		$q_str = $this->q_header . " $where_str ".$this->q_group_str." ".$this->q_sorttype;

		
/*
										# 如果是mysql用LIMIT加速!
		if ($is_mysql ) {
		    if ($start_no && $row_per_page) {
		        $q_str .= " LIMIT $start_no, $row_per_page";
		    }
			elseif ($row_per_page) {
		        $q_str .= " LIMIT $row_per_page";			    
			}

																# 取得 DATA COUNT (without limit)
			$t = preg_replace("/(select ).+( from .+)LIMIT .+$/i","\\1 COUNT(*) AS COLCNT \\2",$q_str);
			$t = preg_replace("/(select .+from .+)ORDER .+$/i","\\1",$t);
			
//DEBUG:
//print "<P>[DEBUG]  : ".PIPPERL_dv($t );

		}

*/

		$this->q_str = $q_str;
//DEBUG:
//print "<P>[DEBUG]:".$t."<BR>";

		$sql= $this->sql;

		if (!$sql) {
			$this->msg->add("錯誤!! 資料庫尚未連接");
			return false;
		}

/*		
																# 先取得 DATA COUNT

		if (!$q_result= $sql->query($t)) {
			$this->msg->add("無法取得符合資料筆數");
			$this->msg->merge($sql->msg);
			return false;
		}
		if (!$t_row = $sql->fetch($q_result)) {
			$t_row[COLCNT] = 0;
#			$this->msg->add("無法取得符合資料筆數");
#			$this->msg->merge($sql->msg);
#			return false;
		}
//DEBUG:
//print "<P>[DEBUG]  : ".PIPPERL_dv($t_row );
		
		$this->max_no = $t_row[COLCNT];
		if (!$this->max_no) {
		    $this->max_no = 0;
		}

*/
		if (!($q_result= $sql->query($q_str))) {
			$this->msg->merge($sql->msg);
			return false;
		}

															#搜尋結果資料總數
		$this->max_no=$sql->num_rows($q_restul);
		
		$this->q_result = $q_result;

												# 計算並填入有關工具列要用的值
												# 如果 $row_per_page 沒設 (==0)的話
												# 不計算
		if ($row_per_page >0) {
			#$this->max_no = $sql->num_rows($q_result);
			$max_no = $this->max_no;
			$this->prev_no = (($start_no - $row_per_page) >0)?($start_no - $row_per_page) : 0 ;
			$this->last_no = (($max_no-$row_per_page)>0) ?  ($max_no-$row_per_page) : 0;
			$this->next_no =(($start_no + $row_per_page)<$max_no)?($start_no + $row_per_page):$this->last_no ;

			$tmp_num1 = $max_no % $row_per_page;

			$this->max_page = $tmp_num1 ? ($max_no - $tmp_num1 )/ $row_per_page +1 : ($max_no / $row_per_page ) ;
			
			$tmp_num2 = ($start_no  +1 )% $row_per_page;


			$this->cur_page = $tmp_num2 ? ($start_no +1 - $tmp_num2) / $row_per_page + 1  : ($start_no / $row_per_page);
		    
		}


												# 移至開始的那一筆資料
		if ($start_no ) {
			$maxnum = $this->max_no - 1;
			if ($start_no > $maxnum) {			// 檢查並修正超出範圍的start_no
				$start_no = $maxnum;
			}

			if ($start_no < 0) {
				$start_no = 0;
			    
			}

			$this->start_no = $start_no;		// 把修正完的start_no 寫回去


			if (!$is_mysql  || ($is_mysql && !$row_per_page) ) {	// 如果是mysql就省了

				if (!$sql->seek($start_no,$q_result)) {
					$this->msg->add("錯誤!!無法跳至第'$start_no'筆!!");
					return false;
				}			    
			}

		    
		}


												# 傳回所有match的資料(可能很大!!!!)
												# 如果沒有設定row_per_page的話，上限無限大 
											
												# 找時間再寫程式
		$match_limit = $this->row_per_page;

		$match = 0;
		$return_ary = array();


//DEBUG:
//print "<P>[DEBUG] match_limit: $match_limit";



		while ($row = $sql->fetch($q_result)) {
			$return_ary[] = $row;
			$match++;
//DEBUG:
//print "<P>[DEBUG] match: $match";

			if ($match_limit>0 && $match >= $match_limit) {	// 如果match_limit=0的話不設限
				break;
			}

		}
		$sql->free_result($q_result);
		$result =0;
		$this->q_result = $q_result;
			
		return $return_ary;

	
	}




	############################################################# 取得CGI用參數字串
																# mode=0 : get用
																# mode=1 : post用
	function get_cgi_str($mode=0) {

		$cgi_parm_ary = $this->cgi_parm_ary;
		


		if ($mode==0) {

			foreach ($cgi_parm_ary AS $key=>$val){
					if(!is_array($val)):
						$cgi_parm_ary[$key] = $key."=".$val;
					else:	// added by dolly
						$parm_str=array();
						foreach($val AS $key2=>$val2){
							$parm_str[]=$key."[]=".$val2;
						}
						$cgi_parm_ary[$key] = join("&",$parm_str);
					endif;
			}
			$url_str=join("&",$cgi_parm_ary);
			$url_str = $GLOBALS[PHP_SELF]."?".$url_str;

			return $url_str;

		}
		else  {
			foreach ($cgi_parm_ary AS $key=>$val){
					if(!is_array($val)):
						$cgi_parm_ary[$key] = '<INPUT TYPE="hidden" NAME="'.$key.'" VALUE="'.$val.'">'."\n";
					else:	// added by dolly
						$parm_str=array();
						foreach($val AS $key2=>$val2){
							$parm_str[]='<INPUT TYPE="hidden" NAME="'.$key.'[]" VALUE="'.$val2.'">'."\n";
						}
						$cgi_parm_ary[$key] = join("",$parm_str);
					endif;
			}
			$url_str=join("",$cgi_parm_ary);
			
			return $url_str;

		}
	

	}



	############################################################## 取得display_msg內的資料
																 # *** 已廢棄!!! 純用來向下相容用!!
																 # *** 請改用$this->msg
																 # mode=0 : HTML格式(預設)
																 # mode=1 : Plain TEXT
																 # mode=2 : HTML格式(RP)


	function get_display_msg($mode=0) {

		foreach ($this->display_msg_ary AS $key=>$val) {
			$this->msg->add($val);
		}

		$msg_html= $this->msg->get(0);
		$msg_text= $this->msg->get(1);
		    

		$return_str="";

		if ($mode == 0 || $mode == 2) {
		
			$return_str .= '<TABLE border=0 cellspacing=5 align="center">'."<TR><TD>\n";
			$return_str .= "$msg_html</TD>\n";
			$return_str .= '<TD>';
												# RF用
			if ($mode==0) {
				$return_str .= '<TABLE border=0 >';

				
				for ($i=0;$i<5 ;$i++) {
				
					$return_str .= '<TR ><TD width="80" BGCOLOR="'.  $GLOBALS["COLOR_level_".$i].'"><font size=2>&nbsp;</font></TD><TD><font size=2>'.$GLOBALS["STR_level_".$i]."</font></TD></TR>\n";
				}
				$return_str .= "</TABLE>";
			}
			else  {								# RP用
				$return_str .= '<TABLE border=0 >';

				
				for ($i=0;$i<4 ;$i++) {
				
					$return_str .= '<TR ><TD width="80" BGCOLOR="'.  $GLOBALS["COLOR_RP_level_".$i].'"><font size=2>&nbsp;</font></TD><TD><font size=2>'.$GLOBALS["STR_RP_level_".$i]."</font></TD></TR>\n";
				}
				$return_str .= "</TABLE>";

			}
			$return_str .= "</TD></TR>";
			$return_str .= "</TABLE>\n";
		}
		else  {

				$return_str = $msg_text;
			
		}

		return $return_str;
	
	}



	############################################################# 取得sql link id

	function get_sql_link_id() {

		return $this->sql;
	
	}


	############################################################# 取得檢索結果總筆數
	function get_total_row_num() {

		$num = $this->send_query(1);

		if (!$num) {
			return false;
		}
		
		return $num;
	
	}


	
	##############################################################################################
	# FUNCTION NAME: get_result_info
	#
	# FUNCTION DESCRIPTION:
	#			把一些常用的資料如cgistr_get/prev_no等傳回
	#
	# @param	
	#
	# @version      1.0.0
	# @since        2002/01/29
	# @return       array
	#
	
	function get_result_info() {
   		$op[cgistr_get] = $this->get_cgi_str(0);
		$op[cgistr_post] = $this->get_cgi_str(1);
		$op[prev_no] = $this->prev_no;
		$op[next_no] = $this->next_no;
		$op[max_no] = $this->max_no;
		$op[last_no] = $this->last_no;
		$op[start_no] = $this->start_no;
		$op[max_page] = $this->max_page;
		$op[cur_page] = $this->cur_page;
		$op[row_per_page] = $this->row_per_page;
		$op[sorttype] = $this->sorttype;

		return $op;


	} // end func


	############################################################# 
	#
	#
																																
	function get_where_str() {


		$where_ary = $this->where_ary;

		if ($where_ary) {
										# 替每個where加上括號，避免誤判
			foreach ($where_ary AS $key=>$val)
			{
				$where_ary[$key]='('.$val.')';
			}

			// 用 AND　把 where連起來
			// 如果 $q_header中已有WHERE的話，則不加WHERE
			if (preg_match('/\sWHERE\s/i',$this->q_header)) {
				$header1=strstr($this->q_header,"WHERE");
				$header2=strstr($this->q_header,"where");
				$header=$header1?$header1:$header2;
				$where_str= $header." AND ".join(" AND ", $where_ary);		    
			}
			else {
				$where_str= "WHERE ".join(" AND ", $where_ary);			   
			}
			
		}

			
		return $where_str;

	
	}



}





?>