<?php 

/*
*
*	程式名稱：	簡訊發送紀錄表 [sms_log] DB 設定檔
*	檔案名稱：	config.sms_log.php
*	版　　本：	1.0.0.
*	作　　者：	Gilbert Chiao <gilbert@price.com.tw>
*	著作聲明：	Price Co., Ltd.
*	起草日期：	2006.11.28.
*	更新日期：	2006.11.28.
*	說　　明：	
*	版本介紹：	
*
*/


$tbl_name=_TBL_SMS_LOG;
$tbl_alias=_TBL_AS_SMS_LOG;

$CFG['SMS_LOG_TBL'] = array();


// 資料表名稱
$CFG['SMS_LOG_TBL']['DB_TABLE'] = $tbl_name;

// 資料表欄位定義
// * 新增時所需的欄位定義(for db_add function)
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['status'] = array('CHK' => 'AA,B');
// 專案號碼。
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['project_id'] = array('CHK' => 'AA,!B', 'MSG'=>'未輸入專案流水號！');
// 得獎名單流水號
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['lottery_no'] = array('CHK' => 'AA,!B', 'MSG'=>'未輸入抽獎號碼！');
// 手機號碼：需為 09 開頭之十碼數字。
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['mobile'] = array('CHK' => 'AA,!B', 'MSG'=>'未輸入手機號碼！');
// 簡訊內容。
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['message'] = array('CHK' => 'AA,!B', 'MSG'=>'未輸入簡訊內容！');
// 簡訊單價：該筆簡訊發送的金額。
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['price'] = array('CHK' => 'AA,B');
// 單號：相關單據的單號。
//$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['serial'] = array('CHK' => 'AA,B');
// 簡訊類型：HiNet 簡訊用。
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['msg_type'] = array('CHK' => 'AA,B');
// 簡訊編號：由簡訊伺服器提供的唯一編號。
// HiNet 簡訊編號為 8 碼英數字，三竹簡訊編號為 10 碼數字。
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['MessageID'] = array('CHK' => 'AA,B');
// 簡訊發送狀態碼。
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['ret_code'] = array('CHK' => 'AA,B');
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['ret_description'] = array('CHK' => 'AA,B');
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['memo'] = array('CHK' => 'AA,B');
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['status_msg'] = array('CHK' => 'AA,B');
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['create_time'] = array('CHK' => 'AA,B');
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['create_user'] = array('CHK' => 'AA,B');
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['modify_time'] = array('CHK' => 'AA,B');
$CFG['SMS_LOG_TBL']['DB_COLS_INSERT']['modify_user'] = array('CHK' => 'AA,B');

// * 修改時所需的欄位定義(for db_modify function)
$CFG['SMS_LOG_TBL']['DB_COLS_UPDATE'] = $CFG['SMS_LOG_TBL']['DB_COLS_INSERT'];
$CFG['SMS_LOG_TBL']['DB_COLS_UPDATE_KEY']['id'] = array('CHK' => "AA,!B","MSG" => "你沒有指定簡訊發送記錄編號");

// 上層關聯性資料設定
$CFG['SMS_LOG_TBL']['CLASS_DEF'] = array();

// 狀態欄位內容定義
$CFG['SMS_LOG_TBL']['DB_STATUS_DEF'] = array();
$CFG['SMS_LOG_TBL']['DB_STATUS_DEF']['IS_DELETED'] = 1;	// 已刪除
$CFG['SMS_LOG_TBL']['DB_STATUS_DEF']['IS_SEND'] = 2;			// 已發送


// 以下為db_browse function所需額外設定
// * 搜尋SQL字串主體
$CFG['SMS_LOG_TBL']['BROWSE_SQL_TITLE'] = "SELECT {$tbl_alias}.* FROM {$tbl_name} AS {$tbl_alias}";
		
		

// * 搜尋規則定義
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE] = array();

# 編號
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_id"] = array(
"RULE" => "{$tbl_alias}.id='\$str'",
"PARM_KEY" => "sr_id",
"PARM_VAL" => "\$str",
"OPTION"	=> "T",
);
# 專案流水號
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_project_id"] = array(
"RULE" => "{$tbl_alias}.project_id='\$str'",
"PARM_KEY" => "sr_project_id",
"PARM_VAL" => "\$str",
"OPTION"	=> "T",
);
# 抽獎號碼
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_lottery_no"] = array(
"RULE" => "{$tbl_alias}.lottery_no LIKE '%\$str%'",
"PARM_KEY" => "sr_lottery_no",
"PARM_VAL" => "\$str",
"OPTION"	=> "T",
);
# 手機號碼
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_mobile"] = array(
"RULE" => "{$tbl_alias}.mobile LIKE '%\$str%'",
"PARM_KEY" => "sr_mobile",
"PARM_VAL" => "\$str",
"OPTION"	=> "T",
);
# 單號
/*$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_serial"] = array(
"RULE" => "{$tbl_alias}.serial='\$str'",
"PARM_KEY" => "sr_serial",
"PARM_VAL" => "\$str",
"OPTION"	=> "T",
);*/
# 備註
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_memo"] = array(
"RULE" => "{$tbl_alias}.memo LIKE '%\$str%'",
"PARM_KEY" => "sr_memo",
"PARM_VAL" => "\$str",
"OPTION"	=> "T",
);
/*
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_today"] = array(					// 今日 單
"RULE" => "TO_DAYS({$tbl_alias}.create_time)=TO_DAYS(NOW())",
"PARM_KEY" => "sr_today",
"PARM_VAL" => "1",
"OPTION"	=> "T",
);
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_yesterday"] = array(				// 昨日 單
"RULE" => "TO_DAYS({$tbl_alias}.create_time) + 1 = TO_DAYS(NOW())",
"PARM_KEY" => "sr_yesterday",
"PARM_VAL" => "1",
"OPTION"	=> "T",
);
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_this_week"] = array(				// 本週 單
"RULE" => "YEAR({$tbl_alias}.create_time)=YEAR(NOW()) AND WEEK({$tbl_alias}.create_time)=WEEK(NOW())",
"PARM_KEY" => "sr_this_week",
"PARM_VAL" => "1",
"OPTION"	=> "T",
);
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_last_month"] = array(				// 上月 單
"RULE" => "LEFT({$tbl_alias}.create_time,7)=LEFT(DATE_SUB(NOW(), INTERVAL 1 MONTH), 7)",
"PARM_KEY" => "sr_last_month",
"PARM_VAL" => "1",
"OPTION"	=> "T",
);
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_this_month"] = array(				// 本月 單
"RULE" => "YEAR({$tbl_alias}.create_time)=YEAR(NOW()) AND MONTH({$tbl_alias}.create_time)=MONTH(NOW())",
"PARM_KEY" => "sr_this_month",
"PARM_VAL" => "1",
"OPTION"	=> "T",
);
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_this_year"] = array(				// 今年 單
"RULE" => "YEAR({$tbl_alias}.create_time)=YEAR(NOW())",
"PARM_KEY" => "sr_this_year",
"PARM_VAL" => "1",
"OPTION"	=> "T",
);
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_date_from"] = array(				// 從某日起 單
"RULE" => "TO_DAYS({$tbl_alias}.create_time) >= TO_DAYS('\$str')",
"PARM_KEY" => "sr_date_from",
"PARM_VAL" => "\$str",
"OPTION"	=> "T",
);
$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_date_to"] = array(					// 到某日止 單
"RULE" => "TO_DAYS({$tbl_alias}.create_time) <= TO_DAYS('\$str')",
"PARM_KEY" => "sr_date_to",
"PARM_VAL" => "\$str",
"OPTION"	=> "T",
);
*/

$CFG['SMS_LOG_TBL'][DB_SEARCH_RULE]["sr_not_deleted"] = array(
"RULE" => "{$tbl_alias}.status&1=0",
"PARM_KEY" => "sr_not_deleted",
"PARM_VAL" => "1",
"OPTION"	=> "T",
);



// * 資料管理頁面
$CFG['SMS_LOG_TBL']['LAYOUT'] = array(
//	"MAIN"=>"sms_log.main.tpl",										// 主選單
	"SMS_LOG_BROWSE"=>"sms_log.browse.tpl",								// 瀏　覽
//	"VIEW"=>"sms_log.view.tpl",										// 檢　視
);



if ($mysql_obj) {
	$sms_log_obj = new DB();
	$sms_log_obj->init($mysql_obj, $CFG['SMS_LOG_TBL']) OR die('系統發生錯誤: 簡訊紀錄物件無法初始化!<br>' . join('<br>', $sms_log_obj->msg->get(2)));
}


?>