<?php

/*
 *
 *	程式名稱：	專案資料表[project] DB 設定檔
 *	檔案名稱：	config.project.php
 *	版　　本：	1.0.0.
 *	作　　者：	Jacky Jou <starjou@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2006.12.21
 *	更新日期：
 *	說　　明：
 *	版本介紹：
 *
 */

$tbl_name=_TBL_PROJECT;
$tbl_alias=_TBL_AS_PROJECT;

$CFG[PROJECT_TBL] = array();

// 資料表名稱
$CFG[PROJECT_TBL][DB_TABLE] = $tbl_name;

// 資料表別名
$CFG[PROJECT_TBL][TABLE_ALIAS] = $tbl_alias;

// 資料表欄位定義
// * 新增時所需的欄位定義(for db_add function)
$CFG[PROJECT_TBL][DB_COLS_INSERT]["password"] = array("CHK" => "AA,B");
$CFG[PROJECT_TBL][DB_COLS_INSERT]["name"] = array("CHK" => "AA,!B","MSG"=>"你沒有指定專案名稱");
$CFG[PROJECT_TBL][DB_COLS_INSERT]["company_name"] = array("CHK" => "AA,B");
$CFG[PROJECT_TBL][DB_COLS_INSERT]["status"] = array("CHK" => "AA,B");

$CFG[PROJECT_TBL][DB_COLS_INSERT]["start_time"] = array("CHK" => "AA,B"); 	// 活動開始時間
$CFG[PROJECT_TBL][DB_COLS_INSERT]["end_time"] = array("CHK" => "AA,B"); 	// 活動結束時間
$CFG[PROJECT_TBL][DB_COLS_INSERT]["company_no"] = array("CHK" => "AA,B"); 	// 統編
$CFG[PROJECT_TBL][DB_COLS_INSERT]["address"] = array("CHK" => "AA,B"); 		// 地址
$CFG[PROJECT_TBL][DB_COLS_INSERT]["contactor"] = array("CHK" => "AA,B"); 	// 聯絡人
$CFG[PROJECT_TBL][DB_COLS_INSERT]["tel1"] = array("CHK" => "AA,B"); 		// 電話1
$CFG[PROJECT_TBL][DB_COLS_INSERT]["tel2"] = array("CHK" => "AA,B"); 		// 電話2
$CFG[PROJECT_TBL][DB_COLS_INSERT]["last_3"] = array("CHK" => "AA,B"); 		// 三尾碼
$CFG[PROJECT_TBL][DB_COLS_INSERT]["image"] = array("CHK" => "AA,B"); 		// 圖檔
$CFG[PROJECT_TBL][DB_COLS_INSERT]["cong_msg"] = array("CHK" => "AA,B"); 	// 簡訊賀詞
$CFG[PROJECT_TBL][DB_COLS_INSERT]["current_item"] = array("CHK" => "AA,B"); // 目前抽獎項目
$CFG[PROJECT_TBL][DB_COLS_INSERT]["create_time"] = array("CHK" => "AA,B");
$CFG[PROJECT_TBL][DB_COLS_INSERT]["create_user"] = array("CHK" => "AA,B");
$CFG[PROJECT_TBL][DB_COLS_INSERT]["modify_time"] = array("CHK" => "AA,B");
$CFG[PROJECT_TBL][DB_COLS_INSERT]["modify_user"] = array("CHK" => "AA,B");

// * 修改時所需的欄位定義(for db_modify function)
$CFG[PROJECT_TBL][DB_COLS_UPDATE] = $CFG[PROJECT_TBL][DB_COLS_INSERT];
$CFG[PROJECT_TBL][DB_COLS_UPDATE_KEY]["id"] = array("CHK" => "AA,!B","MSG" => "你沒有指定資料庫流水號");

// 上層關聯性資料設定
$CFG[PROJECT_TBL][CLASS_DEF] = array();

// 狀態欄位內容定義
$CFG[PROJECT_TBL][DB_STATUS_DEF]=array();
$CFG[PROJECT_TBL][DB_STATUS_DEF][IS_DELETED] = 1;			// 刪除
$CFG[PROJECT_TBL][DB_STATUS_DEF][IS_EXPORTED] = 2;			// 已匯出
$CFG[PROJECT_TBL][DB_STATUS_DEF][IS_CLOSED] = 4;			// 已結案
$CFG[PROJECT_TBL][DB_STATUS_DEF][IS_NEED_PRESENT] = 8;		// 有出席才有抽獎資格
$CFG[PROJECT_TBL][DB_STATUS_DEF][IS_CHECKIN] = 16;			// 出席作業
$CFG[PROJECT_TBL][DB_STATUS_DEF][IS_RUN] = 32;				// 正在進行中！

// 以下為db_browse function所需額外設定
// * 設定搜尋SQL字串主體
$CFG[PROJECT_TBL][BROWSE_SQL_TITLE] = "SELECT {$tbl_alias}.* FROM {$tbl_name} AS {$tbl_alias}";

// * 搜尋規則定義
$CFG[PROJECT_TBL][DB_SEARCH_RULE] = array();
$CFG[PROJECT_TBL][DB_SEARCH_RULE]["sr_id"] = array(		# 編號
		"RULE" => "{$tbl_alias}.id='\$str'",
		"PARM_KEY" => "sr_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PROJECT_TBL][DB_SEARCH_RULE]["sr_not_deleted"] = array(		# 未刪除
		"RULE" => "{$tbl_alias}.status & 1 = 0",
		"PARM_KEY" => "sr_not_deleted",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PROJECT_TBL][DB_SEARCH_RULE]["sr_not_closed"] = array(		# 未結案
		"RULE" => "{$tbl_alias}.status & 4 = 0",
		"PARM_KEY" => "sr_not_closed",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PROJECT_TBL][DB_SEARCH_RULE]["sr_closed"] = array(		# 已結案
		"RULE" => "{$tbl_alias}.status & 4 <> 0",
		"PARM_KEY" => "sr_closed",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
# 非出席作業中
$CFG[PROJECT_TBL][DB_SEARCH_RULE]["sr_not_checkin"] = array(
		"RULE" => "{$tbl_alias}.status&16 = 0",
		"PARM_KEY" => "sr_not_checkin",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
# 出席作業中
$CFG[PROJECT_TBL][DB_SEARCH_RULE]["sr_checkin"] = array(
		"RULE" => "{$tbl_alias}.status&16<> 0",
		"PARM_KEY" => "sr_checkin",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PROJECT_TBL][DB_SEARCH_RULE]["sr_name"] = array(		# 專案名稱
		"RULE" => "{$tbl_alias}.name LIKE '%\$str%'",
		"PARM_KEY" => "sr_name",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PROJECT_TBL][DB_SEARCH_RULE]["sr_company_name"] = array(		# 公司名稱
		"RULE" => "{$tbl_alias}.company_name LIKE '%\$str%'",
		"PARM_KEY" => "sr_company_name",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);


// * 資料管理頁面
$CFG[PROJECT_TBL][LAYOUT] = array(
	"MAIN"=>"project.main.tpl",			// 主選單
	"BROWSE"=>"project.browse.tpl",		// 瀏　覽
	"ADD"=>"project.edit.tpl",			// 新　增
	"MODIFY"=>"project.edit.tpl",			// 修　改
	"VIEW"=>"project.view.tpl",			// 檢　視
	"CHOOSE"=>"project.choose.tpl",			// 檢　視
	"CONG_MSG"=>"project.cong_msg.tpl",			// 檢　視
);

if ($mysql_obj) {
	$project_obj = new DB();
	$project_obj->init($mysql_obj, $CFG[PROJECT_TBL]) OR DIE("系統發生錯誤: 專案資料庫物件初始化失敗<br>".join("<br>", $project_obj->msg->get(2)));

	$prj_obj =& $project_obj;
}

?>
