<?php 

/*
 *
 *	程式名稱：	得獎名單資料表[pirze_last3] DB 設定檔
 *	檔案名稱：	config.pirze_last_3.php
 *	版　　本：	1.0.0.
 *	作　　者：	Tenchi Hsu
 *	著作聲明：	Foxconn
 *	起草日期：	2016.03.18
 *	更新日期：	
 *	說　　明：	
 *	版本介紹：	
 *
 */

$tbl_name=_TBL_PRIZE_LAST_3;
$tbl_alias=_TBL_AS_PRIZE_LAST_3;
$prize_tbl_name=_TBL_PRIZE;
$prize_tbl_alias=_TBL_AS_PRIZE;
$member_tbl_name=_TBL_MEMBER;
$member_tbl_alias=_TBL_AS_MEMBER;
$class_tbl_name=_TBL_CLASS;
$class_tbl_alias=_TBL_AS_CLASS;

$CFG[PRIZE_LAST_3_TBL] = array();

// 資料表名稱
$CFG[PRIZE_LAST_3_TBL][DB_TABLE] = $tbl_name;

// 資料表別名
$CFG[PRIZE_LAST_3_TBL][TABLE_ALIAS] = $tbl_alias;

// 資料表欄位定義
// * 新增時所需的欄位定義(for db_add function)
$CFG[PRIZE_LAST_3_TBL][DB_COLS_INSERT]["project_id"] = array("CHK" => "AA,!B","MSG"=>"你沒有指定專案流水號");
$CFG[PRIZE_LAST_3_TBL][DB_COLS_INSERT]["last_A"] = array("CHK" => "AA,B");
$CFG[PRIZE_LAST_3_TBL][DB_COLS_INSERT]["last_B"] = array("CHK" => "AA,B");
$CFG[PRIZE_LAST_3_TBL][DB_COLS_INSERT]["last_C"] = array("CHK" => "AA,B"); 

// 獎項編號：專為鴻海 2008.02.04. 動員大會的獎項用。
$CFG[PRIZE_LIST_TBL][DB_COLS_INSERT]["seq_no"] = array("CHK" => "AA,B");

$CFG[PRIZE_LIST_TBL][DB_COLS_INSERT]["status"] = array("CHK" => "AA,B");
$CFG[PRIZE_LIST_TBL][DB_COLS_INSERT]["sms_status_msg"] = array("CHK" => "AA,B");

$CFG[PRIZE_LIST_TBL][DB_COLS_INSERT]["create_time"] = array("CHK" => "AA,B"); 
$CFG[PRIZE_LIST_TBL][DB_COLS_INSERT]["create_user"] = array("CHK" => "AA,B"); 
$CFG[PRIZE_LIST_TBL][DB_COLS_INSERT]["modify_time"] = array("CHK" => "AA,B"); 
$CFG[PRIZE_LIST_TBL][DB_COLS_INSERT]["modify_user"] = array("CHK" => "AA,B"); 

// * 修改時所需的欄位定義(for db_modify function)
$CFG[PRIZE_LIST_TBL][DB_COLS_UPDATE] = $CFG[PRIZE_LIST_TBL][DB_COLS_INSERT];
$CFG[PRIZE_LIST_TBL][DB_COLS_UPDATE_KEY]["id"] = array("CHK" => "AA,!B","MSG" => "你沒有指定資料庫流水號");

// 上層關聯性資料設定
$CFG[PRIZE_LIST_TBL][CLASS_DEF] = array();

// 狀態欄位內容定義
$CFG[PRIZE_LIST_TBL][DB_STATUS_DEF]=array();
$CFG[PRIZE_LIST_TBL][DB_STATUS_DEF][IS_DELETED] = 1;				// 刪除
$CFG[PRIZE_LIST_TBL][DB_STATUS_DEF][IS_CONFIRMED] = 2;				// 已確認
$CFG[PRIZE_LIST_TBL][DB_STATUS_DEF][IS_NOTICED] = 4;				// 已通知
$CFG[PRIZE_LIST_TBL][DB_STATUS_DEF][IS_STAR1] = 8;				// 四星彩頭獎
$CFG[PRIZE_LIST_TBL][DB_STATUS_DEF][IS_STAR2] = 16;				// 四星彩貳獎
$CFG[PRIZE_LIST_TBL][DB_STATUS_DEF][IS_STAR3] = 32;				// 四星彩參獎
$CFG[PRIZE_LIST_TBL][DB_STATUS_DEF][IS_STAR4] = 64;				// 四星彩肆獎

// 以下為db_browse function所需額外設定
// * 設定搜尋SQL字串主體
$CFG[PRIZE_LIST_TBL][BROWSE_SQL_TITLE] = "SELECT {$tbl_alias}.id,  {$tbl_alias}.seq_no, {$tbl_alias}.prize_id,{$tbl_alias}.status, {$tbl_alias}.member_id,  {$member_tbl_alias}.lottery_no, {$member_tbl_alias}.legal_person, {$member_tbl_alias}.business_group, {$member_tbl_alias}.department, {$member_tbl_alias}.member_code, {$member_tbl_alias}.family_name, {$member_tbl_alias}.name, {$prize_tbl_alias}.prize_name,{$prize_tbl_alias}.prize_desc, {$class_tbl_alias}.class_name, {$member_tbl_alias}.cell FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$member_tbl_name} AS {$member_tbl_alias} ON {$tbl_alias}.member_id = {$member_tbl_alias}.id LEFT JOIN {$prize_tbl_name} AS {$prize_tbl_alias} ON {$tbl_alias}.prize_id = {$prize_tbl_alias}.id LEFT JOIN {$class_tbl_name} AS {$class_tbl_alias} ON {$member_tbl_alias}.class_id = {$class_tbl_alias}.id";

$CFG[PRIZE_LIST_TBL][BROWSE_SQL_TITLE_LIST] = "SELECT {$tbl_alias}.id, {$tbl_alias}.seq_no, {$member_tbl_alias}.lottery_no, {$member_tbl_alias}.legal_person, {$member_tbl_alias}.business_group, {$member_tbl_alias}.department, {$member_tbl_alias}.member_code, {$member_tbl_alias}.memo, {$member_tbl_alias}.family_name, {$member_tbl_alias}.name, {$prize_tbl_alias}.prize_name FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$member_tbl_name} AS {$member_tbl_alias} ON {$tbl_alias}.member_id = {$member_tbl_alias}.id LEFT JOIN {$prize_tbl_name} AS {$prize_tbl_alias} ON {$tbl_alias}.prize_id = {$prize_tbl_alias}.id ";

$CFG[PRIZE_LIST_TBL][BROWSE_SQL_TITLE_COUNT] = "SELECT COUNT(*) AS DRAWN_QTY FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$member_tbl_name} AS {$member_tbl_alias} ON {$tbl_alias}.member_id = {$member_tbl_alias}.id ";

$CFG[PRIZE_LIST_TBL][BROWSE_SQL_TITLE_SMS] = "SELECT {$tbl_alias}.*, {$member_tbl_alias}.lottery_no, {$member_tbl_alias}.name AS member_name,  {$member_tbl_alias}.family_name AS family_name, {$member_tbl_alias}.cell, {$prize_tbl_alias}.no,{$prize_tbl_alias}.prize_name,{$prize_tbl_alias}.prize_desc FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$member_tbl_name} AS {$member_tbl_alias} ON {$tbl_alias}.member_id = {$member_tbl_alias}.id LEFT JOIN {$prize_tbl_name} AS {$prize_tbl_alias} ON {$tbl_alias}.prize_id = {$prize_tbl_alias}.id ";

$CFG[PRIZE_LIST_TBL][BROWSE_SQL_TITLE_STATISTIC] = "SELECT COUNT(*) AS cnt, {$prize_tbl_alias}.prize_name,{$prize_tbl_alias}.id AS prize_id, {$prize_tbl_alias}.prize_desc, {$tbl_alias}.seq_no FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$prize_tbl_name} AS {$prize_tbl_alias} ON {$tbl_alias}.prize_id = {$prize_tbl_alias}.id LEFT JOIN {$member_tbl_name} AS {$member_tbl_alias} ON {$tbl_alias}.member_id = {$member_tbl_alias}.id";

$CFG[PRIZE_LIST_TBL][BROWSE_SQL_TITLE_PRINT] = "SELECT {$member_tbl_alias}.legal_person, {$member_tbl_alias}.business_group, {$member_tbl_alias}.member_code, {$member_tbl_alias}.name, {$member_tbl_alias}.family_name, {$member_tbl_alias}.status, {$member_tbl_alias}.lottery_no, {$member_tbl_alias}.memo, {$tbl_alias}.seq_no FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$member_tbl_name} AS {$member_tbl_alias} ON {$tbl_alias}.member_id = {$member_tbl_alias}.id LEFT JOIN {$prize_tbl_name} AS {$prize_tbl_alias} ON {$tbl_alias}.prize_id = {$prize_tbl_alias}.id LEFT JOIN {$class_tbl_name} AS {$class_tbl_alias} ON {$member_tbl_alias}.class_id = {$class_tbl_alias}.id";

// * 搜尋規則定義
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE] = array();
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_id"] = array(		# 編號
		"RULE" => "{$tbl_alias}.id='\$str'",
		"PARM_KEY" => "sr_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_lottery_no"] = array(		# 抽獎號碼
		"RULE" => "{$member_tbl_alias}.lottery_no='\$str'",
		"PARM_KEY" => "sr_lottery_no",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_keyword"] = array(		# 編號
		"RULE" => "{$member_tbl_alias}.name LIKE '%\$str%' OR {$member_tbl_alias}.member_code LIKE '%\$str%' OR {$member_tbl_alias}.family_code LIKE '%\$str%'  OR {$member_tbl_alias}.lottery_no LIKE '%\$str%' ",
		"PARM_KEY" => "sr_keyword",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_seq_no"] = array(		# 獎項編號
		"RULE" => "{$tbl_alias}.seq_no='\$str'",
		"PARM_KEY" => "sr_seq_no",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_not_deleted"] = array(		# 未刪除
		"RULE" => "{$tbl_alias}.status & 1 = 0",
		"PARM_KEY" => "sr_not_deleted",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_not_notice"] = array(		# 未通知
		"RULE" => "{$tbl_alias}.status & 4 = 0",
		"PARM_KEY" => "sr_not_notice",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_project_id"] = array(		# 專案編號
		"RULE" => "{$prize_tbl_alias}.project_id='\$str'",
		"PARM_KEY" => "sr_project_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_need_confirm"] = array(		# 需確認獎項
		"RULE" => "{$prize_tbl_alias}.status & 8 <> 0",
		"PARM_KEY" => "sr_need_confirm",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_prize_id"] = array(		# 獎項編號
		"RULE" => "{$tbl_alias}.prize_id='\$str'",
		"PARM_KEY" => "sr_prize_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_quota_id"] = array(		# 配額編號
		"RULE" => "{$tbl_alias}.quota_id='\$str'",
		"PARM_KEY" => "sr_quota_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);

$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_class_id"] = array(		# 得獎人員所屬群組
		"RULE" => "{$member_tbl_alias}.class_id='\$str'",
		"PARM_KEY" => "sr_class_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_member_name"] = array(		# 得獎者姓名
		"RULE" => "{$member_tbl_alias}.name LIKE '%\$str%'",
		"PARM_KEY" => "sr_member_name",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_prize_name"] = array(		# 獎項名稱
		"RULE" => "{$prize_tbl_alias}.prize_name LIKE '%\$str%'",
		"PARM_KEY" => "sr_prize_name",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_star1"] = array(		# 四星彩頭獎
		"RULE" => "{$tbl_alias}.status & 8 <> 0",
		"PARM_KEY" => "sr_star1",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_LIST_TBL][DB_SEARCH_RULE]["sr_business_group"] = array(		# 事業群
		"RULE" => "{$member_tbl_alias}.business_group='\$str'",
		"PARM_KEY" => "sr_business_group",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);


// * 資料管理頁面
$CFG[PRIZE_LIST_TBL][LAYOUT] = array(
	"MAIN"=>"prize_list.main.tpl",			// 主選單
	"BROWSE"=>"prize_list.browse.tpl",		// 瀏　覽
//	"ADD"=>".edit.tpl",			// 新　增
//	"MODIFY"=>".edit.tpl",			// 修　改
//	"VIEW"=>".view.tpl",			// 檢　視	
//	"PRINT"=>"prize_list.print.tpl",			// 檢　視	
	"EXPORT"=>"prize_list.export.tpl",			// 匯出 Excel
	"SMS_BROWSE"=>"prize_list.sms_browse.tpl",			// 簡訊發送狀態瀏覽
	"STATISTIC_PRINT"=>"prize_list.statistic_print.tpl",			// 列印分類得獎統計報表	
	"GROUP_STATISTIC_PRINT"=>"prize_list.group_statistic_print.tpl",			// 列印事業群得獎統計報表	
	"PRINT_LIST_A4"=>"prize_list.print_list_A4.tpl",			// 列印得獎名單 A4
	"PRINT_LIST_A3"=>"prize_list.print_list_A3.tpl",			// 列印得獎名單 A3	
	"PRINT_NUM"=>"prize_list.print_num.tpl",			// 列印得獎名單號碼
	"PRINT_SEQ_NO"=>"prize_list.print_seq_no.tpl",				// 列印獎號得獎號碼
);

if ($mysql_obj){
	$przlast3_obj = new DB();
	$przlast3_obj->init($mysql_obj, $CFG[PRIZE_LAST_3_TBL]) OR DIE("系統發生錯誤: 得獎名單資料庫物件初始化失敗<br>".join("<br>", $przlast3_obj->msg->get(2)));
}

?>
