<?php 

/*
 *
 *	程式名稱：	獎項資料表[prize] DB 設定檔
 *	檔案名稱：	config.prize.php
 *	版　　本：	1.0.0.
 *	作　　者：	Jacky Jou <starjou@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2006.12.21
 *	更新日期：	
 *	說　　明：	
 *	版本介紹：	
 *
 */

$tbl_name=_TBL_PRIZE;
$tbl_alias=_TBL_AS_PRIZE;

$tbl_quta_name=_TBL_PRIZE_QUOTA;
$tbl_quota_alias=_TBL_AS_PRIZE_QUOTA;

$tbl_class_name=_TBL_CLASS;
$tbl_class_alias=_TBL_AS_CLASS;

$CFG[PRIZE_TBL] = array();

// 資料表名稱
$CFG[PRIZE_TBL][DB_TABLE] = $tbl_name;

// 資料表別名
$CFG[PRIZE_TBL][TABLE_ALIAS] = $tbl_alias;

// 資料表欄位定義
// * 新增時所需的欄位定義(for db_add function)
$CFG[PRIZE_TBL][DB_COLS_INSERT]["project_id"] = array("CHK" => "AA,!B","MSG"=>"你沒有指定專案號碼");
$CFG[PRIZE_TBL][DB_COLS_INSERT]["prize_name"] = array("CHK" => "AA,!B","MSG"=>"你沒有指定獎項名稱"); 
$CFG[PRIZE_TBL][DB_COLS_INSERT]["status"] = array("CHK" => "AA,B");
$CFG[PRIZE_TBL][DB_COLS_INSERT]["qty"] = array("CHK" => "AA,B");

$CFG[PRIZE_TBL][DB_COLS_INSERT]["qualification_kind"] = array("CHK" => "AA,B"); 	// 得獎資格類別，與 MEMBER 資料表中之 qualification 欄位做 bit 運算以檢查是否具抽獎資格
$CFG[PRIZE_TBL][DB_COLS_INSERT]["group_num"] = array("CHK" => "AA,B"); 							// 獎項群組 與 MEMBER 資料表中之 groupmark 做 bit 運算，同一群組不可重覆中獎
$CFG[PRIZE_TBL][DB_COLS_INSERT]["no"] = array("CHK" => "AA,B"); 									// 排序編號
$CFG[PRIZE_TBL][DB_COLS_INSERT]["image"] = array("CHK" => "AA,B"); 							// 圖片檔名
$CFG[PRIZE_TBL][DB_COLS_INSERT]["prize_desc"] = array("CHK" => "AA,B"); 						// 獎品描述
$CFG[PRIZE_TBL][DB_COLS_INSERT]["price"] = array("CHK" => "AA,B"); 							// 獎品金額

// 獎項起始編號：專為鴻海 2008.02.04. 動員大會的獎項用，得獎名單由此數字開始遞減。
$CFG[PRIZE_TBL][DB_COLS_INSERT]["seq_start"] = array("CHK" => "AA,B");

// 獎項目前編號：專為鴻海 2008.02.04. 動員大會的獎項用，得獎名單由此數字開始遞減。
// 本欄位是程式使用，UI 不提供此欄位之修改功能。
// 若使用者利用 UI 調整 seq_start 欄位值，則 seq_now 欄位要直接更新成 seq_start 欄位值。
$CFG[PRIZE_TBL][DB_COLS_INSERT]["seq_now"] = array("CHK" => "AA,B");
$CFG[PRIZE_TBL][DB_COLS_INSERT]["last_3"] = array("CHK" => "AA,B");
$CFG[PRIZE_TBL][DB_COLS_INSERT]["create_time"] = array("CHK" => "AA,B");
$CFG[PRIZE_TBL][DB_COLS_INSERT]["create_user"] = array("CHK" => "AA,B"); 
$CFG[PRIZE_TBL][DB_COLS_INSERT]["modify_time"] = array("CHK" => "AA,B"); 
$CFG[PRIZE_TBL][DB_COLS_INSERT]["modify_user"] = array("CHK" => "AA,B"); 

// * 修改時所需的欄位定義(for db_modify function)
$CFG[PRIZE_TBL][DB_COLS_UPDATE] = $CFG[PRIZE_TBL][DB_COLS_INSERT];
$CFG[PRIZE_TBL][DB_COLS_UPDATE_KEY]["id"] = array("CHK" => "AA,!B","MSG" => "你沒有指定資料庫流水號");

// 上層關聯性資料設定
$CFG[PRIZE_TBL][CLASS_DEF] = array();

// 狀態欄位內容定義	1.刪除 2.抽獎資格：檢查配額 4.抽獎資格：依類別 8.需做得獎確認)
$CFG[PRIZE_TBL][DB_STATUS_DEF]=array();
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_DELETED] = 1;				// 刪除
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_QUOTA] = 2;								// 有類別配額
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_QUALIFICATION] = 4;				// 須做得獎資格確認
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_NEED_CONFIRM] = 8;				// 須做得獎確認之獎項
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_DRAWN] = 16;				// 已開獎
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_HIDDEN] = 32;				// 前台獎項列表時隱藏
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_SPECIAL] = 64;				// 得獎名單特殊動畫
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_STAR1] = 128;				// 四星彩頭獎
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_STAR2] = 256;				// 四星彩貳獎
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_STAR3] = 512;				// 四星彩參獎
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_STAR4] = 1024;				// 四星彩肆獎
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_DRAW_ONCE] = 2048;				// 有配額獎項一次抽完
$CFG[PRIZE_TBL][DB_STATUS_DEF][IS_LAST_3] = 4096;				// 抽尾數

// 以下為db_browse function所需額外設定
// * 設定搜尋SQL字串主體
$CFG[PRIZE_TBL][BROWSE_SQL_TITLE] = "SELECT {$tbl_alias}.* FROM {$tbl_name} AS {$tbl_alias}";
$CFG[PRIZE_TBL][BROWSE_SQL_TITLE_QUOTA] = "SELECT {$tbl_alias}.* , {$tbl_quota_alias}.id AS quota_id, {$tbl_quota_alias}.quota, {$tbl_class_alias}.class_name FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$tbl_quta_name} AS {$tbl_quota_alias} ON {$tbl_alias}.id = {$tbl_quota_alias}.prize_id LEFT JOIN {$tbl_class_name} AS {$tbl_class_alias} ON {$tbl_quota_alias}.class_id = {$tbl_class_alias}.id";
$CFG[PRIZE_TBL][BROWSE_SQL_TITLE_ORIGIN] = "SELECT {$tbl_alias}.* FROM {$tbl_name} AS {$tbl_alias}";

// * 搜尋規則定義
$CFG[PRIZE_TBL][DB_SEARCH_RULE] = array();
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_id"] = array(		# 編號
		"RULE" => "{$tbl_alias}.id='\$str'",
		"PARM_KEY" => "sr_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_project_id"] = array(		# 專案編號
		"RULE" => "{$tbl_alias}.project_id='\$str'",
		"PARM_KEY" => "sr_project_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_not_deleted"] = array(		# 未刪除
		"RULE" => "{$tbl_alias}.status & 1 = 0",
		"PARM_KEY" => "sr_not_deleted",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_drawn"] = array(		# 已開獎
		"RULE" => "{$tbl_alias}.status & 16 <> 0",
		"PARM_KEY" => "sr_drawn",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_not_drawn"] = array(		# 未開獎
		"RULE" => "{$tbl_alias}.status & 16 = 0",
		"PARM_KEY" => "sr_not_drawn",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_not_hide"] = array(		# 未隱藏
		"RULE" => "{$tbl_alias}.status & 32 = 0",
		"PARM_KEY" => "sr_not_hide",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_star1"] = array(		# 四星彩頭獎
		"RULE" => "{$tbl_alias}.status & 128 <> 0",
		"PARM_KEY" => "sr_star1",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_star2"] = array(		# 四星彩貳獎
		"RULE" => "{$tbl_alias}.status & 256 <> 0",
		"PARM_KEY" => "sr_star2",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_star3"] = array(		# 四星彩參獎
		"RULE" => "{$tbl_alias}.status & 512 <> 0",
		"PARM_KEY" => "sr_star3",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_star4"] = array(		# 四星彩肆獎
		"RULE" => "{$tbl_alias}.status & 1024 <> 0",
		"PARM_KEY" => "sr_star4",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_not_star234"] = array(		# 不是四星彩貳參肆獎
		"RULE" => "{$tbl_alias}.status & 256 = 0 AND {$tbl_alias}.status & 512 = 0 AND {$tbl_alias}.status & 1024 = 0",
		"PARM_KEY" => "sr_not_star234",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_is_quota"] = array(		# 有配額設定
		"RULE" => "{$tbl_alias}.status & 2 <> 0",
		"PARM_KEY" => "sr_is_quota",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_not_quota"] = array(		# 無配額設定
		"RULE" => "{$tbl_alias}.status & 2 = 0",
		"PARM_KEY" => "sr_no_quota",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_quota_not_drawn"] = array(		# 配額獎項尚未抽獎
		"RULE" => "{$tbl_quota_alias}.status & 16 = 0",
		"PARM_KEY" => "sr_quota_not_drawn",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_quota_not_zero"] = array(		# 配額獎項數目不為0
		"RULE" => "{$tbl_quota_alias}.quota <> 0",
		"PARM_KEY" => "sr_quota_not_zero",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_draw_once"] = array(		# 一次抽完
		"RULE" => "{$tbl_alias}.status & 2048 <> 0",
		"PARM_KEY" => "sr_draw_once",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_not_quota_or_draw_once"] = array(		# 無配額或一次抽完
		"RULE" => "{$tbl_alias}.status & 2 = 0 OR ({$tbl_alias}.status & 2 <> 0 AND {$tbl_alias}.status & 2048 <> 0)",
		"PARM_KEY" => "sr_not_quota_or_draw_once",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_TBL][DB_SEARCH_RULE]["sr_not_draw_once"] = array(		# 非一次抽完
		"RULE" => "{$tbl_alias}.status & 2048= 0",
		"PARM_KEY" => "sr_not_draw_once",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);


// * 資料管理頁面
$CFG[PRIZE_TBL][LAYOUT] = array(
	"MAIN"=>"prize.main.tpl",			// 主選單
	"BROWSE"=>"prize.browse.tpl",		// 瀏　覽
	"ADD"=>"prize.edit.tpl",			// 新　增
	"MODIFY"=>"prize.edit.tpl",			// 修　改
	"VIEW"=>"prize.view.tpl",			// 檢　視	
	"EXPORT"=>"prize.export.tpl",
);

if ($mysql_obj){
	$prize_obj = new DB();
	$prize_obj->init($mysql_obj, $CFG[PRIZE_TBL]) OR DIE("系統發生錯誤: 獎項資料庫物件初始化失敗<br>".join("<br>", $prize_obj->msg->get(2)));
}

?>
