<?php
/**
 *	程式名稱：	參加人員資料表[member] DB 設定檔
 *	檔案名稱：	config.member.php
 *	版　　本：	1.0.0.
 *	作　　者：	Jacky Jou <starjou@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2006.12.21
 *	更新日期：
 *	說　　明：
 *	版本介紹：
 */

$tbl_name=_TBL_MEMBER;
$tbl_alias=_TBL_AS_MEMBER;

$class_tbl_name=_TBL_CLASS;
$class_tbl_alias=_TBL_AS_CLASS;

$CFG[MEMBER_TBL] = array();

// 資料表名稱
$CFG[MEMBER_TBL][DB_TABLE] = $tbl_name;

// 資料表別名
$CFG[MEMBER_TBL][TABLE_ALIAS] = $tbl_alias;

// 資料表欄位定義
// * 新增時所需的欄位定義(for db_add function)
$CFG[MEMBER_TBL][DB_COLS_INSERT]["project_id"] = array("CHK" => "AA,!B","MSG"=>"你沒有指定專案號碼");
$CFG[MEMBER_TBL][DB_COLS_INSERT]["lottery_no"] = array("CHK" => "AA,!B","MSG"=>"你沒有指定抽獎號碼");
$CFG[MEMBER_TBL][DB_COLS_INSERT]["status"] = array("CHK" => "AA,B");

$CFG[MEMBER_TBL][DB_COLS_INSERT]["class_id"] = array("CHK" => "AA,B");		// 所屬獎項配額類別
$CFG[MEMBER_TBL][DB_COLS_INSERT]["qualification"] = array("CHK" => "AA,B");	// 抽獎資格標記
$CFG[MEMBER_TBL][DB_COLS_INSERT]["groupmark"] = array("CHK" => "AA,B");		// 得獎群組已中獎標記 同一 bit (同一群組) 不可重覆中獎
$CFG[MEMBER_TBL][DB_COLS_INSERT]["legal_person"] = array("CHK" => "AA,B");	//法人
$CFG[MEMBER_TBL][DB_COLS_INSERT]["business_group"] = array("CHK" => "AA,B");//事業群
$CFG[MEMBER_TBL][DB_COLS_INSERT]["department"] = array("CHK" => "AA,B");	//部門
$CFG[MEMBER_TBL][DB_COLS_INSERT]["member_code"] = array("CHK" => "AA,B");	//工號
$CFG[MEMBER_TBL][DB_COLS_INSERT]["family_code"] = array("CHK" => "AA,B");	//眷屬編號
$CFG[MEMBER_TBL][DB_COLS_INSERT]["name"] = array("CHK" => "AA,B");			//姓名
$CFG[MEMBER_TBL][DB_COLS_INSERT]["family_name"] = array("CHK" => "AA,B");	//眷屬姓名
$CFG[MEMBER_TBL][DB_COLS_INSERT]["cell"] = array("CHK" => "AA,B");			//手機
$CFG[MEMBER_TBL][DB_COLS_INSERT]["email"] = array("CHK" => "AA,B");			//電子郵件
$CFG[MEMBER_TBL][DB_COLS_INSERT]["image"] = array("CHK" => "AA,B");			//電子郵件
$CFG[MEMBER_TBL][DB_COLS_INSERT]["memo"] = array("CHK" => "AA,B");			//備註
$CFG[MEMBER_TBL][DB_COLS_INSERT]["totem"] = array("CHK" => "AA,B");			//幸運圖騰編號
$CFG[MEMBER_TBL][DB_COLS_INSERT]["create_time"] = array("CHK" => "AA,B");
$CFG[MEMBER_TBL][DB_COLS_INSERT]["create_user"] = array("CHK" => "AA,B");
$CFG[MEMBER_TBL][DB_COLS_INSERT]["modify_time"] = array("CHK" => "AA,B");
$CFG[MEMBER_TBL][DB_COLS_INSERT]["modify_user"] = array("CHK" => "AA,B");
$CFG[MEMBER_TBL][DB_COLS_INSERT]["manual_present_time"] = array("CHK" => "AA,B");

// * 修改時所需的欄位定義(for db_modify function)
$CFG[MEMBER_TBL][DB_COLS_UPDATE] = $CFG[MEMBER_TBL][DB_COLS_INSERT];
$CFG[MEMBER_TBL][DB_COLS_UPDATE_KEY]["id"] = array("CHK" => "AA,!B","MSG" => "你沒有指定資料庫流水號");

// 上層關聯性資料設定
$CFG[MEMBER_TBL][CLASS_DEF] = array();

// 狀態欄位內容定義
$CFG[MEMBER_TBL][DB_STATUS_DEF]=array();
$CFG[MEMBER_TBL][DB_STATUS_DEF][IS_DELETED] = 1;				// 刪除
$CFG[MEMBER_TBL][DB_STATUS_DEF][IS_PRESENT] = 2;				// 出席
$CFG[MEMBER_TBL][DB_STATUS_DEF][IS_MANUAL_PRESENT] = 4;			// 出席設定為人工設定

// 以下為db_browse function所需額外設定
// * 設定搜尋SQL字串主體
$CFG[MEMBER_TBL][BROWSE_SQL_TITLE] = "SELECT {$tbl_alias}.* FROM {$tbl_name} AS {$tbl_alias}";
$CFG[MEMBER_TBL][BROWSE_SQL_TITLE_EXPORT] = "SELECT {$tbl_alias}.*, qualification & 1 AS qualification1, qualification & 2 AS qualification2, qualification & 4 AS qualification3, qualification & 8 AS qualification4, qualification & 16 AS qualification5, qualification & 32 AS qualification6, qualification & 64 AS qualification7, qualification & 128 AS qualification8, qualification & 256 AS qualification9, qualification & 512 AS qualification10, qualification & 1024 AS qualification11, qualification & 2048 AS qualification12, qualification & 4096 AS qualification13, qualification & 8192 AS qualification14, qualification & 16384 AS qualification15, qualification & 32768 AS qualification16, qualification & 65536 AS qualification17, qualification & 131072 AS qualification18, qualification & 262144 AS qualification19, qualification & 524288 AS qualification20, {$class_tbl_alias}.class_name FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$class_tbl_name} AS {$class_tbl_alias} ON {$tbl_alias}.class_id = {$class_tbl_alias}.id";
$CFG[MEMBER_TBL][BROWSE_SQL_TITLE_PRESENT_STATISTIC] = "SELECT business_group, count(*) AS cnt FROM {$tbl_name} AS {$tbl_alias} ";
$CFG[MEMBER_TBL][BROWSE_SQL_TITLE_PRESENT_STATISTIC_CLASS] = "SELECT business_group, class_id, count(*) AS cnt FROM {$tbl_name} AS {$tbl_alias} ";

// * 搜尋規則定義
$CFG[MEMBER_TBL][DB_SEARCH_RULE] = array();
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_id"] = array(		# 編號
		"RULE" => "{$tbl_alias}.id='\$str'",
		"PARM_KEY" => "sr_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_class_id"] = array(		# 編號
		"RULE" => "{$tbl_alias}.class_id='\$str'",
		"PARM_KEY" => "sr_class_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_project_id"] = array(		# 專案編號
		"RULE" => "{$tbl_alias}.project_id='\$str'",
		"PARM_KEY" => "sr_project_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_not_deleted"] = array(		# 未刪除
		"RULE" => "{$tbl_alias}.status & 1 = 0",
		"PARM_KEY" => "sr_not_deleted",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_member_code"] = array(		# 工號
		"RULE" => "{$tbl_alias}.member_code LIKE '%\$str%'",
		"PARM_KEY" => "sr_member_code",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_name"] = array(		# 姓名
		"RULE" => "{$tbl_alias}.name LIKE '%\$str%'",
		"PARM_KEY" => "sr_name",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_lottery_no"] = array(		# 抽獎號碼
		"RULE" => "{$tbl_alias}.lottery_no LIKE '%\$str%'",
		"PARM_KEY" => "sr_lottery_no",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_lottery_no_exact"] = array(		# 抽獎號碼
		"RULE" => "{$tbl_alias}.lottery_no = '\$str'",
		"PARM_KEY" => "sr_lottery_no_exact",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_present"] = array(		# 已出席
		"RULE" => "{$tbl_alias}.status & 2 <> 0",
		"PARM_KEY" => "sr_present",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_manual_present"] = array(		# 人工設為出席
		"RULE" => "{$tbl_alias}.status & 4 <> 0",
		"PARM_KEY" => "sr_manual_present",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_group_clean"] = array(		# 該群組尚末得獎
		"RULE" => "{$tbl_alias}.groupmark & \$str = 0",
		"PARM_KEY" => "sr_group_clean",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_qualification"] = array(		# 該群組尚末得獎
		"RULE" => "{$tbl_alias}.qualification & \$str <> 0",
		"PARM_KEY" => "sr_qualification",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_not_lottery_no"] = array(		# 抽獎號碼不為
		"RULE" => "{$tbl_alias}.lottery_no <> '\$str'",
		"PARM_KEY" => "sr_not_lottery_no",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_not_class_id_zero"] = array(		# 配額類別不為零
		"RULE" => "{$tbl_alias}.class_id!=0",
		"PARM_KEY" => "sr_not_class_id_zero",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_lottery_no_leader_letter"] = array(		# 抽獎號碼第一碼
		"RULE" => "{$tbl_alias}.lottery_no LIKE '\$str%'",
		"PARM_KEY" => "sr_lottery_no_leader_letter",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_lottery_no_last_letters"] = array(		# 抽獎號碼未碼為
		"RULE" => "{$tbl_alias}.lottery_no LIKE '%\$str'",
		"PARM_KEY" => "sr_lottery_no_last_letter",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_not_lottery_no_last_letters"] = array(		# 抽獎號碼未碼不為
		"RULE" => "{$tbl_alias}.lottery_no NOT LIKE '%\$str'",
		"PARM_KEY" => "sr_not_lottery_no_last_letter",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_lottery_no_last_zero"] = array(		# 抽獎號碼末碼為 '0'
		"RULE" => "{$tbl_alias}.lottery_no LIKE '%0'",
		"PARM_KEY" => "sr_lottery_no_last_zero",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_lottery_no_last_zero2"] = array(		# 抽獎號碼末碼為 '0'
		"RULE" => "{$tbl_alias}.lottery_no LIKE '%00'",
		"PARM_KEY" => "sr_lottery_no_last_zero2",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_lottery_no_last_zero3"] = array(		# 抽獎號碼末碼為 '0'
		"RULE" => "{$tbl_alias}.lottery_no LIKE '%000'",
		"PARM_KEY" => "sr_lottery_no_last_zero3",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_not_lottery_no_last_zero2"] = array(		# 抽獎號碼末碼不為'00'
		"RULE" => "{$tbl_alias}.lottery_no NOT LIKE '%00'",
		"PARM_KEY" => "sr_not_lottery_no_last_zero2",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_not_lottery_no_last_zero3"] = array(		# 抽獎號碼末碼不為'000'
		"RULE" => "{$tbl_alias}.lottery_no NOT LIKE '%000'",
		"PARM_KEY" => "sr_not_lottery_no_last_zero3",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_tail"] = array(		# 抽獎號碼未碼不為
		"EXEC_1"   => '$str = \'\' . join("\' , \'",$str) . \'\';',
 		"RULE" => " RIGHT({$tbl_alias}.lottery_no, 1) IN ('\$str')",
		"PARM_KEY" => "sr_tail",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_business_group"] = array(		# 事業群
		"RULE" => "{$tbl_alias}.business_group = '\$str'",
		"PARM_KEY" => "sr_business_group",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);

$CFG[MEMBER_TBL][DB_SEARCH_RULE]["sr_business_group_empty"] = array(		# 事業群空白
		"RULE" => "{$tbl_alias}.business_group = ''",
		"PARM_KEY" => "sr_business_group_empty",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);



// * 資料管理頁面
$CFG[MEMBER_TBL][LAYOUT] = array(
	"MAIN"=>"member.main.tpl",			// 主選單
	"BROWSE"=>"member.browse.tpl",		// 瀏　覽
	"ADD"=>"member.edit.tpl",			// 新　增
	"MODIFY"=>"member.edit.tpl",		// 修　改
	"VIEW"=>"member.view.tpl",			// 檢　視
	"EXPORT"=>"member.export.tpl",		// 匯  出
	"PRESENT"=>"member.present.tpl",	// 出席管理
	"LOTTERY_NO_QUERY"=>"member.lottery_no_query.tpl",				// 抽獎號碼查詢
	"MANUAL_PRESENT_BROWSE"=>"member.manual_present_browse.tpl",	// 手動設為出席之 log 瀏覽
	"PRESENT_STATISTIC"=>"member.present_statistic.tpl",			// 出席統計報表
	"CHECK"=>"member.check.tpl",		// 檢查參加人員名單
);



if ($mysql_obj){
	$member_obj = new DB();
	$member_obj->init($mysql_obj, $CFG[MEMBER_TBL]) OR DIE("系統發生錯誤: 參加人員資料庫物件初始化失敗<br>".join("<br>", $member_obj->msg->get(2)));
}

