<?php
/**
 *	程式名稱：	抽獎後台管理
 *	檔案名稱：	module.prize_list.php
 *	版　　本：	1.0.0.
 *	作　　者：	Jacky Jou<starjou@price.com.tw>, Gilbert Chiao <gilbertchiao@gmail.com>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2006.12.29.
 *	更新日期：	2008.01.08.
 *	說　　明：
 */


// ===== 初始化物件
require_once _DIR_LIB_DBCFG . 'config.prize_list.php';
require_once _DIR_LIB_DBCFG . 'config.prize.php';
require_once _DIR_LIB_DBCFG . 'config.sms_log.php';

require_once _DIR_LIB_FUNCTION . 'JSescape.php';
require_once _DIR_LIB_CLASS . 'class.Javascript.php';

// ===== 模組化參數設定
$cm_title = '得獎名單';
$cm_func = 'prize_list';
$cm_func2 = 'PRIZE_LIST';
$cm_obj = $przlst_obj;
$op[cm_func] = $cm_func;
$op[cm_title] = $cm_title;
$op[cm_url] = $SELF;


// * 圖檔上傳所需設定
//$cm_image_dir = _DIR_UPLOAD . '/';			// 圖檔存放資料夾
//$cm_image_url = _URL_UPLOAD . '/';			// 圖檔資料夾URL

# 除錯設定
$op[cm_debug] = false;
#$layout->smarty->debugging = true;
$layout->smarty->clear_compiled_tpl();

$layout->assign($op);


// ===== 常用變數
$return = $SELF . '?PHP_dType=' . $cm_func;
$action = $_REQUEST['PHP_action'];

# 列表
$prize_obj->CFG[DB_COLS_SORT] = "no, id";
$prize_item_list = $prize_obj->db_browse('LIST_ALL', array('sr_project_id'=>$ProjectInfo[id],'sr_not_deleted'=>1,'sr_not_deleted'=>1,'sr_not_hide'=>1));
$op[prize_item_list] = $prize_item_list[pds];



$layout->assign($op);

// ===== 主程式
switch($action){
#########################
#	@ 主選單
#########################
	default:
	case 'main':
//		$tmp_argv=array();
//		$tmp_argv[sr_not_deleted] = 1;
//		$prz_list = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
//		$op[prz_list] = $prz_list[pds];
		$tmp_argv=array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_not_hide] = 1;
		$tmp_argv[sr_not_quota_or_draw_once] = 1;
		$tmp_argv[sr_not_drawn] = 1;
		$tmp_argv[sr_not_star234] = 1;
		$prize_obj->CFG[DB_COLS_SORT] = "no, id";
		$prize_items = $prize_obj->db_browse("LIST_ALL", $tmp_argv);
		$prize_items = $prize_items[pds];

		$cnt_prize = count($prize_items);

		$tmp_argv=array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_not_hide] = 1;
		$tmp_argv[sr_is_quota] = 1;
		$tmp_argv[sr_quota_not_zero] = 1;
		$tmp_argv[sr_quota_not_drawn] = 1;
		$tmp_argv[sr_not_draw_once] = 1;
		$tmp_argv[sr_not_star234] = 1;
		$prize_obj->CFG[DB_COLS_SORT] = "no, id, quota_id";
		$prize_obj->CFG[BROWSE_SQL_TITLE] = $prize_obj->CFG[BROWSE_SQL_TITLE_QUOTA];
		$prize_quota_items = $prize_obj->db_browse("LIST_ALL", $tmp_argv);
		$prize_quota_items = $prize_quota_items[pds];
		$cnt_prize_quota = count($prize_quota_items);

		// 將有配額及無配額獎項排序成一個陣列
		$prizes = array();
		while($cnt_prize>0 || $cnt_prize_quota>0){
			if(!$tmp_prize && $cnt_prize > 0){	// 存在無配額獎項且尚未初始化
				$tmp_prize = array_shift($prize_items);
			}
			if(!$tmp_prize_quota && $cnt_prize_quota > 0){	// 存在有配額獎項且尚未初始化
				$tmp_prize_quota = array_shift($prize_quota_items);
			}
			if($cnt_prize > 0 && $cnt_prize_quota > 0){		// 同時存在有配額及無配額獎項，比較 no 及 id
				if($tmp_prize[no] && $tmp_prize_quota[no]){	// 兩者都有設定排序編號
					if($tmp_prize[no] > $tmp_prize_quota[no]){
						$cnt_prize_quota = $cnt_prize_quota - 1 ;
						$prizes[] = $tmp_prize_quota;
						if($cnt_prize_quota){
							$tmp_prize_quota = array_shift($prize_quota_items);
						}
					}
					else{
						$cnt_prize = $cnt_prize - 1;
						$prizes[] = $tmp_prize;
						if($cnt_prize){
							$tmp_prize = array_shift($prize_items);
						}
					}
				}
				elseif($tmp_prize[no]){	// 只有無配額獎額有設定排序編號	(沒設定排序編號的放在前)
					$cnt_prize_quota = $cnt_prize_quota - 1;
					$prizes[] = $tmp_prize_quota;
					if($cnt_prize_quota){
						$tmp_prize_quota = array_shift($prize_quota_items);
					}
				}
				elseif($tmp_prize_quota[no]){	// 只有有配額獎額有設定排序編號
					$cnt_prize = $cnt_prize - 1;
					$prizes[] = $tmp_prize;
					if($cnt_prize){
						$tmp_prize = array_shift($prize_items);
					}
				}
				else{	// 都沒有設定排序編號，比較 id
						if($tmp_prize[id] > $tmp_prize_quota[id]){
						$cnt_prize_quota = $cnt_prize_quota - 1;
						$prizes[] = $tmp_prize_quota;
						if($cnt_prize_quota){
							$tmp_prize_quota = array_shift($prize_quota_items);
						}
					}
					else{
						$cnt_prize = $cnt_prize - 1;
						$prizes[] = $tmp_prize;
						if($cnt_prize){
							$tmp_prize = array_shift($prize_items);
						}
					}
				}
			}
			elseif($cnt_prize > 0 ){	// 只存在無配額獎項
				$cnt_prize = $cnt_prize - 1;
				$prizes[] = $tmp_prize;
				if($cnt_prize){
					$tmp_prize = array_shift($prize_items);
				}
			}
			else{	//只存在有配額獎項
				$cnt_prize_quota = $cnt_prize_quota - 1;
				$prizes[] = $tmp_prize_quota;
				if($cnt_prize_quota){
					$tmp_prize_quota = array_shift($prize_quota_items);
				}
			}
		}
		//echo "<pre>"; print_r($prizes);
		require_once _DIR_LIB_DBCFG. 'config.class.php';
		$class_obj->CFG[DB_COLS_SORT] = "id";
		$op[class_list] = $class_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id]));

		$op[prize_items] = $prizes;

		$layout->display($cm_obj->CFG[LAYOUT]['MAIN'], $op);
		break;



	#########################
	#	@ 資料瀏覽及搜尋
	#########################
	case 'browse':
		// ===== DB物件分頁設定
		$cm_obj->CFG[ROW_PER_PAGE] = 30;
		if ($RQT[PHP_sr_page]) {
			$RQT[PHP_sr_startno] = ($RQT[PHP_sr_page] - 1) * $cm_obj->CFG[ROW_PER_PAGE];
		}

		// ===== 設定要排序的欄位
		$sorttypes = array(
			"id"=>"PRZLST.id",
			"lottery_no"=>"MBR.lottery_no",
			"member_code"=>"MBR.member_code",
			"department"=>"MBR.department",
			"seq_no"=>"PRZLST.seq_no",
		);

		//設定查詢資料時之排序欄位/預設排序欄位
		$sorttype = $RQT[PHP_sr_sorttype]? $RQT[PHP_sr_sorttype]: "uid";
		foreach($sorttypes AS $key=>$val){
			$sortstr = ($sorttype == "d{$key}")? "{$val} DESC": $sortstr;
			$sortstr = ($sorttype == "u{$key}")? $val: $sortstr;
		}
		$cm_obj->CFG[DB_COLS_SORT] = $sortstr;
		$cm_obj->CFG[DB_SORT_TYPE] = $sorttype;

		// ===== 執行搜尋
		$RQT[sr_not_deleted] = 1;
		$RQT[sr_project_id] = $ProjectInfo[id];
		$datas = $cm_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0001', $cm_obj->msg->get(2));

		foreach ($sorttypes AS $key=>$val){
			$im = "<a href='{$datas[cgistr_get]}&PHP_sr_sorttype=d{$key}'><img src=\"images/down.gif\" width=13 height=13 border=0 align=absmiddle></a>";
			$datas["im".$key] = ($datas[sorttype]=="d{$key}")?"<a href='{$datas[cgistr_get]}&PHP_sr_sorttype=u{$key}'><img src=\"images/downy.gif\" width=13 height=13 border=0 align=absmiddle></a>":$im;
			$datas["im".$key]=($datas[sorttype]=="u{$key}")?"<a href='{$datas[cgistr_get]}&PHP_sr_sorttype=d{$key}'><img src=\"images/upy.gif\" width=13 height=13 border=0 align=absmiddle></a>":$datas["im".$key];
		}

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][strtoupper($action)], $datas);
		break;



	#########################
	#	@ 匯出得獎名單
	#########################
	case 'export':
		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_project_id] = $ProjectInfo[id];

		$cm_obj->CFG[DB_COLS_SORT] = "id";
            
		$datas = $cm_obj->db_browse('LIST_ALL',$tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0033', $cm_obj->msg->get(2));

		$op[datas] = $datas[pds];
		unset($datas);

		$layout->assign($op);
		$content = $layout->fetch($cm_obj->CFG[LAYOUT]['EXPORT'],$op);
		ob_start();
		// 產生CSV檔
		if (headers_sent()) {
			echo "error!";
			exit;
		}
		header("Content-Type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=prize_list3.xls");
		header('Pragma: no-cache');
		header('Expires: 0');
		echo $content;
		ob_flush();
		break;



	#########################
	#	@ 設定目前抽獎項目
	#########################
	case 'set_current_item':
		// ===== 輸入資料確認
		$RQT[PHP_id] OR gotoUrl($return, "未指定抽獎項目!", 3, array(), _ER_USER_NOTICE, 'ER_PRIZE_LIST_0002', array("無法設定目前抽獎項目!", "使用者未指定資料編號!"));

		//select prize deatil for project last_3  Tenchi
		require_once _DIR_LIB_DBCFG . 'config.prize.php';
		$tmp_argv = array();
		$tmp_argv[sr_id] = $RQT[PHP_id];
		$prize_detail = $prize_obj->db_browse("LIST_ALL", $tmp_argv);
print_r($prize_detail);
#exit;

		require_once _DIR_LIB_DBCFG . 'config.project.php';

		$tmp_argv = array();
		$tmp_argv[id] = $ProjectInfo[id];
		$tmp_argv[current_item] = $RQT[PHP_id];
		$tmp_argv[last_3] = $prize_detail[pds][0][last_3]; //insert prize's last_3 to project last_3 Tenchi
		$prj_obj->db_modify($tmp_argv) OR gotoUrl($return, "讀取專案資料時發生錯誤!!", 3, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0003', $prj_obj->msg->get(2));
		$ProjectInfo[current_item] = $RQT[PHP_id];
		$ProjectInfo[last_3] = $tmp_argv[last_3];

		if ($RQT[PHP_id] != "main"){
			$tmp_argv= array();
			$tmp_argv[id] = 1;
			$tmp_argv[status_ary][IS_DRAW] = 0;
			require_once _DIR_LIB_DBCFG . 'config.sys_config.php';
			$sys_cfg_obj->db_modify($tmp_argv);
			$status_str = "ready=0";
			//$status_str = "";
			$fp = fopen("status.txt", "w");
			fwrite($fp, $status_str);
			fclose($fp);
			//$layout->display('button.done.tpl', $op);
		}

		gotoUrl($return, "設定完成!", 1);
		break;



	#########################
	#	@ 產生四星彩貳獎
	#########################
	case 'generate_star_prizes':
	case 'generate_star2_prizes':
		require_once _DIR_LIB_DBCFG . 'config.member.php';

		//取得貳獎資料
		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_star2] = 1;
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$star2 = $prize_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0004', $prize_obj->msg->get(2));
		if(!count($star2[pds])) {
			gotoUrl($return, "未設定四星彩貳獎!!",3, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0005',array("未設定四星彩貳獎!!"));
		}
		$star2 = $star2[pds][0];

		// 將原先得獎群組紀錄清除 龍的傳人
		if($star2[group_num]){
			$tmp_argv = array();
			$tmp_argv[sr_prize_id] = $star2[id];
			$tmp_argv[sr_not_deleted] = 1;
			$old_winner = $przlst_obj->db_browse("LIST_ALL", $tmp_argv);
			foreach($old_winner[pds] as $val1){
				$tmp_member = $member_obj->get_db_detail($val1[member_id]);
				$tmp_argv3 = array();
				$tmp_argv3[id] = $val1[member_id];
				$tmp_argv3[groupmark] = $tmp_member[groupmark] & ~pow(2 , ($star2[group_num] - 1));
				$member_obj->db_modify($tmp_argv3);
			}
		}

		// 刪除原有四星彩貳獎得獎名單
		if($RQT[sr_class_id]){
			$q_try="DELETE prize_list FROM prize_list LEFT JOIN member ON prize_list.member_id = member.id WHERE prize_list.project_id = ".$ProjectInfo[id]. " AND (prize_list.`status` & 16 <> 0) AND member.class_id = ".$RQT[sr_class_id];
		}
		else{
			$q_try="DELETE FROM prize_list WHERE project_id = ".$ProjectInfo[id]. " AND (`status` & 16 <> 0) ";
		}
		//echo $q_try; exit;
		$cm_obj->sql->query($q_try);

		// 取得四星彩頭獎資料
		$tmp_argv = array();
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_star1] = 1;
		$tmp_argv[sr_class_id] = $RQT[sr_class_id];
		$star1 = $cm_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0006', $cm_obj->msg->get(2));
		if(!count($star1[pds])){
			gotoUrl($return, "四星彩頭獎號碼尚未抽出!!",3, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0007',array("四星彩頭獎號碼尚未抽出!!"));
		}

		foreach($star1[pds] as $val){
			//新增貳獎
			//取得中獎名單
			$tmp_argv = array();
			$tmp_argv[sr_project_id] = $ProjectInfo[id];
			$tmp_argv[sr_not_deleted] = 1;
			$tmp_argv[sr_not_lottery_no] = $val[lottery_no];
			$tmp_argv[sr_lottery_no_leader_letter] = substr($val[lottery_no], 0,1);

			$last_letter_filter = substr($val[lottery_no], -3);
			if($last_letter_filter != '000')
				$tmp_argv[sr_lottery_no_last_letters] = $last_letter_filter;
			else
				$tmp_argv[sr_lottery_no_last_zero3] = 1;
			//$tmp_argv[sr_lottery_no_last_letters] = substr($val[lottery_no], -3);

			if($ProjectInfo[status_ary][IS_NEED_PRESENT]){
				$tmp_argv[sr_present] = 1;
			}
			if($star2[group_num]){	// 群組不可重覆中獎
				$tmp_argv[sr_group_clean] = pow(2 , ($star2[group_num] - 1)) ;
			}
			if($star2[status_ary][IS_QUALIFICATION]){			// 獎項設有資格檢查
				$tmp_argv[sr_qualification] = pow(2 , ($star2[qualification_kind] - 1)) ;
			}

			$winner = $member_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, "讀取會員資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0008', $member_obj->msg->get(2));

			foreach($winner[pds] as $val2){
				$tmp_argv2 = array();
				$tmp_argv2[prize_id] = $star2[id];
				$tmp_argv2[member_id] = $val2[id];
				$tmp_argv2[project_id] = $ProjectInfo[id];
				$tmp_argv2[status_ary][IS_STAR2] = 1;
				$cm_obj->db_add($tmp_argv2)   OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0009', $cm_obj->msg->get(2));
				if($star2[group_num]){
					$tmp_argv4 = array();
					$tmp_argv4[id] = $val2[id];
					$tmp_argv4[groupmark] = ($val2[groupmark] | pow(2,$star2[group_num] - 1));
					//$member_obj->debug = true;
					$member_obj->db_modify($tmp_argv4)  OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0010', $member_obj->msg->get(2));
				}
			}

		}
		if($action != 'generate_star_prizes'){
			gotoUrl($return, '產生四星彩貳獎名單完成!', 1);
			break;
		}


	#########################
	#	@ 產生四星彩參獎
	#########################
	case 'generate_star3_prizes':
		require_once _DIR_LIB_DBCFG . 'config.member.php';

		//取得參獎資料
		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_star3] = 1;
		$star3 = $prize_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0011', $prize_obj->msg->get(2));
		if(!count($star3[pds])) {
			gotoUrl($return, "未設定四星彩參獎!!",3, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0012',array("未設定四星彩參獎!!"));
		}
		$star3 = $star3[pds][0];
		// 將原先得獎群組紀錄清除
		if($star3[group_num]){
			$tmp_argv = array();
			$tmp_argv[sr_prize_id] = $star3[id];
			$tmp_argv[sr_not_deleted] = 1;
			$old_winner = $przlst_obj->db_browse("LIST_ALL", $tmp_argv);

			foreach($old_winner[pds] as $val1){
				$tmp_member = $member_obj->get_db_detail($val1[member_id]);
				$tmp_argv3 = array();
				$tmp_argv3[id] = $val1[member_id];
				$tmp_argv3[groupmark] = $tmp_member[groupmark] & ~pow(2 , ($star3[group_num] - 1));
				//echo $tmp_member[groupmark] ."-". pow(2 , ($star3[group_num] - 1))."-". $tmp_argv3[groupmark] ."<br> ";
				$member_obj->db_modify($tmp_argv3);
			}
		}

		// 刪除原有四星彩參獎得獎名單
		if ($RQT[sr_class_id]) {
			$q_try="DELETE prize_list FROM prize_list LEFT JOIN member ON prize_list.member_id = member.id WHERE prize_list.project_id = ".$ProjectInfo[id]. " AND (prize_list.`status` & 32 <> 0) AND member.class_id = ".$RQT[sr_class_id];
		}
		else {
			$q_try="DELETE FROM prize_list WHERE project_id = ".$ProjectInfo[id]. " AND ( `status` & 32 <> 0 ) ";
		}
		$cm_obj->sql->query($q_try);

		// 取得四星彩頭獎資料
		$tmp_argv = array();
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_star1] = 1;
		$tmp_argv[sr_class_id] = $RQT[sr_class_id];
		$star1 = $cm_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0013', $cm_obj->msg->get(2));
		if(!count($star1[pds])){
			gotoUrl($return, "四星彩頭獎號碼尚未抽出!!",3, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0014',array("四星彩頭獎號碼尚未抽出!!"));
		}

		foreach($star1[pds] as $val){
			//新增參獎
			//取得中獎名單
			$tmp_argv = array();
			$tmp_argv[sr_project_id] = $ProjectInfo[id];
			$tmp_argv[sr_not_deleted] = 1;
			$tmp_argv[sr_not_lottery_no] = $val[lottery_no];
			$tmp_argv[sr_lottery_no_leader_letter] = substr($val[lottery_no], 0,1);

			$last_letter_filter = substr($val[lottery_no], -2);
			if ($last_letter_filter != '00')
				$tmp_argv[sr_lottery_no_last_letters] = $last_letter_filter;
			else
				$tmp_argv[sr_lottery_no_last_zero2] = 1;
			//$tmp_argv[sr_lottery_no_last_letters] = substr($val[lottery_no], -2);

			$last_letter_not_filter = substr($val[lottery_no], -3);
			if($last_letter_not_filter != '000')
				$tmp_argv[sr_not_lottery_no_last_letters] = $last_letter_not_filter;
			else
				$tmp_argv[sr_not_lottery_no_last_zero3] = 1;
			//$tmp_argv[sr_not_lottery_no_last_letters] = substr($val[lottery_no], -3);

			if($ProjectInfo[status_ary][IS_NEED_PRESENT]){
				$tmp_argv[sr_present] = 1;
			}
			if($star3[group_num]){	// 群組不可重覆中獎
				$tmp_argv[sr_group_clean] = pow(2 , ($star3[group_num] - 1)) ;
			}
			if($star3[status_ary][IS_QUALIFICATION]){			// 獎項設有資格檢查
				$tmp_argv[sr_qualification] = pow(2 , ($star3[qualification_kind] - 1)) ;
			}
			$winner = $member_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, "讀取會員資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0015', $member_obj->msg->get(2));
			foreach($winner[pds] as $val2){
				$tmp_argv2 = array();
				$tmp_argv2[prize_id] = $star3[id];
				$tmp_argv2[member_id] = $val2[id];
				$tmp_argv2[project_id] = $ProjectInfo[id];
				$tmp_argv2[status_ary][IS_STAR3] = 1;
				$cm_obj->db_add($tmp_argv2)   OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0016', $cm_obj->msg->get(2));
				if($star3[group_num]){
					$tmp_argv4 = array();
					$tmp_argv4[id] = $val2[id];
					$tmp_argv4[groupmark] = ($val2[groupmark] | pow(2,$star3[group_num] - 1));
					//$member_obj->debug = true;
					$member_obj->db_modify($tmp_argv4)  OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0017', $member_obj->msg->get(2));
				}
			}

		}

		if($action != 'generate_star_prizes'){
			gotoUrl($return, '產生四星彩參獎名單完成!', 1);
			break;
		}



	#########################
	#	@ 產生四星彩肆獎
	#########################
	case 'generate_star4_prizes':
		require_once _DIR_LIB_DBCFG . 'config.member.php';

		//取得肆獎資料
		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_star4] = 1;
		$star4 = $prize_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0018', $prize_obj->msg->get(2));
		if(!count($star4[pds])) {
			gotoUrl($return, "未設定四星彩肆獎!!",3, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0019',array("未設定四星彩肆獎!!"));
		}
		$star4 = $star4[pds][0];
		// 將原先得獎群組紀錄清除
		if($star4[group_num]){
			$tmp_argv = array();
			$tmp_argv[sr_prize_id] = $star4[id];
			$tmp_argv[sr_not_deleted] = 1;
			$old_winner = $przlst_obj->db_browse("LIST_ALL", $tmp_argv);
			foreach($old_winner[pds] as $val1){
				$tmp_member = $member_obj->get_db_detail($val1[member_id]);
				$tmp_argv3 = array();
				$tmp_argv3[id] = $val1[member_id];
				$tmp_argv3[groupmark] = $tmp_member[groupmark] & ~pow(2 , ($star4[group_num] - 1));
				$member_obj->db_modify($tmp_argv3);
			}
		}

		// 刪除原有四星彩肆獎得獎名單
		if($RQT[sr_class_id]){
			$q_try="DELETE prize_list FROM prize_list LEFT JOIN member ON prize_list.member_id = member.id WHERE prize_list.project_id = ".$ProjectInfo[id]. " AND (prize_list.`status` & 64 <> 0) AND member.class_id = ".$RQT[sr_class_id];
		}
		else{
			$q_try="DELETE FROM prize_list WHERE project_id = ".$ProjectInfo[id]. " AND (`status` & 64 <> 0) ";
		}
		$cm_obj->sql->query($q_try);

		// 取得四星彩頭獎資料
		$tmp_argv = array();
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_star1] = 1;
		$tmp_argv[sr_class_id] = $RQT[sr_class_id];
		$star1 = $cm_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0020', $cm_obj->msg->get(2));
		if(!count($star1[pds])){
			gotoUrl($return, "四星彩頭獎號碼尚未抽出!!",3, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0021',array("四星彩頭獎號碼尚未抽出!!"));
		}
		//echo "<pre>"; print_r($star1);
		foreach($star1[pds] as $val){
			//新增肆獎
			//取得中獎名單
			$tmp_argv = array();
			$tmp_argv[sr_project_id] = $ProjectInfo[id];
			$tmp_argv[sr_not_deleted] = 1;
			$tmp_argv[sr_not_lottery_no] = $val[lottery_no];
			$tmp_argv[sr_lottery_no_leader_letter] = substr($val[lottery_no], 0,1);

			$last_letter_filter = substr($val[lottery_no], -1);
			if($last_letter_filter != '0')
				$tmp_argv[sr_lottery_no_last_letters] = $last_letter_filter;
			else
				$tmp_argv[sr_lottery_no_last_zero] = 1;
			//$tmp_argv[sr_lottery_no_leader_letter] = substr($val[lottery_no], 0,1);

			$last_letter_not_filter = substr($val[lottery_no], -2);
			if($last_letter_not_filter != '00')
				$tmp_argv[sr_not_lottery_no_last_letters] = $last_letter_not_filter;
			else
				$tmp_argv[sr_not_lottery_no_last_zero2] = 1;
			//$tmp_argv[sr_not_lottery_no_last_letters] = substr($val[lottery_no], -2);

			if($ProjectInfo[status_ary][IS_NEED_PRESENT]){
				$tmp_argv[sr_present] = 1;
			}
			if($star4[group_num]){	// 群組不可重覆中獎
				$tmp_argv[sr_group_clean] = pow(2 , ($star4[group_num] - 1)) ;
			}
			if($star4[status_ary][IS_QUALIFICATION]){			// 獎項設有資格檢查
				$tmp_argv[sr_qualification] = pow(2 , ($star4[qualification_kind] - 1)) ;
			}

			$winner = $member_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, "讀取會員資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0022', $member_obj->msg->get(2));

			foreach($winner[pds] as $val2){
				$tmp_argv2 = array();
				$tmp_argv2[prize_id] = $star4[id];
				$tmp_argv2[member_id] = $val2[id];
				$tmp_argv2[project_id] = $ProjectInfo[id];
				$tmp_argv2[status_ary][IS_STAR4] = 1;
				$cm_obj->db_add($tmp_argv2)   OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0024', $cm_obj->msg->get(2));
				if($star4[group_num]){
					$tmp_argv4 = array();
					$tmp_argv4[id] = $val2[id];
					$tmp_argv4[groupmark] = ($val2[groupmark] | pow(2,$star4[group_num] - 1));
					//$member_obj->debug = true;
					$member_obj->db_modify($tmp_argv4)  OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0025', $member_obj->msg->get(2));
				}
			}
		}

		if ($action != 'generate_star_prizes') {
			gotoUrl($return, '產生四星彩肆獎名單完成!', 1);
		}
		else {
			gotoUrl($return, '產生全部四星彩名單完成!', 1);
		}
		break;



	#########################
	#	@ 簡訊批次通知
	#########################
	case 'submit_sms_batch':
		// 檢查簡訊設定
		if(empty($SysConfig[sms_number]) || empty($SysConfig[sms_pass]) ){
			gotoUrl($return, '未設定簡訊傳送帳號密碼，無法傳送簡訊!', 3);
		}
		// 檢查簡訊內容
		if(!$ProjectInfo[cong_msg]){
			gotoUrl($return, '本專案簡訊賀詞尚未設定，無法傳送簡訊!', 3);
		}

		$RQT[sr_not_deleted] = 1;
		$RQT[sr_project_id] = $ProjectInfo[id];
		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_SMS];
		$datas = $cm_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0026', $cm_obj->msg->get(2));
		require_once _DIR_LIB_DBCFG . 'config.sys_config.php';
		foreach($datas[pds] as $val){

			// 檢查手機號碼
			if(!$val[cell]){
				$tmp_argv = array();
				$tmp_argv[id] = $val[id];
				$tmp_argv[sms_status_msg] = "無手機號碼，傳送失敗。";
				$cm_obj->db_modify($tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0027', $cm_obj->msg->get(2));
			}
			else{
				//將彩券號碼lottery_no換成工號member_code by Wun-Hao Liu @ 2012/01/19
				//send_sms($val[id], $val[prize_id], $val[cell], $val[lottery_no], $val[family_name]?$val[family_name]:$val[member_name]);
				send_sms($val[id], $val[prize_id], $val[cell], $val[member_code], $val[family_name]?$val[family_name]:$val[member_name]);
			}
		}
		gotoUrl($return, '簡訊批次發送完成!', 3);
		break;



	#########################
	#	@ 簡訊批次通知
	#########################
	case 'submit_sms_batch2':
		// 檢查簡訊設定
		if(empty($SysConfig[sms_number]) || empty($SysConfig[sms_pass]) ){
			gotoUrl($return, '未設定簡訊傳送帳號密碼，無法傳送簡訊!', 3);
		}
		// 檢查簡訊內容
		if(!$ProjectInfo[cong_msg]){
			gotoUrl($return, '本專案簡訊賀詞尚未設定，無法傳送簡訊!', 3);
		}

		require_once _DIR_LIB_DBCFG . 'config.member.php';
		require_once _DIR_LIB_DBCFG . 'config.sys_config.php';

		foreach($RQT[input][id] as $val){
			$prize_list_data = $cm_obj->get_db_detail($val);
			$member_data = $member_obj->get_db_detail($prize_list_data[member_id]);

			// 檢查手機號碼
			if(!$member_data[cell]){
				$tmp_argv = array();
				$tmp_argv[id] = $prize_list_data[id];
				$tmp_argv[sms_status_msg] = "無手機號碼，傳送失敗。";
				$cm_obj->db_modify($tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0028', $cm_obj->msg->get(2));
			}
			else{
				//將彩券號碼 lottery_no 換成工號 member_code by Wun-Hao Liu @ 2012/01/19
				//send_sms($prize_list_data[id], $prize_list_data[prize_id], $member_data[cell], $member_data[lottery_no], $member_data[family_name]?$member_data[family_name]:$member_data[name]);
				send_sms($prize_list_data[id], $prize_list_data[prize_id], $member_data[cell], $member_data[member_code], $member_data[family_name]?$member_data[family_name]:$member_data[name]);
			}
		}
		gotoUrl($return, '簡訊勾選發送完成!', 3);
		break;



	#########################
	#	@ 簡訊單筆通知
	#########################
	case 'submit_sms':
		// 檢查簡訊設定
		if(empty($SysConfig[sms_number]) || empty($SysConfig[sms_pass]) ){
			gotoUrl($return, '未設定簡訊傳送帳號密碼，無法傳送簡訊!', 3);
		}
		// 檢查簡訊內容
		if(!$ProjectInfo[cong_msg]){
			gotoUrl($return, '本專案簡訊賀詞尚未設定，無法傳送簡訊!', 3);
		}

		require_once _DIR_LIB_DBCFG . 'config.member.php';
		require_once _DIR_LIB_DBCFG . 'config.sys_config.php';

		$RQT[sr_project_id] = $ProjectInfo[id];
		$prize_list_data = $cm_obj->db_browse("LIST_ALL",$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0029', $cm_obj->msg->get(2));
		$prize_list_data = $prize_list_data[pds][0];
		$member_data = $member_obj->db_browse("LIST_ALL",$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0030', $member_obj->msg->get(2));
		if(count($member_data[pds]) == 1){

			// 檢查手機號碼
			$member_data = $member_data[pds][0];
			if(!$member_data[cell]){
				$tmp_argv = array();
				$tmp_argv[id] = $prize_list_data[id];
				$tmp_argv[sms_status_msg] = "無手機號碼，傳送失敗。";
				$cm_obj->db_modify($tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0031', $cm_obj->msg->get(2));
				gotoUrl($return, '無手機號碼，傳送失敗。', 3);
			}
			else{
				//將彩券號碼 lottery_no 換成工號 member_code by Wun-Hao Liu @ 2012/01/19
				//send_sms($prize_list_data[id], $prize_list_data[prize_id], $member_data[cell], $member_data[lottery_no], $member_data[family_name]?$member_data[family_name]:$member_data[name]);
				send_sms($prize_list_data[id], $prize_list_data[prize_id], $member_data[cell], $member_data[member_code], $member_data[family_name]?$member_data[family_name]:$member_data[name]);
			}
		}
		else{
			gotoUrl($return, '查無資料!', 3);
		}

		gotoUrl($return, '簡訊傳送完成!', 3);
		break;



	#########################
	#	@ 簡訊狀態瀏覽
	#########################
	case 'sms_browse':
		$cm_obj->CFG[ROW_PER_PAGE] = 30;
		if ($RQT[PHP_sr_page])
			$RQT[PHP_sr_startno] = ($RQT[PHP_sr_page] - 1) * $cm_obj->CFG[ROW_PER_PAGE];
		$RQT[sr_not_deleted] = 1;
		$RQT[sr_project_id] = $ProjectInfo[id];
		$cm_obj->CFG[DB_COLS_SORT] = "no, lottery_no";
		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_SMS];
		$datas = $cm_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0032', $cm_obj->msg->get(2));

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][strtoupper($action)], $datas);
		break;



	#########################
	#	@ 簡訊發送紀錄瀏覽
	#########################
	case 'sms_log_browse':
		// ===== 顯示畫面
		$sms_log_obj->CFG[ROW_PER_PAGE] = 30;
		if ($RQT[PHP_sr_page])
			$RQT[PHP_sr_startno] = ($RQT[PHP_sr_page] - 1) * $sms_log_obj->CFG[ROW_PER_PAGE];

		$RQT[sr_not_deleted] = 1;
		$RQT[sr_project_id] = $ProjectInfo[id];
		$sms_log_obj->CFG[DB_COLS_SORT] = "lottery_no, create_time";
		$datas = $sms_log_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0033', $sms_log_obj->msg->get(2));

		$layout->display($sms_log_obj->CFG[LAYOUT][strtoupper($action)], $datas);
		break;


// ============= add 2016
	/**
	 * 香信生活頻道
	 */
	case 'submit_im_batch':
		if (!$RQT[sr_prize_id]) {
			gotoUrl($return, 'Please select prize first!', 3);
			return;
		}
	
		$RQT[sr_not_deleted] = 1;
		$RQT[sr_project_id] = $ProjectInfo[id];
		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_SMS];
		$datas = $cm_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0026', $cm_obj->msg->get(2));

		$person_num = count($datas[pds]);
		
		// get prize information
		$q_str = sprintf(
			"SELECT * FROM prize WHERE id=%d AND status&1=0 LIMIT 1",
			$RQT[sr_prize_id]
		);
		$rlt = mysql_query($q_str, $db_link_master);
		if ($rlt === false) {
			gotoUrl($return, 'Cound NOT get prize information.', 3);
			return;
		}
		$prize_info = mysql_fetch_assoc($rlt);

        // added by Jason
        if ($prize_info[last_3] != 0) {
		    $q_str1 = sprintf(
    			"select a.name,b.prize_name,c.lastNum,d.lottery_no,d.member_code,d.name AS member_name from project a,prize b,project_prize_num c,member d where b.id = %d and a.id = c.projectId and a.id = b.project_id and b.id = c.prizeId and a.id = d.project_id and d.lottery_no like concat('%%',c.lastNum) and (c.qualification & d.qualification = c.qualification)",
    			$RQT[sr_prize_id]
    		);
    		$rlt1 = mysql_query($q_str1, $db_link_master);
    		if ($rlt1 === false) {
    			gotoUrl($return, 'Cound NOT get information.', 3);
    			return;
    		}
    		$person_num = mysql_num_rows ($rlt1);
            while( $row = mysql_fetch_assoc( $rlt1)){
                $datas[pds][] = $row; // Inside while loop
            }
        }
    
$request = <<<EOT
<xml>
	<round>{$prize_info[prize_name]}(test)</round>
	<award_item>{$prize_info[prize_desc]}(test)</award_item>
	<award_item_say>{$prize_info[prize_desc]}(test)</award_item_say>
	<person_num>{$person_num}</person_num>
	<persons>
EOT;

		foreach($datas[pds] as $val){			
                  $lotname = "";
                  //$lotname = $val[member_name] . " 眷屬:" . $val[family_name] ;
	             $lotname = $val[member_name] ;
		$str = <<<EOT
		<person>
			<empid>{$val[member_code]}</empid>
			<empname>{$lotname }</empname>
		</person>
EOT;

			$request .= $str;
		}
		
		$request .= <<<EOT
	</persons>
</xml>
EOT;
		
		$request_url = 'http://icivetapps.foxconn.com/SaaS/000155/ClubApi/ImportAward';

		// send request
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $request_url);
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: text/plain'));
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$response = curl_exec($ch); 
		curl_exec($ch);
		curl_close($ch);
              
		// record request & response to file: ./upload/im_[time].log
		$fp = fopen('./upload/im_' . time() . '.log', 'w+');
		fwrite($fp, "Request:\r\n");
		fwrite($fp, $request."\r\n");
		fwrite($fp, "Response:\r\n");
		fwrite($fp, $response."\r\n");
		fclose($fp);
          

		gotoUrl($return, 'Export Done: ' . $response, 15);
		break;
// ============= end: add 2016

	#########################
	#	@ 列印得獎名單統計
	#########################
	case 'statistic_print':
		$op[print_time] = date("Y-m-d H:i", time());
		require_once _DIR_LIB_DBCFG. 'config.class.php';
		$class_obj->CFG[DB_COLS_SORT] = "id";
		$op[class_list] = $class_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id]));
		if(count($op[class_list][pds])){
			$tmp_argv = array();
			$tmp_argv[sr_project_id] = $ProjectInfo[id];
			$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_STATISTIC];
			$cm_obj->CFG[DB_COLS_SORT] = "PRZ.id";
			$cm_obj->CFG[DB_COLS_GROUP] = " prize_id ";
			//echo $cm_obj->CFG[BROWSE_SQL_TITLE_STATISTIC];
			//$cm_obj->debug = true;
			foreach($op[class_list][pds] as $key=>$val){
				$tmp_argv[sr_class_id] = $val[id];
				$op[class_list][pds][$key][prize_list] = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
			}
		}

		$layout->display($cm_obj->CFG[LAYOUT][strtoupper($action)], $op);
		break;
	
	#########################
	#	@ 匯出得獎名單統計
	#########################
	case 'statistic_print_ex':
		$op[print_time] = date("Y-m-d H:i", time());
		require_once _DIR_LIB_DBCFG. 'config.class.php';
		$class_obj->CFG[DB_COLS_SORT] = "id";
		$op[class_list] = $class_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id]));
		if(count($op[class_list][pds])){
			$tmp_argv = array();
			$tmp_argv[sr_project_id] = $ProjectInfo[id];
			$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_STATISTIC];
			$cm_obj->CFG[DB_COLS_SORT] = "PRZ.id";
			$cm_obj->CFG[DB_COLS_GROUP] = " prize_id ";
			//echo $cm_obj->CFG[BROWSE_SQL_TITLE_STATISTIC];
			//$cm_obj->debug = true;
			foreach($op[class_list][pds] as $key=>$val){
				$tmp_argv[sr_class_id] = $val[id];
				$op[class_list][pds][$key][prize_list] = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
			}
		}

		$content = $layout->display($cm_obj->CFG[LAYOUT][strtoupper($action)], $op);
		ob_start();
		// 產生CSV檔
		if (headers_sent()) {
			echo "error!";
			exit;
		}
		header("Content-Type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=prize_list2.xls");
		header('Pragma: no-cache');
		header('Expires: 0');
		echo $content;
		ob_flush();
		break;




	#########################
	#	@ 列印得獎名單統計
	#########################
	case 'group_statistic_print':

		// 各事業群出席率 2008.01.31. Gilbert.
		$q_str = "SELECT COUNT(*) AS cnt, business_group FROM member WHERE project_id='{$_project_id}' AND status&1=0 GROUP BY business_group ORDER BY business_group";
		$rlt = mysql_query($q_str, $db_link_master);
		$bg_ratio = array();
		while ($g_s = mysql_fetch_assoc($rlt)) {
			$key = $g_s[business_group];
			$bg_ratio[$key][business_group] = $g_s[business_group];
			$bg_ratio[$key][all] = $g_s[cnt];
		}

		$q_str = "SELECT COUNT(*) AS cnt, business_group FROM member WHERE project_id='{$_project_id}' AND status&1=0 AND status&2!=0 GROUP BY business_group ORDER BY business_group";
		$rlt = mysql_query($q_str, $db_link_master);
		while ($g_s = mysql_fetch_assoc($rlt)) {
			$key = $g_s[business_group];
			$bg_ratio[$key][business_group] = $g_s[business_group];
			$bg_ratio[$key][here] = $g_s[cnt];
		}

		foreach ($bg_ratio AS $kk=>$vv) {
			$ratio = 0;
			if ($vv[all]) {
				$ratio = round($vv[here] * 100 / $vv[all]);
			} else {
				$ratio = 'NA';
			}
			$bg_ratio[$kk][ratio] = $ratio;
		}

		$op[print_time] = date("Y-m-d H:i", time());
		$prize_obj->CFG[DB_COLS_SORT] = "id";
		$op[prize_list] = $prize_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id], "sr_not_deleted"=>1));
		require_once _DIR_LIB_DBCFG . 'config.member.php';
		$member_obj->CFG[DB_COLS_SORT] = "business_group";
		$member_obj->CFG[DB_COLS_GROUP] = " business_group ";
		$op[datas] = $member_obj->db_browse("LIST_ALL",  array("sr_project_id"=>$ProjectInfo[id], "sr_not_deleted"=>1));

		if(count($op[datas][pds])){
			$tmp_argv = array();
			$tmp_argv[sr_project_id] = $ProjectInfo[id];
			$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_STATISTIC];
			$cm_obj->CFG[DB_COLS_SORT] = "PRZ.id";
			$cm_obj->CFG[DB_COLS_GROUP] = " prize_id ";
			//echo $cm_obj->CFG[BROWSE_SQL_TITLE_STATISTIC];
			foreach($op[datas][pds] as $key=>$val){
				//foreach()
				$tmp_argv[sr_business_group] = $val[business_group];
				$tmp_prize_statistc = $cm_obj->db_browse("LIST_ALL", $tmp_argv);

				#2008.01.31. Gilbert.
				# 出席人數
				$op[datas][pds][$key][here] = $bg_ratio[$val[business_group]][here];
				# 出席率
				#$op[datas][pds][$key][bg_ratio] = $bg_ratio[$val[business_group]][ratio];

				# 出席總人數
				$op[here_all] += $bg_ratio[$val[business_group]][here];

				foreach($op[prize_list][pds] as $key2=>$val2){
					$op[datas][pds][$key][prize_statistic][$key2][cnt] = 0;
					foreach($tmp_prize_statistc[pds] as $val3){
						if($val3[prize_id] == $val2[id]){
							$op[datas][pds][$key][prize_statistic][$key2][cnt] = $val3[cnt];
							break;
						}
					}
				}
			}
		}
		unset($tmp_argv[sr_business_group]);
		$tmp_prize_statistc = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
		$tmp_data = array();
		$tmp_data[business_group] = "總計";

		foreach($op[prize_list][pds] as $key2=>$val2){
			$tmp_data[prize_statistic][$key2][cnt] = 0;
			foreach($tmp_prize_statistc[pds] as $val3){
				if($val3[prize_id] == $val2[id]){
					$tmp_data[prize_statistic][$key2][cnt] = $val3[cnt];
					break;
				}
			}
		}

		$op[datas][pds][] = $tmp_data;

		$layout->display($cm_obj->CFG[LAYOUT][strtoupper($action)], $op);
		break;
		


	/**
	 * 產生跑馬燈字幕檔
	 * @param type string 格式: 1D 一行到底、2D 一筆一行
	 */
	case 'export_marquee':
		$type = strtoupper($_REQUEST['type']);

		$prize_obj->CFG[DB_COLS_SORT] = "no, id";
		$prize_list = $prize_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id], "sr_id"=>$RQT[sr_prize_id], "sr_not_deleted"=>1 )) ;
		
		$prize_id = $prize_list['pds'][0]['id'];
		$prize_name = $prize_list['pds'][0]['prize_name'];

		$cm_obj->CFG[DB_COLS_SORT] = "MBR.business_group, MBR.member_code";
		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_PRINT];
		$cm_obj->CFG[ROW_PER_PAGE] = 99999;
		$tmp_argv = array();
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_prize_id] = $prize_id;
		$prize_list_result = $cm_obj->db_browse("LIST_ALL", $tmp_argv);

		header("Content-type: application/text");
		header("Content-Disposition: attachment; filename=ScrollingText.txt");
		
		if ($type == '1D') {
			foreach ($prize_list_result['pds'] AS $vv) {
				echo sprintf("%s/%s/%s的眷屬%s    ", $vv['business_group'], $vv['member_code'], $vv['name'], $vv['family_name'] );
			}
		}
		else {
			foreach ($prize_list_result['pds'] AS $vv) {
				echo sprintf("%s/%s/%s的眷屬l%s   ", $vv['business_group'],  $vv['member_code'], $vv['name'] , $vv['family_name']) . "\r\n";
			}
		}
		exit;
		break;



	#########################
	#	@ 匯出得獎名單統計
	#########################
	case 'group_statistic_print_ex':

		// 各事業群出席率 2008.01.31. Gilbert.
		$q_str = "SELECT COUNT(*) AS cnt, business_group FROM member WHERE project_id='{$_project_id}' AND status&1=0 GROUP BY business_group ORDER BY business_group";
		$rlt = mysql_query($q_str, $db_link_master);
		$bg_ratio = array();
		while ($g_s = mysql_fetch_assoc($rlt)) {
			$key = $g_s[business_group];
			$bg_ratio[$key][business_group] = $g_s[business_group];
			$bg_ratio[$key][all] = $g_s[cnt];
		}

		$q_str = "SELECT COUNT(*) AS cnt, business_group FROM member WHERE project_id='{$_project_id}' AND status&1=0 AND status&2!=0 GROUP BY business_group ORDER BY business_group";
		$rlt = mysql_query($q_str, $db_link_master);
		while ($g_s = mysql_fetch_assoc($rlt)) {
			$key = $g_s[business_group];
			$bg_ratio[$key][business_group] = $g_s[business_group];
			$bg_ratio[$key][here] = $g_s[cnt];
		}

		foreach ($bg_ratio AS $kk=>$vv) {
			$ratio = 0;
			if ($vv[all]) {
				$ratio = round($vv[here] * 100 / $vv[all]);
			} else {
				$ratio = 'NA';
			}
			$bg_ratio[$kk][ratio] = $ratio;
		}

		$op[print_time] = date("Y-m-d H:i", time());
		$prize_obj->CFG[DB_COLS_SORT] = "id";
		$op[prize_list] = $prize_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id], "sr_not_deleted"=>1));
		require_once _DIR_LIB_DBCFG . 'config.member.php';
		$member_obj->CFG[DB_COLS_SORT] = "business_group";
		$member_obj->CFG[DB_COLS_GROUP] = " business_group ";
		$op[datas] = $member_obj->db_browse("LIST_ALL",  array("sr_project_id"=>$ProjectInfo[id], "sr_not_deleted"=>1));

		if(count($op[datas][pds])){
			$tmp_argv = array();
			$tmp_argv[sr_project_id] = $ProjectInfo[id];
			$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_STATISTIC];
			$cm_obj->CFG[DB_COLS_SORT] = "PRZ.id";
			$cm_obj->CFG[DB_COLS_GROUP] = " prize_id ";
			//echo $cm_obj->CFG[BROWSE_SQL_TITLE_STATISTIC];
			foreach($op[datas][pds] as $key=>$val){
				//foreach()
				$tmp_argv[sr_business_group] = $val[business_group];
				$tmp_prize_statistc = $cm_obj->db_browse("LIST_ALL", $tmp_argv);

				#2008.01.31. Gilbert.
				# 出席人數
				$op[datas][pds][$key][here] = $bg_ratio[$val[business_group]][here];
				# 出席率
				#$op[datas][pds][$key][bg_ratio] = $bg_ratio[$val[business_group]][ratio];

				# 出席總人數
				$op[here_all] += $bg_ratio[$val[business_group]][here];

				foreach($op[prize_list][pds] as $key2=>$val2){
					$op[datas][pds][$key][prize_statistic][$key2][cnt] = 0;
					foreach($tmp_prize_statistc[pds] as $val3){
						if($val3[prize_id] == $val2[id]){
							$op[datas][pds][$key][prize_statistic][$key2][cnt] = $val3[cnt];
							break;
						}
					}
				}
			}
		}
		unset($tmp_argv[sr_business_group]);
		$tmp_prize_statistc = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
		$tmp_data = array();
		$tmp_data[business_group] = "總計";

		foreach($op[prize_list][pds] as $key2=>$val2){
			$tmp_data[prize_statistic][$key2][cnt] = 0;
			foreach($tmp_prize_statistc[pds] as $val3){
				if($val3[prize_id] == $val2[id]){
					$tmp_data[prize_statistic][$key2][cnt] = $val3[cnt];
					break;
				}
			}
		}

		$op[datas][pds][] = $tmp_data;

		$layout->display($cm_obj->CFG[LAYOUT][strtoupper($action)], $op);
		ob_start();
		// 產生CSV檔
		if (headers_sent()) {
			echo "error!";
			exit;
		}
		header("Content-Type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=prize_list1.xls");
		header('Pragma: no-cache');
		header('Expires: 0');
		echo $content;
		ob_flush();
		break;
		break;



	#########################
	#	@ 列印得獎名單
	#########################
	case 'print_list_A3':
	case 'print_list_A4':
	case 'print_num':
		$op[print_time] = date("Y-m-d H:i", time());
		require_once _DIR_LIB_DBCFG. 'config.class.php';
		$class_obj->CFG[DB_COLS_SORT] = "id";
		$op[class_list] = $class_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id], "sr_id"=>$RQT[sr_class_id]));

		$prize_obj->CFG[DB_COLS_SORT] = "no, id";
		$prize_list = $prize_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id], "sr_id"=>$RQT[sr_prize_id], "sr_not_deleted"=>1 )) ;
		
		//修改列印排序 by Wun-Hao Liu @ 2012/01/16
		//$cm_obj->CFG[DB_COLS_SORT] = "MBR.business_group,MBR.member_code, PRZLST.id";
		$cm_obj->CFG[DB_COLS_SORT] = "MBR.member_code, MBR.business_group, PRZLST.id";
		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_PRINT];
		$cm_obj->CFG[ROW_PER_PAGE] = 99999;

		if (count($prize_list[pds])>0) { //count($op[class_list][pds])>0 && 
			//foreach($op[class_list][pds] as $key=>$val){
				foreach($prize_list[pds] as $key2=>$val2){
					$tmp_argv = array();
					$tmp_argv[sr_project_id] = $ProjectInfo[id];
					$tmp_argv[sr_not_deleted] = 1;
					//$tmp_argv[sr_class_id] =$val[id];
					$tmp_argv[sr_prize_id] = $val2[id];
					$op[class_list][pds]["010"][prize] = $prize_list;
					$prize_list_result = $cm_obj->db_browse("LIST_ALL", $tmp_argv);

					if(count($prize_list_result[pds])){
						$op[class_list][pds]["010"][prize][pds][$key2][prize_list] = $prize_list_result;
						//echo "<pre>";print_r($op[class_list][pds][$key][prize][pds][$key2]);
					}
					else{
						//echo "<pre>";print_r($op[class_list][pds][$key][prize][pds][$key2]);
						unset($op[class_list][pds]["010"][prize][pds][$key2]);
					}
				}
			//}
		}
//echo "<pre>";var_dump($op[class_list][pds]["010"]);exit;
		$layout->display($cm_obj->CFG[LAYOUT][strtoupper($action)], $op);
		break;
		
		
	#########################
	#	@ 列印得獎名單 bak yao. 2015.02.13.
	#########################
	case 'print_list2_A3':
	case 'print_list2_A4':
	case 'print2_num':
		$op[print_time] = date("Y-m-d H:i", time());
		require_once _DIR_LIB_DBCFG. 'config.class.php';
		$class_obj->CFG[DB_COLS_SORT] = "id";
		$op[class_list] = $class_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id], "sr_id"=>$RQT[sr_class_id]));

		$prize_obj->CFG[DB_COLS_SORT] = "no, id";
		$prize_list = $prize_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id], "sr_id"=>$RQT[sr_prize_id], "sr_not_deleted"=>1 )) ;
		
		//修改列印排序 by Wun-Hao Liu @ 2012/01/16
		//$cm_obj->CFG[DB_COLS_SORT] = "MBR.business_group,MBR.member_code, PRZLST.id";
		$cm_obj->CFG[DB_COLS_SORT] = "MBR.member_code, MBR.business_group, PRZLST.id";
		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_PRINT];
		$cm_obj->CFG[ROW_PER_PAGE] = 99999;

		if (count($prize_list[pds])>0) {
			//foreach($op[class_list][pds] as $key=>$val){
				foreach($prize_list[pds] as $key2=>$val2){
					$tmp_argv = array();
					$tmp_argv[sr_project_id] = $ProjectInfo[id];
					$tmp_argv[sr_not_deleted] = 1;
					//$tmp_argv[sr_class_id] =$val[id];
					$tmp_argv[sr_prize_id] = $val2[id];
					$op[class_list][pds][$key][prize] = $prize_list;
					$prize_list_result = $cm_obj->db_browse("LIST_ALL", $tmp_argv);

					if(count($prize_list_result[pds])){
						$op[class_list][pds][$key][prize][pds][$key2][prize_list] = $prize_list_result;
						//echo "<pre>";print_r($op[class_list][pds][$key][prize][pds][$key2]);
					}
					else{
						//echo "<pre>";print_r($op[class_list][pds][$key][prize][pds][$key2]);
						unset($op[class_list][pds][$key][prize][pds][$key2]);
					}
				}
			//}
		}

		$layout->display($cm_obj->CFG[LAYOUT][strtoupper($action)], $op);
		break;



	#########################
	#	@ 列印得獎名單
	#########################
	case 'print_seq_no':

		$op[print_time] = date("Y-m-d H:i", time());

		require_once _DIR_LIB_DBCFG. 'config.class.php';

		$class_obj->CFG[DB_COLS_SORT] = "id";
		$op[class_list] = $class_obj->db_browse("LIST_ALL", array("sr_project_id"=>$__project_id, "sr_id"=>$RQT[sr_class_id]));

		$prize_obj->CFG[DB_COLS_SORT] = "no, id";
		$prize_list = $prize_obj->db_browse("LIST_ALL", array("sr_project_id"=>$__project_id, "sr_id"=>$RQT[sr_prize_id], "sr_not_deleted"=>1 )) ;

		$cm_obj->CFG[DB_COLS_SORT] = "PRZLST.seq_no DESC, MBR.business_group";
		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_PRINT];
		$cm_obj->CFG[ROW_PER_PAGE] = 99999;

		$cnt = 0;
		if (count($op[class_list][pds])>0 && count($prize_list[pds])>0) {
			foreach($op[class_list][pds] AS $key=>$val){
				foreach($prize_list[pds] AS $key2=>$val2){
					$tmp_argv = array();
					$tmp_argv[sr_project_id] = $ProjectInfo[id];
					$tmp_argv[sr_not_deleted] = 1;
					$tmp_argv[sr_class_id] =$val[id];
					$tmp_argv[sr_prize_id] = $val2[id];
					$op[class_list][pds][$key][prize] = $prize_list;
					$prize_list_result = $cm_obj->db_browse("LIST_ALL", $tmp_argv);

					foreach ($prize_list_result[pds] AS $kk=>$vv) {
						$business_group = $vv[business_group];
						$bs_no = mb_strlen($business_group, 'utf8');
						if ($bs_no > 6) {
							$prize_list_result[pds][$kk][business_group] = '<span style="font-size:65px;">' . $business_group . '</span>';
						}
					}

					if (count($prize_list_result[pds])) {
						$op[class_list][pds][$key][prize][pds][$key2][prize_list] = $prize_list_result;
						//echo "<pre>";print_r($op[class_list][pds][$key][prize][pds][$key2]);

						$cnt += count($prize_list_result[pds]);
					}
					else {
						//echo "<pre>";print_r($op[class_list][pds][$key][prize][pds][$key2]);
						unset($op[class_list][pds][$key][prize][pds][$key2]);
					}
				}
			}
		}
		$op[total_pages] = $cnt;

		$layout->display($cm_obj->CFG[LAYOUT][strtoupper($action)], $op);
		break;

}


function send_sms($prize_list_id, $prize_id, $mobile, $lottery_no, $winner){
	$SysConfig = $GLOBALS["SysConfig"];
	$ProjectInfo = $GLOBALS["ProjectInfo"];
	$return = $GLOBALS["return"];
	$sys_cfg_obj = $GLOBALS["sys_cfg_obj"];
	$cm_obj = $GLOBALS["cm_obj"];
	$prize_obj = $GLOBALS["prize_obj"];
	$sms_log_obj = $GLOBALS['sms_log_obj'];

	$_sms_server = 'http://smexpress.mitake.com.tw:9600/SmSendGet.asp';

	// 檢查額度
	if(($SysConfig[sms_quota] - $SysConfig[sms_spend]) < $SysConfig[sms_per_price]){
		gotoUrl($return, "簡訊額度已用完!!", 3);
	}

	// 發送簡訊

	// 手機號碼
	$mobile = trim(str_replace(')', '', str_replace('(', '', str_replace('-', '', $mobile))));
	$pattern = '/^09[0-9]{8}$/';
	if (!preg_match($pattern, $mobile)) {
		gotoUrl($return, "手機號碼格式錯誤！請輸入「09」開頭之十位數字。!!", 3);
		exit;
	}

	// 簡訊內容
	$prize = $prize_obj->get_db_detail($prize_id);
	$message = str_replace("[name]",$winner,$ProjectInfo[cong_msg]);
	$message = str_replace("[prize]",$prize[prize_name],$message);
	//新增獎項描述 prize_desc by Wun-Hao Liu @ 2012/01/20
	$message = str_replace("[prize_desc]",$prize[prize_desc],$message);
	$message = str_replace("[project]",$ProjectInfo[name],$message);
	$message = str_replace("[lottery_no]",$lottery_no,$message);

require_once _DIR_LIB_FUNCTION . 'big5_func/big5_func.inc';
$message = big5_utf8_decode($message);

	$message = rawurlencode($message);




	// 簡訊發送連結
	$url = $_sms_server .'?' . 'username=' . $SysConfig[sms_number] . '&password=' . $SysConfig[sms_pass];
	$url .= '&DestName=' . $lottery_no . '&dstaddr=' . $mobile . '&smbody=' . $message;

	$lines = file($url);
	$sms_price =0;
	if ($lines === false) {
		$status_msg = '簡訊發送失敗！無法連線至簡訊伺服器。';
	}
	else{
		$memo = $url;
		$ret_msg =  join('', $lines);
		$ret_msgid = substr($ret_msg, (strpos($ret_msg, '=') + 1), 10);
		$ret_code = substr($ret_msg, (strpos($ret_msg, '=', 20) + 1), 1);

		$is_send = 0;
		// 依據 statuscode 顯示訊息及後續處理
		switch ($ret_code) {
			case '*':
				$status_msg = '三竹資訊簡訊系統發生錯誤，請聯絡三竹資訊窗口人員。';
				break;
			case 'a':
			case 'b':
				$status_msg = '簡訊發送功能暫時停止服務，請稍後再試。';
				break;
			case 'c':
				$status_msg = '未指定簡訊扣款帳號，請與普萊斯人員聯繫。';
				break;
			case 'd':
				$status_msg = '未指定簡訊帳號密碼，請與普萊斯人員聯繫。';
				break;
			case 'e':
				$status_msg = '簡訊扣款帳號密碼錯誤，請與普萊斯人員聯繫。';
				break;
			case 'f':
				$status_msg = '簡訊帳號已過期，請聯絡三竹資訊窗口人員。';
				break;
			case 'h':
				$status_msg = '簡訊帳號已被停用，請聯絡三竹資訊窗口人員。';
				break;
			case 'k':
				$status_msg = '無效的連線位址，請與普萊斯人員聯繫。';
				break;
			case 'm':
				$status_msg = '必須變更密碼，在變更密碼前，無法使用簡訊發送服務，請聯絡三竹資訊窗口人員。';
				break;
			case 'n':
				$status_msg = '密碼已逾期，在變更密碼前，無法使用簡訊發送服務，請聯絡三竹資訊窗口人員。';
				break;
			case 'p':
				$status_msg = '沒有權限使用外部 http 程式，請與普萊斯人員聯繫。';
				break;
			case 'r':
				$status_msg = '簡訊發送系統暫停服務，請稍後再試。';
				break;
			case 's':
				$status_msg = '帳務處理失敗，無法發送簡訊，請聯絡三竹資訊窗口人員。';
				break;
			case 't':
				$status_msg = '簡訊已過期，請重新輸入。';
				break;
			case 'u':
				$status_msg = '簡訊內容不得為空白，請重新輸入。';
				break;
			case 'v':
				$status_msg = '無效的手機號碼，請重新輸入。';
				break;
			case '0':
				$status_msg = '預約傳送中。';
				$sms_price = $SysConfig[sms_per_price];
				$is_send = 1;
				break;
			case '1':
			case '2':
			case '3':
			case '4':
				$status_msg = '簡訊發送完成。';
				$sms_price = $SysConfig[sms_per_price];
				$is_send = 1;
				break;
			case '5':
				$status_msg = '簡訊內容有錯誤，請重新輸入。';
				break;
			case '6':
				$status_msg = '門號有錯誤，請重新輸入。';
				break;
			case '7':
				$status_msg = '簡訊已停用，請聯絡三竹資訊窗口人員。';
				break;
			case '8':
				$status_msg = '逾時無送達，請重新發送。';
				break;
			case '9':
				$status_msg = '預約已取消，請重新發送。';
				break;
		}
	}

	// 增加累計金額
	if ($sms_price>0) {
		// 更新 sys_config 及 $SysConfig;
		$tmp_argv = array();
		$tmp_argv[id] = 1;
		$tmp_argv[sms_spend] = $SysConfig[sms_spend] + $SysConfig[sms_per_price];
		$sys_cfg_obj->db_modify($tmp_argv);
		$GLOBALS["SysConfig"][sms_spend] = $SysConfig[sms_spend] + $SysConfig[sms_per_price];

	}

	// 寫入簡訊發送紀錄
	$tmp_argv = array();
	$tmp_argv[mobile] = $mobile;
	$tmp_argv[message] = $message;
	$tmp_argv[price] = $sms_price;
	$tmp_argv[lottery_no] = $lottery_no;
	$tmp_argv[project_id] = $ProjectInfo[id];
	$tmp_argv[prize_list_id] = $prize_list_id;
	$tmp_argv[status_msg] = $status_msg;

	$tmp_argv[msg_type] = 1;
	//$tmp_argv[MessageID] = ($ret_code==0) ? trim($ret_msg) : '';
	$tmp_argv[MessageID] = $ret_msgid;
	$tmp_argv[ret_code] = $ret_code;
	$tmp_argv[ret_description] = $ret_msg;
	$tmp_argv[memo] = $memo;

	if ($is_send) {
		$tmp_argv[status_ary][IS_SEND] = 1;
	}
	$tmp_argv[create_time] = date('Y-m-d H:i:s');
	$tmp_argv[create_user] = $_SESSION['UserInfo']['account'];

	$sms_log_obj->db_add($tmp_argv) OR gotoUrl($return, '發送記錄無法寫入資料庫！!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0034'.join($sms_log_obj->msg->get(2)));

	$tmp_argv = array();
	$tmp_argv[id] = $prize_list_id;
	$tmp_argv[sms_status_msg] = $status_msg;
	if ($is_send) {
		$tmp_argv[status_ary][IS_NOTICED] = 1;
	}
	$cm_obj->db_modify($tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PRIZE_LIST_0035', $cm_obj->msg->get(2));

}


?>
