<?php
/**
 *	程式名稱：	獎項管理
 *	檔案名稱：	module.prize.php
 *	版　　本：	1.0.0.
 *	作　　者：	Jacky Jou<starjou@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2006.12.22.
 *	更新日期：
 *	說　　明：
 */


// ===== 初始化物件
require_once _DIR_LIB_DBCFG . 'config.prize.php';
require_once _DIR_LIB_DBCFG . 'config.prize_quota.php';
require_once _DIR_LIB_DBCFG . 'config.class.php';

require_once _DIR_LIB_FUNCTION . 'JSescape.php';
require_once _DIR_LIB_CLASS . 'class.Javascript.php';


// ===== 模組化參數設定
$cm_title = '獎項';
$cm_func = 'prize';
$cm_func2 = 'PRIZE';
$cm_obj = $prize_obj;
$op[cm_func] = $cm_func;
$op[cm_title] = $cm_title;
$op[cm_url] = $SELF;

# 除錯設定
$op[cm_debug] = true;
#$layout->smarty->debugging = true;
$layout->smarty->clear_compiled_tpl();

$layout->assign($op);


// ===== 常用變數
$return = $SELF . '?PHP_dType=' . $cm_func;
$action = $_REQUEST['PHP_action'];

// * 圖檔上傳所需設定
$cm_image_dir = _DIR_UPLOAD . 'prize_img/';			// 圖檔存放資料夾
$cm_image_url = _URL_UPLOAD . 'prize_img/';			// 圖檔資料夾URL

$class_obj->CFG[DB_COLS_SORT] = "id";
$class_list = $class_obj->db_browse('LIST_ALL', array('sr_not_deleted'=>1, 'sr_project_id'=>$ProjectInfo[id]));
$op[class_list] = $class_list[pds];



$layout->assign($op);

// ===== 主程式
switch($action){
#########################
#	@ 主選單
#########################
	default:
	case 'main':
		$layout->display($cm_obj->CFG[LAYOUT]['MAIN'], $op);
		break;

#########################
#	@ 資料瀏覽及搜尋
#########################
	case 'browse':

		$cm_obj->CFG[ROW_PER_PAGE] = 30;
		if ($RQT[PHP_sr_page])
			$RQT[PHP_sr_startno] = ($RQT[PHP_sr_page] - 1) * $cm_obj->CFG[ROW_PER_PAGE];

		// ===== 設定排序
		$cm_obj->CFG[DB_COLS_SORT] = "no, id";
		// ===== 執行搜尋
		$RQT[sr_not_deleted] = 1;
		$RQT[sr_project_id] = $ProjectInfo[id];
		//echo "<pre>"; print_r($RQT);

		//$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_EXPORT];
		//$cm_obj->debug=true;
		$datas = $cm_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $cm_obj->msg->get(2));
		//echo "<pre>"; print_r($datas);
		foreach($datas[pds] as $key=>$val){
			$tmp_argv = array();
			$tmp_argv[sr_prize_id] = $val[id];
			$tmp_argv[sr_not_deleted] = 1;
			$przqt_obj->CFG[DB_COLS_SORT] = "id";
			$quota_datas = $przqt_obj->db_browse('LIST_ALL',$tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0033', $przqt_obj->msg->get(2));
			foreach($quota_datas[pds] as $val2){
				$datas[pds][$key][quota][$val2[class_id]] = $val2;
			}
		}
		//echo "<pre>"; print_r($datas);
		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][BROWSE], $datas);
		break;

#########################
#	@ 新增
#########################
	case 'add':
		// =====初始化資料
		$op=array();

		// * 讀取儲存失敗的暫存資料
		if($data=$GSID[$cm_func2."_ADD_BUF"]):
			unset($GSID[$cm_func2."_ADD_BUF"]);
		else:
			$data=array();
		endif;
		$op[data]=$data;

		$op[data][quota] = $class_list[pds];

		foreach($op[data][quota] as $key=>$val){
			$op[data][quota][$key][quota] = $data[quota][$val[id]];
		}


		// ===== 顯示畫面
		$op[cm_action]="submit_add";
		$op[onloadJavascript]="document.form1.elements['input[prize_name]'].focus();";

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][ADD], $op);
		break;

#########################
#	@ 新增儲存
#########################
	case 'submit_add':

		// ===== 輸入資料處理
		$tmp_argv = $RQT[input];
		$tmp_argv[status_ary][IS_QUOTA]=$tmp_argv[status_ary][IS_QUOTA]?1:0;
		$tmp_argv[status_ary][IS_QUALIFICATION]=$tmp_argv[status_ary][IS_QUALIFICATION]?1:0;
		$tmp_argv[status_ary][IS_NEED_CONFIRM]=$tmp_argv[status_ary][IS_NEED_CONFIRM]?1:0;
		$tmp_argv[status_ary][IS_HIDDEN]=$tmp_argv[status_ary][IS_HIDDEN]?1:0;
		$tmp_argv[status_ary][IS_SPECIAL]=$tmp_argv[status_ary][IS_SPECIAL]?1:0;
		$tmp_argv[status_ary][IS_STAR1]=$tmp_argv[status_ary][IS_STAR1]?1:0;
		$tmp_argv[status_ary][IS_STAR2]=$tmp_argv[status_ary][IS_STAR2]?1:0;
		$tmp_argv[status_ary][IS_STAR3]=$tmp_argv[status_ary][IS_STAR3]?1:0;
		$tmp_argv[status_ary][IS_STAR4]=$tmp_argv[status_ary][IS_STAR4]?1:0;
		$tmp_argv[status_ary][IS_DRAW_ONCE]=$tmp_argv[status_ary][IS_DRAW_ONCE]?1:0;
		$tmp_argv[status_ary][IS_LAST_3]=$tmp_argv[status_ary][IS_LAST_3]?1:0;
		$tmp_argv[project_id] = $ProjectInfo[id];

		//四星彩獎項不得重覆
		if($tmp_argv[status_ary][IS_STAR1]){
			$tmp_argv1 = array();
			$tmp_argv1[sr_not_deleted] = 1;
			$tmp_argv1[sr_star1] = 1;
			$tmp_argv1[sr_project_id] = $ProjectInfo[id];

			$star_prize = $cm_obj->db_browse("LIST_ALL", $tmp_argv1);
			if($star_prize[pds][0]){
				gotoUrl($return, "四星彩頭獎已存在，無法新增!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("四星彩頭獎已存在，無法新增!"));
			}
		}
		if($tmp_argv[status_ary][IS_STAR2]){
			$tmp_argv1 = array();
			$tmp_argv1[sr_not_deleted] = 1;
			$tmp_argv1[sr_star2] = 1;
			$tmp_argv1[sr_project_id] = $ProjectInfo[id];

			$star_prize = $cm_obj->db_browse("LIST_ALL", $tmp_argv1);
			if($star_prize[pds][0]){
				gotoUrl($return, "四星彩貳獎已存在，無法新增!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("四星彩貳獎已存在，無法新增!"));
			}
		}
		if($tmp_argv[status_ary][IS_STAR3]){
			$tmp_argv1 = array();
			$tmp_argv1[sr_not_deleted] = 1;
			$tmp_argv1[sr_star3] = 1;
			$tmp_argv1[sr_project_id] = $ProjectInfo[id];

			$star_prize = $cm_obj->db_browse("LIST_ALL", $tmp_argv1);
			if($star_prize[pds][0]){
				gotoUrl($return, "四星彩參獎已存在，無法新增!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("四星彩參獎已存在，無法新增!"));
			}
		}
		if($tmp_argv[status_ary][IS_STAR4]){
			$tmp_argv1 = array();
			$tmp_argv1[sr_not_deleted] = 1;
			$tmp_argv1[sr_star4] = 1;
			$tmp_argv1[sr_project_id] = $ProjectInfo[id];

			$star_prize = $cm_obj->db_browse("LIST_ALL", $tmp_argv1);
			if($star_prize[pds][0]){
				gotoUrl($return, "四星彩肆獎已存在，無法新增!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("四星彩肆獎已存在，無法新增!"));
			}
		}


		// 有配額設定時重新計量數量
		if($tmp_argv[status_ary][IS_QUOTA]){
			$qty = 0;
			foreach($tmp_argv[quota] as $val1){
				$qty += $val1;
			}
			$tmp_argv[qty] = $qty;
		}

		// * 建檔資訊
		$tmp_argv[create_time]=date("Y-m-d H:i:s");
		$tmp_argv[create_user]=$GSID[UserInfo][account];
		$GSID[$cm_func2."_ADD_BUF"]=$tmp_argv;
//		echo "<pre>"; print_r($tmp_argv); exit;

		// 無配額四星彩頭獎獎項數目不得大於 9
		if($tmp_argv[status_ary][IS_STAR1] && !$tmp_argv[status_ary][IS_QUOTA] && $tmp_argv[qty] > 9){
				$tmp_argv[qty] = 9;
		}
		$tmp_argv[last_3] =$tmp_argv[last_number][num_len];
        //20160324 add by
        $tmp_argv[num_amount] = $tmp_argv[last_number][num_set];

        $tmp_argv[num_amount] = $tmp_argv[last_number][num_set];
        if($tmp_argv[status_ary][IS_LAST_3] || $tmp_argv[status_ary][IS_DRAW_ONCE]) {
             if (!empty($tmp_argv[num_amount])) {
                 $tmp_argv[qty] = $tmp_argv[num_amount];
                  }
          }
		#2008.01.21.
		$tmp_argv[seq_now] = $tmp_argv[seq_start];

		// ===== 資料庫存取
		$cm_obj->db_add($tmp_argv) OR gotoUrl($return.'&PHP_action=add', "新增{$cm_title}進資料庫時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0002', $cm_obj->msg->get(2));
		$new_id=$cm_obj->get_new_id();

		// 存入配額
		foreach($tmp_argv[quota] as $key=>$val){
			$tmp_argv1 = array();
			$tmp_argv1[prize_id] = $new_id;
			$tmp_argv1[class_id] = $key;
			if($tmp_argv[status_ary][IS_QUOTA]){	// 四星彩頭彩各配額不得大於零，無配額設定各配額設為 0
				if($tmp_argv[status_ary][IS_STAR1] && $val > 9){
					$tmp_argv1[quota] = 9;
				}
				else{
					$tmp_argv1[quota] = $val;
				}
			}
			else{
				$tmp_argv1[quota] = 0;
			}
			$tmp_argv1[create_time]=date("Y-m-d H:i:s");
			$tmp_argv1[create_user]=$GSID[UserInfo][account];
			$przqt_obj->db_add($tmp_argv1) OR gotoUrl($return.'&PHP_action=add', "新增{$cm_title}進資料庫時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0002',$przqt_obj->msg-get(2));
		}

		// 上傳圖檔
		if ($_FILES[upload_file][tmp_name]){
			$image_name = $new_id.".".fileext($_FILES[upload_file][name]);
			copy ($_FILES[upload_file][tmp_name], $cm_image_dir.$image_name);
			$tmp_argv = array();
			$tmp_argv[id] = $new_id;
			$tmp_argv[image] = $cm_image_url.$image_name;
			$cm_obj->db_modify($tmp_argv);
		}

		// ===== 回傳結果
		unset($GSID[$cm_func2."_ADD_BUF"]);
		if(!$cm_obj->msg->length()):
			gotoUrl($return."&PHP_action=view&PHP_id={$new_id}", "{$cm_title}資料新增成功!", 2);
		else:
			$tmp_msg=array("新增{$cm_title}資料時發生錯誤!");
			$tmp_msg=array_merge($tmp_msg, $cm_obj->msg->get(2));
			gotoUrl($return."&PHP_action=view&PHP_id={$new_id}", $tmp_msg, 5, array(), _ER_USER_NOTICE, 'ER_PROJECT_0013', $tmp_msg);
		endif;

		break;

#########################
#	@ 修改
#########################
	case 'modify':
		// ===== 輸入資料確認
		$RQT[PHP_id] OR gotoUrl($return, "無法讀取{$cm_title}資料!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("無法讀取{$cm_title}資料!", "使用者未指定資料編號!"));

		// ===== 資料讀取
		// * Case1: 儲存失敗時的暫存資料優先
		$data=$GSID[$cm_func2.'_MODIFY_BUF'];

		// * Case2: 資料庫存取
		if(!$data):
			$data = $cm_obj->get_db_detail($RQT[PHP_id]) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0004', $cm_obj->msg->get(2));
		else:
			unset($GSID[$cm_func2."_MODIFY_BUF"]);
		endif;

		// ===== 資料存取狀態確認
		if($data[status_ary][IS_DELETED]):
			gotoUrl($return, array("{$cm_title}資料存取失敗!", "原因：您所指定的{$cm_title}資料已經刪除!!"), 5, array(), _ER_USER_NOTICE, 'ER_PROJECT_0005', array("{$cm_title}資料存取失敗", "原因：使用者所指定的資料已經刪除!"));
		endif;

		// ===== 顯示頁面
		$op[data] = $data;
		$op[cm_action]="submit_modify";

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_prize_id] = $op[data][id];
		$quota_datas = $przqt_obj->db_browse('LIST_ALL',$tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $przqt_obj->msg->get(2));
		$op[data][quota] = $op[class_list];

		if($data[quota]){
			foreach($op[data][quota] as $key=>$val){
				$op[data][quota][$key][quota] = $data[quota][$val[id]];
			}
		}
		else{
			foreach($quota_datas[pds] as $val){
				$tmp_quota[$val[class_id]] = $val[quota];
			}
			foreach($op[data][quota] as $key=>$val){
				$op[data][quota][$key][quota] = $tmp_quota[$val[id]];
			}
		}

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][MODIFY], $op);
		break;

#########################
#	@ 修改儲存
#########################
	case 'submit_modify':
		// ===== 輸入資料處理
		$tmp_argv = array();
		$tmp_argv = $RQT[input];
		$tmp_argv[status_ary][IS_QUOTA]=$tmp_argv[status_ary][IS_QUOTA]?1:0;
		$tmp_argv[status_ary][IS_QUALIFICATION]=$tmp_argv[status_ary][IS_QUALIFICATION]?1:0;
		$tmp_argv[status_ary][IS_NEED_CONFIRM]=$tmp_argv[status_ary][IS_NEED_CONFIRM]?1:0;
		$tmp_argv[status_ary][IS_HIDDEN]=$tmp_argv[status_ary][IS_HIDDEN]?1:0;
		$tmp_argv[status_ary][IS_SPECIAL]=$tmp_argv[status_ary][IS_SPECIAL]?1:0;
		$tmp_argv[status_ary][IS_STAR1]=$tmp_argv[status_ary][IS_STAR1]?1:0;
		$tmp_argv[status_ary][IS_STAR2]=$tmp_argv[status_ary][IS_STAR2]?1:0;
		$tmp_argv[status_ary][IS_STAR3]=$tmp_argv[status_ary][IS_STAR3]?1:0;
		$tmp_argv[status_ary][IS_STAR4]=$tmp_argv[status_ary][IS_STAR4]?1:0;
		//$tmp_argv[status_ary][IS_DRAWN]=$tmp_argv[status_ary][IS_DRAWN]?1:0;
		$tmp_argv[status_ary][IS_LAST_3]=$tmp_argv[status_ary][IS_LAST_3]?1:0;
		$tmp_argv[status_ary][IS_DRAW_ONCE]=$tmp_argv[status_ary][IS_DRAW_ONCE]?1:0;
		$tmp_argv[project_id] = $ProjectInfo[id];

           //20160324  by
        $tmp_argv[num_amount] = $tmp_argv[last_number][num_set];
        $tmp_argv[num_amount] = $tmp_argv[last_number][num_set];
        if($tmp_argv[status_ary][IS_LAST_3] || $tmp_argv[status_ary][IS_DRAW_ONCE]) {
            if (!empty($tmp_argv[num_amount])) {
                 $tmp_argv[qty] = $tmp_argv[num_amount];
            }
        }
		$GSID[$cm_func2."_MODIFY_BUF"]=$tmp_argv;

		// * 資料狀態確認
		$data=$cm_obj->get_db_detail($tmp_argv[id]) OR gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", "檢查資料狀態時發生錯誤!", 3, array(), _ER_USER_WARNING, 'ER_PROJECT_0006', $cm_obj->msg->get(2));
		if($data[status_ary][IS_DELETED]):
			gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", array("錯誤! 無法更新{$cm_title}資料!", " 原因, 您所指定的資料已經被刪除!"), 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0007', array("無法更新{$cm_title}資料", "資料已經被刪除!"));
		endif;

		//四星彩獎項不得重覆
		if($tmp_argv[status_ary][IS_STAR1]){
			$tmp_argv1 = array();
			$tmp_argv1[sr_not_deleted] = 1;
			$tmp_argv1[sr_star1] = 1;
			$tmp_argv1[sr_project_id] = $ProjectInfo[id];

			$star_prize = $cm_obj->db_browse("LIST_ALL", $tmp_argv1);
			if(count($star_prize[pds]) && $star_prize[pds][0][id] != $tmp_argv[id]){
				gotoUrl($return, "四星彩頭獎已存在，無法儲存!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("四星彩頭獎已存在，無法新增!"));
			}
		}
		if($tmp_argv[status_ary][IS_STAR2]){
			$tmp_argv1 = array();
			$tmp_argv1[sr_not_deleted] = 1;
			$tmp_argv1[sr_star2] = 1;
			$tmp_argv1[sr_project_id] = $ProjectInfo[id];

			$star_prize = $cm_obj->db_browse("LIST_ALL", $tmp_argv1);
			if(count($star_prize[pds]) && $star_prize[pds][0][id] != $tmp_argv[id]){
				gotoUrl($return, "四星彩貳獎已存在，無法儲存!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("四星彩貳獎已存在，無法新增!"));
			}
		}
		if($tmp_argv[status_ary][IS_STAR3]){
			$tmp_argv1 = array();
			$tmp_argv1[sr_not_deleted] = 1;
			$tmp_argv1[sr_star3] = 1;
			$tmp_argv1[sr_project_id] = $ProjectInfo[id];

			$star_prize = $cm_obj->db_browse("LIST_ALL", $tmp_argv1);
			if(count($star_prize[pds]) && $star_prize[pds][0][id] != $tmp_argv[id]){
				gotoUrl($return, "四星彩參獎已存在，無法儲存!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("四星彩參獎已存在，無法新增!"));
			}
		}
		if($tmp_argv[status_ary][IS_STAR4]){
			$tmp_argv1 = array();
			$tmp_argv1[sr_not_deleted] = 1;
			$tmp_argv1[sr_star4] = 1;
			$tmp_argv1[sr_project_id] = $ProjectInfo[id];

			$star_prize = $cm_obj->db_browse("LIST_ALL", $tmp_argv1);
			if(count($star_prize[pds]) && $star_prize[pds][0][id] != $tmp_argv[id]){
				gotoUrl($return, "四星彩肆獎已存在，無法儲存!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("四星彩肆獎已存在，無法新增!"));
			}
		}
		// * 取得更新記錄
		$tmp_argv=array_merge($tmp_argv, createUpdateLog($data, $GSID[UserInfo][account]));

		// 刪除舊圖檔
		if($RQT[remove_image] || $_FILES[upload_file][tmp_name]){
			unlink($data[image]);
			$tmp_argv[image] = "";
		}
		// 上傳圖檔
		if ($_FILES[upload_file][tmp_name]){
			$image_name = $tmp_argv[id].".".fileext($_FILES[upload_file][name]);
			copy ($_FILES[upload_file][tmp_name], $cm_image_dir.$image_name);
			$tmp_argv[image] = $cm_image_url.$image_name;
		}

		// 有配額設定時重新計算數量
		if($tmp_argv[status_ary][IS_QUOTA]){
			$qty = 0;
			foreach($tmp_argv[quota] as $val1){
				$qty += $val1;
			}
			$tmp_argv[qty] = $qty;
		}

		// 無配額四星彩頭獎獎項數目不得大於 9
		if($tmp_argv[status_ary][IS_STAR1] && empty($tmp_argv[status_ary][IS_QUOTA]) && $tmp_argv[qty] > 9){
				$tmp_argv[qty] = 9;
		}

		#2008.01.21.
		$tmp_argv[seq_now] = $tmp_argv[seq_start];

		$tmp_argv[last_3] =$tmp_argv[last_number][num_len];// JasonSu
		// ===== 資料庫存取
		$flag0 = $cm_obj->db_modify($tmp_argv) OR gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", "儲存{$cm_title}進資料庫時發生錯誤!!", 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0008', $cm_obj->msg->get(2));

		foreach($tmp_argv[quota] as $key=>$val){
			$tmp_argv1 = array();
			$tmp_argv1[sr_prize_id] = $tmp_argv[id];
			$tmp_argv1[sr_class_id] = $key;
			$flag0 = $przqt_obj->db_browse("LIST_ALL", $tmp_argv1);
			if(!$flag0){
				$tmp_msg[] = $przqt_obj->msg->get(2);
			}
			else{
				$tmp_argv2 = array();
				if($tmp_argv[status_ary][IS_QUOTA]){// 四星彩頭彩各配額不得大於零，無配額設定各配額設為 0
					if($tmp_argv[status_ary][IS_STAR1] && $val > 9){
						$tmp_argv2[quota] = 9;
					}
					else{
						$tmp_argv2[quota] = $val;
					}
				}
				else{
					$tmp_argv2[quota] = 0;
				}
				//$tmp_argv2[quota] = $tmp_argv[status_ary][IS_QUOTA]?$val:0;
				if(count($flag0[pds])){
					$tmp_argv2[id] = $flag0[pds][0][id];
					$tmp_argv2[modify_time] = date("Y-m-d H:i:s");
					$tmp_argv2[modify_user]=$GSID[UserInfo][account];
					$flag1 = $przqt_obj->db_modify($tmp_argv2);
				}
				else{
					$tmp_argv2[prize_id] = $tmp_argv[id];
					$tmp_argv2[class_id] = $key;
					$tmp_argv2[create_time] = date("Y-m-d H:i:s");
					$tmp_argv2[create_user]=$GSID[UserInfo][account];
					$flag1 = $przqt_obj->db_add($tmp_argv2);
				}
				if(!$flag1){
					$tmp_msg[] = $przqt_obj->msg->get(2);
				}
			}
		}
		//echo "<pre>"; print_r($tmp_argv); exit;

		// ===== 回傳結果
		unset($GSID[$cm_func2."_MODIFY_BUF"]);

		if(count($tmp_msg)):
			$tmp_msg=array_merge( "更新{$cm_title}資料時發生錯誤!",$tmp_msg);
			$tmp_msg=array_merge($tmp_msg, $cm_obj->msg->get(2));
			gotoUrl($return."&PHP_action=view&PHP_id={$tmp_argv[id]}", $tmp_msg, 2, array(), _ER_USER_NOTICE, "ER_PROJECT_0014", $tmp_msg);
		else:
			gotoUrl($return."&PHP_action=view&PHP_id={$tmp_argv[id]}", "{$cm_title}資料更新成功!", 2);
		endif;

		break;

#########################
#	@ 檢視
#########################
	case 'view':
		$cm_id = $RQT[PHP_id];

		if (!$cm_id)
			gotoUrl($return, '未指定專案編號', 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', array('未指定資料編號'));

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_id] = $cm_id;

		$cm_list = $cm_obj->db_browse('LIST_ALL', $tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $cm_obj->msg->get(2));

		$op[data] = $cm_list[pds][0];

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_prize_id] = $op[data][id];
		$quota_datas = $przqt_obj->db_browse('LIST_ALL',$tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $przqt_obj->msg->get(2));
		$op[data][quota] = $op[class_list];
		foreach($quota_datas[pds] as $val){
			$tmp_quota[$val[class_id]] = $val[quota];
		}
		foreach($op[data][quota] as $key=>$val){
			$op[data][quota][$key][quota] = $tmp_quota[$val[id]];
		}

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][VIEW], $op);
		break;

#########################
#	@ 刪除
#########################
	case "submit_delete":

		// ===== 輸入資料確認
		$RQT[PHP_id] OR gotoUrl($return, array("刪除{$cm_title}時發生錯誤!!", "您沒有指定{$cm_title}資料編號"),  5, array(), _ER_USER_NOTICE, 'ER_PROJECT_0009', array("刪除{$cm_title}時發生錯誤!!", "使用者未指定{$cm_title}資料編號!"));

		// ===== 資料狀態確認
		$data = $cm_obj->get_db_detail($RQT[PHP_id]) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0010', $cm_obj->msg->get(2));
		if($data[status_ary][IS_DELETED]):
			gotoUrl($return, array("您所指定的資料已經刪除!", "已刪除資料不可重複刪除!"), 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0011', array("已刪除資料不可重複刪除!"));
		endif;

		// ===== 資料庫存取
		$tmp_argv = array("id"=>$RQT[PHP_id]);
		$tmp_argv[status_ary]=array("IS_DELETED"=>1);
		$tmp_argv[modify_time]=date("Y-m-d H:i:s");
		$tmp_argv[modify_user]=$GSID[UserInfo][account];

		$cm_obj->db_modify($tmp_argv) OR gotoUrl($return."&PHP_action=modify&PHP_id={$RQT[PHP_id]}", "刪除{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0012', $cm_obj->msg->get(2));

		// ===== 回傳結果
		gotoUrl($return, "{$cm_title}資料刪除成功! ", 2);

		break;


#########################
#	@ 另存新檔
#########################
	case 'save_as':
		// ===== 輸入資料確認
		$RQT[PHP_id] OR gotoUrl($return, "無法讀取{$cm_title}資料!", 3);

		$data = $cm_obj->get_db_detail($RQT[PHP_id]) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0004', $cm_obj->msg->get(2));
		$op[data]=$data;

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_prize_id] = $op[data][id];
		$quota_datas = $przqt_obj->db_browse('LIST_ALL',$tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $przqt_obj->msg->get(2));
		$op[data][quota] = $op[class_list];

		unset($data[id], $op[data][id]);

		if($data[quota]){
			foreach($op[data][quota] as $key=>$val){
				$op[data][quota][$key][quota] = $data[quota][$val[id]];
			}
		}
		else{
			foreach($quota_datas[pds] as $val){
				$tmp_quota[$val[class_id]] = $val[quota];
			}
			foreach($op[data][quota] as $key=>$val){
				$op[data][quota][$key][quota] = $tmp_quota[$val[id]];
			}
		}

		// ===== 顯示畫面
		$op[cm_action]="submit_add";
		$op[onloadJavascript]="document.form1.elements['input[prize_name]'].focus();";

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][ADD], $op);
		break;




/*#########################
#	@ 匯出獎項
#########################
	case 'export_prize':

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][BROWSE], $datas);
		break;

#########################
#	@ 匯入獎項
#########################
	case 'import_prize':

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][BROWSE], $datas);
		break;*/

#########################
#	@ 匯出配額
#########################
	case 'export_quota':

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_project_id] = $ProjectInfo[id];

		$cm_obj->CFG[DB_COLS_SORT] = "no, id";

		$datas = $cm_obj->db_browse('LIST_ALL',$tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0033', $cm_obj->msg->get(2));

		foreach($datas[pds] as $key=>$val){
			$tmp_argv = array();
			$tmp_argv[sr_prize_id] = $val[id];
			$tmp_argv[sr_not_deleted] = 1;
			$przqt_obj->CFG[DB_COLS_SORT] = "id";
			$quota_datas = $przqt_obj->db_browse('LIST_ALL',$tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0033', $przqt_obj->msg->get(2));
			foreach($quota_datas[pds] as $val2){
				$datas[pds][$key][quota][$val2[class_id]] = $val2;
			}
		}

		$op[datas] = $datas[pds];
		unset($datas);

		$layout->assign($op);
		$content = $layout->fetch($cm_obj->CFG[LAYOUT]['EXPORT'],$op);
		ob_start();
		// 產生CSV檔
		if (headers_sent()):
			echo "error!";
			exit;
		endif;
		header("Content-Type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=prize.xls");
		header('Pragma: no-cache');
		header('Expires: 0');
		echo $content;
		ob_flush();

		break;

#########################
#	@ 匯入配額
#########################
	case 'import_quota':

		//清除舊資料
		$q_try="DELETE FROM prize WHERE project_id = ".$ProjectInfo[id];
		$cm_obj->sql->query($q_try);
		$q_try="DELETE FROM prize_quota WHERE project_id = ".$ProjectInfo[id];
		$cm_obj->sql->query($q_try);

		require_once _DIR_LIB_FUNCTION . 'big5_func/big5_func.inc';

		$file_tmp = "upload/tmp_quota.csv";

		#檔案上傳
		if(file_exists($file_tmp)){
			unlink($file_tmp);
		}
		copy($_FILES['upload_file']['tmp_name'], $file_tmp);

		$contents = file($file_tmp);
		$fp = fopen ($file_tmp,"w");
		foreach($contents as $line){
			fwrite($fp, big5_utf8_encode($line));
		}
		fclose($fp);

		$fp = fopen ($file_tmp,"r");

		$tmp_msg = array();
		$star1_set = 0;
		$star2_set = 0;
		$star3_set = 0;
		$star4_set = 0;

		while ($data = fgetcsv ($fp, 65534, ",")) {
			#if($data[0] == big5_utf8_encode('排序編號')){
			if($data[0] == '排序編號'){
				continue;
			}
			$cc = count($data);
			for ($c=0; $c < $cc; $c++) {
				#$data[$c] = mysql_escape_string(big5_utf8_decode($data[$c]));
				$data[$c] = mysql_escape_string($data[$c]);
			}

			# 欄位順序：排序編號(可以10為間隔以便後續新增獎項時插入)、獎項名稱、獎品數目、獎項群組、需做得獎確認、有資格檢查、資格檢查項目(1~8)、特別動畫、描述、金額、有配額設定、配類

			// 欄位數不足部份補足 0 或空值
			$max_col_num = 14 + count($class_list[pds]);
			$data_col =  count($data);
			$emptycol = array(0, '', 0, 0, 0, 0, 0, '', 0, 0);
			for($i = $data_col; $i < $max_col_num; $i++){
				$data[$i] = $i>14 ? 0 : $emptycol[$i];
			}

			// 有配額設定時重新計算數量
			#if($data[11]){
			if ($data[13]) {
				$data[2] = 0;
				for ($i=14; $i<$max_col; $i++) {
					$data[2] += $data[$i];
				}
			}

			//新增獎項資料
			$tmp_argv = array();
			$tmp_argv[project_id] = $ProjectInfo[id];
			$tmp_argv[no] = $data[0];
			$tmp_argv[prize_name] = $data[1];
			$tmp_argv[qty] = $data[2];
			$tmp_argv[group_num] = $data[3];
			$tmp_argv[status_ary][IS_NEED_CONFIRM] = $data[4];
			$tmp_argv[status_ary][IS_QUALIFICATION] = $data[5];
			$tmp_argv[qualification_kind] = $data[6];
			$tmp_argv[status_ary][IS_HIDDEN] = $data[7];
			$tmp_argv[status_ary][IS_SPECIAL] = $data[8];
			$tmp_argv[prize_desc] = $data[9];
			#$tmp_argv[price] = $data[10];
			$tmp_argv[seq_start] = $data[10];

			$tmp_argv[status_ary][IS_QUOTA] = $data[13];
			switch($data[11]){
				case '1':
					if($star1_set){
						$tmp_msg[] = "四星彩頭獎重覆設定！忽略第二次之後的設定";
					}
					else{
						$tmp_argv[status_ary][IS_STAR1] = 1;
						$star1_set = 1;
					}
					break;
				case '2':
					if($star2_set){
						$tmp_msg[] = "四星彩二獎重覆設定！忽略第二次之後的設定";
					}
					else{
						$tmp_argv[status_ary][IS_STAR2] = 1;
						$tmp_argv[status_ary][IS_QUOTA] = 0;
						$star2_set = 1;
					}
					break;
				case '3':
					if($star3_set){
						$tmp_msg[] = "四星彩三獎重覆設定！忽略第二次之後的設定";
					}
					else{
						$tmp_argv[status_ary][IS_STAR3] = 1;
						$tmp_argv[status_ary][IS_QUOTA] = 0;
						$star3_set = 1;
					}
					break;
				case '4':
					if($star4_set){
						$tmp_msg[] = "四星彩四獎重覆設定！忽略第二次之後的設定";
					}
					else{
						$tmp_argv[status_ary][IS_STAR4] = 1;
						$tmp_argv[status_ary][IS_QUOTA] = 0;
						$star4_set = 1;
					}
					break;

			}
			if(($data[11] != '2' && $data[11] != '3' && $data[11] != '4') && $tmp_argv[status_ary][IS_QUOTA] && $data[12]){
				$tmp_argv[status_ary][IS_DRAW_ONCE] = $data[12];
			}
			$tmp_argv[create_time] = date("Y-m-d H:i:s");
			$tmp_argv[create_user] = $GSID[UserInfo][account];

			#2008.01.21.
			$tmp_argv[seq_now] = $tmp_argv[seq_start];

			$flag0 = $cm_obj->db_add($tmp_argv);
			if(!$flag0){
				$tmp_msg[] = "新增{$cm_title}資料時發生錯誤!".join(',', $cm_obj->msg->get(2));
			}
			$new_id = $cm_obj->get_new_id();
			$i=0;
			$qty = 0;
			foreach($class_list[pds] as $val3){
				$tmp_argv1 = array();
				$tmp_argv1[prize_id] = $new_id;
				$tmp_argv1[class_id] = $val3[id];

				// 四星彩頭彩各配額不得大於零，無配額設定各配額設為 0
				if($tmp_argv[status_ary][IS_QUOTA]){
					if($tmp_argv[status_ary][IS_STAR1] && $data[14+$i] > 9){
						$tmp_argv1[quota] = 9;
					}
					else{
						$tmp_argv1[quota] = $data[14+$i];
					}
				}
				else{
					$tmp_argv1[quota] = 0;
				}

				//$tmp_argv1[quota] = $tmp_argv[status_ary][IS_QUOTA]?$data[13+$i]:0;
				$tmp_argv1[create_time] = date("Y-m-d H:i:s");
				$tmp_argv1[create_user] = $GSID[UserInfo][account];
				$flag1 = $przqt_obj->db_add($tmp_argv1);
				if(!$flag1){
					$tmp_msg[] = "新增配額資料時發生錯誤!".join(',', $przqt_obj->msg->get(2));
				}
				$qty = $qty + $tmp_argv1[quota] ;
				$i++;
			}
			if($tmp_argv[status_ary][IS_QUOTA]){
				$tmp_argv = array();
				$tmp_argv[id] = $new_id;
				$tmp_argv[qty] = $qty;
				$cm_obj->db_modify($tmp_argv);
			}

			unset($tmp_argv);
		}
		fclose ($fp);

		// ===== 回傳結果
		if ((!$cm_obj->msg->length()) && count($tmp_msg) == 0) {
			if((count($incomplete) == 0)){
				gotoUrl($return."&PHP_action=browse", "{$cm_title}資料匯入成功!", 2 );
			}
			else{
				$incomplete = array_merge("{$cm_title}資料匯入完成，部份資料未匯入!", $incomplete);
				gotoUrl($return."&PHP_action=browse",$incomplete , 10, array(), _ER_USER_NOTICE, 'ER_MEMBER_0030', $incomplete );
			}
		} else {
			gotoUrl($return."&PHP_action=browse", $tmp_msg, 10, array(), _ER_USER_NOTICE, 'ER_MEMBER_0031', $tmp_msg);
		}

		break;

}

?>
