<?php
/**
 *
 *	程式名稱：	使用者存取驗證
 *	檔案名稱：	index.php
 *	版　　本：	1.0.0.
 *	作　　者：	Gilbert Chiao <gilbert@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2005.05.24.
 *	更新日期：	2007.12.11.
 *
 */



/* 載入系統組態檔。*/
require_once 'config.inc.php';



/* 初始化連線 */
if (!isset($_SESSION[GSID])) {
	$q_str = "INSERT INTO "._TBL_SYS_LOG." SET ";
	$q_str .= "ip='{$_SERVER[REMOTE_ADDR]}', ";
	$q_str .= "agent='{$_SERVER[HTTP_USER_AGENT]}', ";
	$q_str .= "refer='{$_SERVER['HTTP_REFERER']}', ";
	$q_str .= "method='{$_SERVER['REQUEST_METHOD']}', ";
	$q_str .= "session_id='".session_id()."', ";
	$q_str .= "log_time=NOW() ";
	$mysql_obj->query($q_str);
	$_SESSION[GSID][log_id]=$mysql_obj->insert_id();
}

// 連續登入失敗十次時, 將禁止存取
//if($_SESSION[GSID][mortality]>=10):
//	die('Access Denied!');
//endif;

/* 使用者物件初始化 */
require(_DIR_LIB_DBCFG.'config.sys_user.php');
require(_DIR_LIB_DBCFG.'config.sys_config.php');

/* 簡化常用變數 */
$SELF = basename($_SERVER[PHP_SELF]);
$RQT = $_REQUEST;
$op[UserInfo] = $_SESSION['UserInfo'];
$op[ProjectInfo] = $_SESSION['ProjectInfo'];
$layout->assign($op);



/* 如果已登入且為受限制之前台功能，則轉至該功能頁面 */
// 獎項與得獎名單
if ($_SESSION['ProjectInfo'][drawing] && $RQT[PHP_action]!='logout'){
	gotoUrl('draw.php');
}
// 領獎確認
if ($_SESSION['ProjectInfo'][confirming] && $RQT[PHP_action]!='logout'){
	gotoUrl('confirm.php');
}
// 抽獎按鈕
if ($_SESSION['ProjectInfo'][button] && $RQT[PHP_action]!='logout'){
	gotoUrl('button.php');
}



/* 主程式 */
switch($RQT[PHP_action]){

	/* 使用者登入畫面 */
	default:
	case "login":
		$layout->display('sys.login.html');
		break;

	/*	使用者登入驗證*/
	case "submit_login":

		// 檢查來源IP是否可執行登入
		//	機制：檢查來源IP在當日最後被停權的時間, 使用者必須在停權時間15分鐘後才可再次登入
		//				若沒有被停權的記錄, 則直接允許登入
		$q_str = "SELECT id, TIME_TO_SEC( NOW( )) - TIME_TO_SEC( suspend_time) AS delay_seconds FROM "._TBL_SYS_LOG." WHERE suspend_time!='0000-00-00 00:00:00' AND ip='{$_SERVER[REMOTE_ADDR]}' and TO_DAYS(log_time)=TO_DAYS(NOW()) ORDER BY id DESC";
		$q_result=$mysql_obj->query($q_str);
		if ($row=$mysql_obj->fetch($q_result)) {
			if ($row[delay_seconds]<15*60) {
				gotoUrl($SELF, array('無法執行登入!', '您方才已經連續超過三次輸入錯誤!', '請於15分鐘後再行登入'), 3);
			}
		}

		// Case1: 登入資料不全, 重導至登入畫面
		if (!isset($_POST[sr_account]) && !isset($_POST[sr_barcode])) {
			gotoUrl($SELF, array('登入失敗!', '您尚未輸入登入資料!'), 3, array(), _ER_USER_NOTICE, 'ER_AUTH_000', array('使用者未輸入登入資料!'));
		} elseif(isset($_POST[sr_account]) && !$_POST[password]) {
			gotoUrl($SELF, array('登入失敗!', '密碼不可空白!'), 3, array(), _ER_USER_NOTICE, 'ER_AUTH_000', array('使用者未輸入密碼!'));
		}

		// Case2: 已接收到登入資料, 驗證登入資料

		// 模式一：以帳號密碼登入
		if (isset($_POST[sr_account])) {
			$account=$_POST[sr_account];
			// * 密碼以MD5編碼
			$password=md5($_POST[password]);
			$q_str='SELECT * FROM ' . _TBL_USER . " WHERE account='{$account}' AND password='{$password}' ";

		// 模式二：以識別條碼登入
//		} else {
//			$barcode=$_POST[sr_barcode];
//			$q_str='SELECT * FROM ' . _TBL_USER . " WHERE barcode='{$barcode}' ";
		}

		$q_str .= " AND status&3=0 ";		// 1.刪除 2.離職

		$q_result = $mysql_obj->query($q_str) OR gotoUrl($SELF, '登入驗證失敗!', 3, array(), _ER_USER_ERROR, 'ER_AUTH_0001'.join($mysql_obj->msg->get(2)));
		$rownum = $mysql_obj->num_rows($q_result);

		// * 登入成功
		if ($rownum==1):
			$userdata=$mysql_obj->fetch($q_result);
			$_SESSION[GSID][UserInfo]=$user_obj->get_db_detail($userdata[id]);

			// 2006.04.24. Gilbert.
			$_SESSION[UserInfo] = &$_SESSION[GSID][UserInfo];
			$_SESSION[SysConfig]=$sys_cfg_obj->get_db_detail(1);

			// 2006.12.21 starjou
			unset($_SESSION[ProjectInfo]);	//重做登入則需重新進行專案新增或選擇作業

			// 更新連線記錄: 寫入使用者資訊
			$q_str = "UPDATE "._TBL_SYS_LOG." SET ";
			$q_str .= "user='{$userdata[account]}', ";
			$q_str .= "login_time=NOW()";
			$q_str .= " WHERE id='".$_SESSION[GSID][log_id]."'";
			$mysql_obj->query($q_str) OR gotoUrl($SELF, '更新連線記錄時發生錯誤!', 3, array(), _ER_USER_WARNING, 'ER_AUTH_0002', $mysql_obj->msg->get(2));

			// 清除登入失敗記錄
			$_SESSION[GSID][mortality]=0;

			#gotoUrl('main.php');
			gotoUrl('main.php?PHP_dType=project&PHP_action=browse&sr_not_closed=1');

		// * 登入失敗
		elseif($rownum==0):

/*			// 記錄失敗次數
			$_SESSION[GSID][mortality]++;

			// 若超過三次, 則限制該來源IP必須等15分後才能再登入
				// 若超過十次, 則自動關閉視窗, 並且禁止該Session_id繼續使用
				if($_SESSION[GSID][mortality]>=3):

					// 更新連線記錄: 寫入停權資訊
					$q_str = "UPDATE "._TBL_SYS_LOG." SET ";
					$q_str .="suspend_time=NOW()";
					$q_str .= " WHERE id='".$_SESSION[GSID][log_id]."'";
					$mysql_obj->query($q_str) OR gotoUrl($SELF, '更新連線記錄時發生錯誤!', 3, array(), _ER_USER_WARNING, 'ER_AUTH_0002', $mysql_obj->msg->get(2));

					if($_SESSION[GSID][mortality]<10):
						gotoUrl($SELF, array('登入失敗!', '您已經連續'.$_SESSION[GSID][mortality].'次輸入錯誤!', '請於15分鐘後再行登入'), 3);
					else:
						$JS='<script>';
						$JS.='alert("登入失敗!\\n您已經連續十次輸入錯誤!\\n系統將自動關閉視窗");';
						$JS.='window.close();';
						$JS.='</script>';
						die($JS);
					endif;
				else:*/
					gotoUrl($SELF, array('登入失敗!', '您所輸入的登入資料不正確!'), 3);
/*				endif;				*/

		// * 登入異常
		else:
			gotoUrl($SELF, array('登入失敗!', '您所使用的帳號出現重複的情形!', '請洽詢網站管理員!'), 3, _ER_USER_ERROR, 'ER_AUTH_0001', '使用者登入資料出現重複的情形');
		endif;

		break;

	/*	使用者登出*/
	case "logout":
		unset($_SESSION[GSID][UserInfo]);
		unset($_SESSION[UserInfo]);
		unset($_SESSION[ProjectInfo]);
		gotoUrl($SELF);
		break;
}

?>