<?php
/**
 *    程式名稱：    登入後的系統主程式
 *    說　　明：    負責處理使用者登入後的功能。
 *    檔案名稱：    main.php
 *    版　　本：    1.0.0.
 *    作　　者：    Gilbert Chiao <gilbert@price.com.tw>
 *                        Hsiao Chuan Huang <dolly@price.com.tw>
 *    著作聲明：    Price Co. Ltd.
 *    起草日期：    2005.05.24.
 *    更新日期：    2005.05.24.
 *
 */


/* 載入系統組態檔。*/
require_once 'config.inc.php';

/* 如果已登入且為受限制之前台功能，則轉至該功能頁面 */
if ($ProjectInfo[confirming]) {
    gotoUrl('confirm.php');
}

if ($ProjectInfo[button]) {
    gotoUrl('button.php');
}

#print_r($ProjectInfo);
#exit;
// ===== 初始化物件
require_once _DIR_LIB_DBCFG . 'config.prize.php';
require_once _DIR_LIB_DBCFG . 'config.prize_quota.php';

/* 簡化常用變數 */
$SELF = basename($_SERVER[PHP_SELF]);
$RQT = $_REQUEST;
$op[UserInfo] = $UserInfo;
$op[ProjectInfo] = $ProjectInfo;
// ===== 模組化參數設定
$cm_title = '抽獎';
$cm_func = 'draw';
$cm_func2 = 'DRAW';
$cm_obj = $prize_obj;
$cm_quota_obj = $przqt_obj;
$op[cm_func] = $cm_func;
$op[cm_title] = $cm_title;
$op[cm_url] = $SELF;

$layout->assign($op);

/* 進入本功能後設定 _SESSION 變數使系統只能執行本項功能*/
$ProjectInfo[drawing] = 1;
/*
 * @param array $params
 * @return  array
 * @added by
 */
function getArrayNumber(array $params){
    $arrNumber = array();
    foreach($params as $v){
        $arr = array_reverse(str_split((string)$v));
        $lengthNumber = count($arr);
        $arrNumber[$lengthNumber][]=$v;
    }
    return $arrNumber;
}

/**
 * @param array $params
 * @return array
 * Added by tenchi
 */
function  drawLottery(array $params){
    $result = array();
    $data = array(0,1,2,3,4,5,6,7,8,9);
    $arrExclude = $params["exclude"];
    $exclude = $arrExclude[1];
    foreach($exclude as $a){
        $key = array_search($a,$data);
        if($key !== false){
            array_splice($data,$key,1);
        }
    }
    if(count($data)>0){
        $result[0] = $data[array_rand($data)];
    }else{
        $result[] = "a";
    }
    for($i = 1; $i<$params["type"]; $i++){
        $arr = array(0,1,2,3,4,5,6,7,8,9);
        $key2 = true;
        while($key2!==false){
            $result[$i]= $arr[array_rand($arr)];
            $key2 = array_search($arrExclude[$i+1],array_reverse($result));
        }
    }
    return implode("",array_reverse($result));
}

/*
 * @param array $arrr
 * @return  array
 * add by
 */
function multiDrawLottery(array $arrr){
    $lotteryNumber = array();
    $amount = $arrr["amount"];
    for($i = 0;$i<$amount; $i++){
        $result = drawLottery($arrr);
        $lotteryNumber[]=$result;
        $arr = array_reverse(str_split((string)$result));
        $lengthNumber = count($arr);
        $arrr["exclude"][$lengthNumber][]=$result;
    }
    return $lotteryNumber;
}
/**
 * @param array $params
 * @return mixed|string
 * Added by tenchi
 */
function singleDrawLottery(array $params)
{
    $result = array();
    $arrExclude = $params["exclude"];
    for($i = 0; $i<$params["type"]; $i++){
        $arr = array(0,1,2,3,4,5,6,7,8,9);
        $exclude = array_shift($arrExclude);
        foreach($exclude as $a){
            $key = array_search($a,$arr);
            if($key !== false){
                array_splice($arr,$key,1);
            }
        }
        if(count($arr)>0){
            $result[] = $arr[array_rand($arr)];
        }else{
            $result[] = "a";
        }
    }
    return implode("",$result);
}

switch ($RQT[PHP_dType]) {

    /* ajax 查詢目前抽獎項目 */
    case "check_current_item":
        require_once _DIR_LIB_DBCFG . 'config.project.php';
        $current_item = $prj_obj->get_db_detail($ProjectInfo[id]);
        $current_item = $current_item[current_item];
        header("Content-Type: application/xml; charset=utf-8");
        header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");  // disable IE caching
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . "GMT");
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
        echo "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        echo "<current_item>" . $current_item . "</current_item>";
        break;

    /* ajax 檢查抽獎狀態 */
    case "check_status":
        require_once _DIR_LIB_DBCFG . 'config.sys_config.php';
        $sys_config = $sys_cfg_obj->get_db_detail(1);
        $draw_status = $sys_config[status_ary][IS_DRAW] ? 1 : 0;
        header("Content-Type: application/xml; charset=utf-8");
        header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");  // disable IE caching
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . "GMT");
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
        echo "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        echo "<draw_status>" . $draw_status . "</draw_status>";
        break;

    /* 抽獎首頁：獎項列表 */
    default:

        /*		$tmp_argv=array();
                $tmp_argv[sr_project_id] = $ProjectInfo[id];
                $tmp_argv[sr_not_deleted] = 1;
                $tmp_argv[sr_not_hide] = 1;
                $cm_obj->CFG[DB_COLS_SORT] = "no, id";
                //$cm_obj->CFG[BROWSE_SQL_TITLE] =
                $datas = $cm_obj->db_browse("LIST_ALL", $tmp_argv)  OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $cm_obj->msg->get(2));
                $op[datas] = $datas[pds];
                $layout->display('draw.main.tpl', $op);
                break;*/

        // 目前將抽獎項
//	case "item":
        require_once _DIR_LIB_DBCFG . 'config.project.php';
        $current_item = $prj_obj->get_db_detail($ProjectInfo[id]);
        $ProjectInfo[last_3] = $current_item[last_3];
        $ProjectInfo[current_item] = $current_item[current_item];
        $current_item = $current_item[current_item];

        //echo $current_item;
        /*if(!$current_item){	// project 未設定 current_item 先找有配額獎項且非一次抽完
            $tmp_argv=array();
            $tmp_argv[sr_not_drawn] = 1;
            $tmp_argv[sr_prize_not_hide] = 1;
            $tmp_argv[sr_prize_not_star234] = 1;
            $tmp_argv[sr_prize_is_quota] = 1;
            $tmp_argv[sr_not_zero] = 1;
            $tmp_argv[sr_prize_not_draw_once] = 1;
            $tmp_argv[sr_project_id] = $ProjectInfo[id];
            $cm_quota_obj->CFG[DB_COLS_SORT] = " PRZ.no, PRZ.id, PRZQTA.id ";
            $cm_quota_obj->CFG[BROWSE_SQL_TITLE] = $cm_quota_obj->CFG[BROWSE_SQL_TITLE_CURRENT_ITEM];

            $prize_items = $cm_quota_obj->db_browse("LIST_ALL", $tmp_argv);
            if(count($prize_items[pds])){
                $data = $prize_items[pds][0];
            }
            else{
            // 有配額獎項，一次抽完
                $tmp_argv=array();
                $tmp_argv[sr_not_deleted] = 1;
                $tmp_argv[sr_project_id] = $ProjectInfo[id];
                $tmp_argv[sr_not_hide] = 1;
                $tmp_argv[sr_not_drawn] = 1;
                $tmp_argv[sr_is_quota] = 1;
                $tmp_argv[sr_draw_once] = 1;
                $tmp_argv[sr_not_star234] = 1;
                $prize_items = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
                if(count($prize_items[pds])){
                    $data = $prize_items[pds][0];
                }
                else{
                // 沒有有配額獎項，找無配額獎項
                    $tmp_argv=array();
                    $tmp_argv[sr_not_deleted] = 1;
                    $tmp_argv[sr_project_id] = $ProjectInfo[id];
                    $tmp_argv[sr_not_hide] = 1;
                    $tmp_argv[sr_not_drawn] = 1;
                    $tmp_argv[sr_not_quota] = 1;
                    $tmp_argv[sr_not_star234] = 1;
                    $prize_items = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
                    $data = $prize_items[pds][0];
                }
            }
            $op[data] = $data;
        }
        else{*/
        if (substr($current_item, 0, 1) == 'q') {
            $tmp_argv = array();
            //$tmp_argv[sr_not_drawn] = 1;
            $tmp_argv[sr_id] = substr($current_item, 1);
            $cm_quota_obj->CFG[DB_COLS_SORT] = " PRZ.no, PRZ.id, PRZQTA.id ";
            $cm_quota_obj->CFG[BROWSE_SQL_TITLE] = $cm_quota_obj->CFG[BROWSE_SQL_TITLE_CURRENT_ITEM];

            $prize_items = $cm_quota_obj->db_browse("LIST_ALL", $tmp_argv);
            $op[data] = $prize_items[pds][0];
        } else
            if ($current_item != "pig_wheel") {
                $op[data] = $cm_obj->get_db_detail($current_item);
            }

        if (empty($op[data]) && $current_item != "pig_wheel") {
            //echo "沒有設定目前開獎獎項或所有獎項都已抽完，系統無法繼續進行。<br>Current item not set or all prizes drwon, system can't initialize.";
            //break;
            $current_item = "main";
        }
        $op[current_item] = $current_item ? $current_item : "main";

        if ($op[current_item] == "main") {
            // 待機畫面
            $layout->display('draw.main.tpl', $op);
        } elseif ($op[current_item] == "pig_wheel") {
            // 幸運輪
            $layout->display('draw.luckywheel.tpl', $op);
        } else if($ProjectInfo[last_3]!=0){
            // 獎項名稱
            // Added by tenchi
            #2009.01.19. Gilbert.
            $op[data][prize_name_ary] = explode(';', $op[data][prize_name]);

            $layout->display('draw.item.last.tpl', $op);
        }else {
            // 獎項名稱

            #2009.01.19. Gilbert.
            $op[data][prize_name_ary] = explode(';', $op[data][prize_name]);

            $layout->display('draw.item.tpl', $op);
        }
        break;


    /* 開獎動畫 */
    case "animator":
        $op[current_item] = $RQT[PHP_current_item];
        $op[id] = $RQT[PHP_id];
        $op[quota_id] = $RQT[PHP_quota_id];
        $op[delay] = $SysConfig[animator_time];
        $layout->display('draw.animator.tpl', $op);
        break;


    /* 抽獎秀出名單 */
    case "draw_prize":
        require_once _DIR_LIB_DBCFG . 'config.member.php';
        require_once _DIR_LIB_DBCFG . 'config.prize_list.php';
        require_once _DIR_LIB_DBCFG . 'config.project.prize.php';
        //echo "hello";

        $prize_seq_now = 0;    // 目前獎項編號：專為鴻海 2008.02.04. 動員大會的獎項用，得獎名單由此數字開始遞減。

        $tmp_argv = array();
        $tmp_argv[sr_not_deleted] = 1;
        if ($RQT[PHP_quota_id]) {
            $op[quota_id] = $RQT[PHP_quota_id];
            $tmp_argv[sr_id] = $RQT[PHP_quota_id];
            $cm_quota_obj->CFG[BROWSE_SQL_TITLE] = $cm_quota_obj->CFG[BROWSE_SQL_TITLE_CURRENT_ITEM];
            $prize = $cm_quota_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0002', $cm_quota_obj->msg->get(2));
            $prize = $prize[pds][0];
        } else {
            $tmp_argv[sr_id] = $RQT[PHP_id];
            $prize = $cm_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0002', $cm_obj->msg->get(2));
            $prize = $prize[pds][0];
        }

        $prize_seq_now = $prize[seq_now];

        // 獎項資訊
        $op[prize] = $prize;


        // 抽獎資格設定
        $tmp_argv = array();
        $tmp_argv[sr_project_id] = $ProjectInfo[id];
        $tmp_argv[sr_not_deleted] = 1;
        if ($ProjectInfo[status_ary][IS_NEED_PRESENT]) {
            $tmp_argv[sr_present] = 1;
        }
        if ($prize[group_num]) {    // 群組不可重覆中獎
            $tmp_argv[sr_group_clean] = pow(2, ($prize[group_num] - 1));
        }
        if ($prize[status_ary][IS_QUALIFICATION]) {            // 獎項設有資格檢查
            $tmp_argv[sr_qualification] = pow(2, ($prize[qualification_kind] - 1));
        }

        $member_obj->CFG[DB_COLS_SORT] = " RAND() ";

        // 計算已抽獎數目並開獎，填入得獎名單，設定得獎人之群組已得獎標記，
        // 抽獎數目 = 獎項數目 - 已抽獎數目
        /**
         * Added by tenchi
         */
//	print_r($prize);
        if ($ProjectInfo[last_3] != 0 ) {
            if($prize[status_ary][IS_DRAWN] != 1) {
                $tmp_argv = array();
                $tmp_argv[projectId] = $ProjectInfo[id];
                $draw_data = $pdtprznum_obj->db_browse("LIST_ALL", $tmp_argv);

                //undo parser exclude array
                $array_number = array();
                if (!empty($draw_data["pds"])) {
                    foreach ($draw_data["pds"] as $v) {
                        If ($v["projectId"] == $ProjectInfo[id] && $v["qualification"] == pow(2, ($prize[qualification_kind] - 1))) {
                            $array_number[] = $v["lastNum"];
                        }
                    }
                    $exclude = getArrayNumber($array_number, $ProjectInfo[last_3]);
                } else {
                    $exclude = array(array());
                }

                //20160324 add by
                $prize_id = $ProjectInfo[current_item];
                $current_item_prize = $cm_obj->get_db_detail($prize_id);
                $prize_qty = $current_item_prize[qty];
                // $prize_qty = 2;


                #print_r($draw_data);
                $arrdata2 = array("type" => $ProjectInfo[last_3], "amount" => $prize_qty, "exclude" => $exclude);
                //print_r( $arrdata2);
                //$result = drawLottery($arrdata2);
                $result = multiDrawLottery($arrdata2);

                $tmp_argv3 = array();
                $tmp_argv3[projectId] = $ProjectInfo[id];
                $tmp_argv3[prizeId] = $ProjectInfo[current_item];
                $tmp_argv3[qualification] = pow(2, ($prize[qualification_kind] - 1));
                foreach ($result as $a) {
                    $tmp_argv3[lastNum] = $a;
                    $pdtprznum_obj->db_add($tmp_argv3);
                }
            }else {
                $prize_id = $ProjectInfo[current_item];
                $tmp_argv = array();
                $tmp_argv[projectId] = $ProjectInfo[id];
                $draw_data = $pdtprznum_obj->db_browse("LIST_ALL", $tmp_argv);
                $result = array();
                if (!empty($draw_data["pds"])) {
                    foreach ($draw_data["pds"] as $v) {
                        If ($v["prizeId"] == $prize_id) {
                            $result[] = $v["lastNum"];
                        }
                    }
                }
            }
// jason added
            //$pdtprznum_obj->debug=1;

//			$arrdataExample = array("type"=>$ProjectInfo[last_3],"amount"=>2,"exclude"=>array());
//			print_r( $arrdataExample);
//			$result = multiDrawLottery($arrdataExample);
//			print_r($result);

        } else { // original rule
            // 配額分項抽獎，以有沒 $RQT[quota_id] 判定是否為有配額獎項 2007.01.25 starjou
            if ($prize[status_ary][IS_QUOTA] && $prize[status_ary][IS_DRAW_ONCE]) {        // 有配額設定且一次抽完，逐一配額別類抽獎
                $tmp_argv1 = array();
                $tmp_argv1[sr_prize_id] = $prize[id];
                $tmp_quota = $przqt_obj->db_browse("LIST_ALL", $tmp_argv1);
                //echo "<pre>"; print_r($tmp_quota[pds]); exit;
                foreach ($tmp_quota[pds] as $val) {
                    $tmp_argv2 = array();
                    $tmp_argv2[sr_prize_id] = $prize[id];
                    $tmp_argv2[sr_class_id] = $val[class_id];
                    $tmp_argv2[sr_not_deleted] = 1;
                    $przlst_obj->CFG[DB_COLS_GROUP] = "PRZLST.prize_id";
                    //$przlst_obj->debug = true;
                    $przlst_obj->CFG[BROWSE_SQL_TITLE] = $przlst_obj->CFG[BROWSE_SQL_TITLE_COUNT];
                    //echo $przlst_obj->CFG[BROWSE_SQL_TITLE] ;
                    $prize_count = $przlst_obj->db_browse("LIST_ALL", $tmp_argv2);
                    //目前數目
                    $drawn_qty = $prize_count[pds][0] ? $prize_count[pds][0][DRAWN_QTY] : 0;
                    $remain_qty = $val[quota] - $drawn_qty < 0 ? 0 : $val[quota] - $drawn_qty;
                    if ($remain_qty > 0) {

                        $tmp_argv[sr_class_id] = $val[class_id];

                        if ($prize[status_ary][IS_STAR1]) {    // 四星彩頭獎尾碼不重覆
                            $drawn_cnt = 0;
                            $draw_data = array();
                            $tail = array();
                            $tail['0'] = 0;
                            $tail['1'] = 1;
                            $tail['2'] = 2;
                            $tail['3'] = 3;
                            $tail['4'] = 4;
                            $tail['5'] = 5;
                            $tail['6'] = 6;
                            $tail['7'] = 7;
                            $tail['8'] = 8;
                            $tail['9'] = 9;
                            $tmp_argv[sr_tail] = $tail;
                            $member_obj->CFG[ROW_PER_PAGE] = 1;
                            $tmp_argv[PHP_sr_startno] = 0;
                            //$member_obj->debug = true;
                            $star1_drawn = 0;
                            $draw_success = true;
                            //echo $star1_drawn." ".$remain_qty."<br>";
                            while (($star1_drawn < $remain_qty) && $draw_success) {    // 抽獎成功且尚未抽完時重覆抽
                                $draw_star1 = $member_obj->db_browse("LIST_ALL", $tmp_argv);
                                //echo "<pre>"; print_r($draw_star1);
                                if (count($draw_star1[pds]) == 1) {
                                    $draw_data[pds][] = $draw_star1[pds][0];
                                    $star1_drawn = $star1_drawn + 1;
                                    //echo $tail[substr($draw_star1[pds][0][lottery_no],-1)];
                                    //echo substr($draw_star1[pds][0][lottery_no],-1);
                                    unset($tail[substr($draw_star1[pds][0][lottery_no], -1)]);
                                    //echo "<pre>"; print_r($tail);
                                    $tmp_argv[sr_tail] = $tail;
                                } else {
                                    $draw_success = false;
                                }
                            }
                            //echo "<pre>"; print_r($draw_data[pds]);
                            $drawn_cnt = count($draw_data[pds]);
                        } else {    // 非為四星彩頭獎
                            $member_obj->CFG[ROW_PER_PAGE] = $remain_qty;
                            $tmp_argv[PHP_sr_startno] = 0;
                            $draw_data = $member_obj->db_browse("LIST_ALL", $tmp_argv);
                            $drawn_cnt = count($draw_data[pds]);
                        }
//					echo "<pre>". $drawn_cnt." ".$remain_qty; print_r($draw_data[pds]);
//					$i = 0;
                        //echo "<pre>"; print_r($draw_data[pds]);
                        if (count($draw_data[pds])) {
                            foreach ($draw_data[pds] as $val1) {
                                //						if($i >= $drawn_cnt || $i >= $remain_qty){
                                //							break;
                                //						}
                                $tmp_argv3 = array();
                                $tmp_argv3[prize_id] = $prize[id];
                                $tmp_argv3[member_id] = $val1[id];
                                $tmp_argv3[project_id] = $ProjectInfo[id];
                                $tmp_argv3[quota_id] = $val[id];
                                $tmp_argv3[create_time] = date('Y-m-d H:i:s');
                                if ($prize[status_ary][IS_STAR1]) {    //四星彩頭獎
                                    $tmp_argv3[status_ary][IS_STAR1] = 1;
                                }
                                if($prize[status_ary][IS_DRAWN] != 1){
                                $tmp_argv[status_ary][IS_DRAWN] = 1;
                                $przlst_obj->db_add($tmp_argv3) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0003', $przlst_obj->msg->get(2));
}
                                if ($prize[group_num]) {
                                    $tmp_argv4 = array();
                                    $tmp_argv4[id] = $val1[id];
                                    $tmp_argv4[groupmark] = ($val1[groupmark] | pow(2, $prize[group_num] - 1));
                                    //$member_obj->debug = true;
                                    $member_obj->db_modify($tmp_argv4) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0004', $member_obj->msg->get(2));
                                }
                                //						$i++;
                            }
                        }
                    }
                }
                unset($tmp_argv[sr_class_id]);
            } else {    // 有配額分次抽或無配額
                $tmp_argv2 = array();
                $tmp_argv2[sr_not_deleted] = 1;
                if ($RQT[PHP_quota_id]) {    // 有配額
                    $tmp_argv2[sr_quota_id] = $RQT[PHP_quota_id];
                    $przlst_obj->CFG[DB_COLS_GROUP] = "PRZLST.quota_id";
                } else {    // 無配額
                    $tmp_argv2[sr_prize_id] = $prize[id];
                    $przlst_obj->CFG[DB_COLS_GROUP] = "PRZLST.prize_id";
                }
                //$przlst_obj->debug = true;
                $przlst_obj->CFG[BROWSE_SQL_TITLE] = $przlst_obj->CFG[BROWSE_SQL_TITLE_COUNT];
                //echo $przlst_obj->CFG[BROWSE_SQL_TITLE] ;
                $prize_count = $przlst_obj->db_browse("LIST_ALL", $tmp_argv2);
                //目前數目
                $drawn_qty = $prize_count[pds][0] ? $prize_count[pds][0][DRAWN_QTY] : 0;
                if ($RQT[PHP_quota_id]) {
                    $remain_qty = $prize[quota] - $drawn_qty < 0 ? 0 : $prize[quota] - $drawn_qty;
                } else {
                    $remain_qty = $prize[qty] - $drawn_qty < 0 ? 0 : $prize[qty] - $drawn_qty;
                }
                //echo "<pre>"; print_r($prize_count); exit;
                //echo $remain_qty;
                //$member_obj->debug=true;
                if ($remain_qty > 0) {
                    if ($RQT[PHP_quota_id]) {
                        $tmp_argv[sr_class_id] = $prize[class_id];
                    }

                    if ($prize[status_ary][IS_STAR1]) {    // 四星彩頭獎尾碼不重覆
                        $tail = array();
                        $tail['0'] = 0;
                        $tail['1'] = 1;
                        $tail['2'] = 2;
                        $tail['3'] = 3;
                        $tail['4'] = 4;
                        $tail['5'] = 5;
                        $tail['6'] = 6;
                        $tail['7'] = 7;
                        $tail['8'] = 8;
                        $tail['9'] = 9;
                        $tmp_argv[sr_tail] = $tail;
                        $member_obj->CFG[ROW_PER_PAGE] = 1;
                        $tmp_argv[PHP_sr_startno] = 0;
                        //$member_obj->debug = true;
                        $star1_drawn = 0;
                        $draw_success = true;
                        //echo $star1_drawn." ".$remain_qty."<br>";
                        while (($star1_drawn < $remain_qty) && $draw_success) {    // 抽獎成功且尚未抽完時重覆抽
                            $draw_star1 = $member_obj->db_browse("LIST_ALL", $tmp_argv);
                            //echo "<pre>"; print_r($draw_star1);
                            if (count($draw_star1[pds]) == 1) {
                                $draw_data[pds][] = $draw_star1[pds][0];
                                $star1_drawn = $star1_drawn + 1;
                                //echo $tail[substr($draw_star1[pds][0][lottery_no],-1)];
                                //echo substr($draw_star1[pds][0][lottery_no],-1);
                                unset($tail[substr($draw_star1[pds][0][lottery_no], -1)]);
                                //echo "<pre>"; print_r($tail);
                                $tmp_argv[sr_tail] = $tail;
                            } else {
                                $draw_success = false;
                            }
                        }
                        //echo "<pre>"; print_r($draw_data[pds]);
                        $drawn_cnt = count($draw_data[pds]);
                    } else {    // 非為四星彩頭獎
                        $member_obj->CFG[ROW_PER_PAGE] = $remain_qty;
                        $tmp_argv[PHP_sr_startno] = 0;
                        $draw_data = $member_obj->db_browse("LIST_ALL", $tmp_argv);
                        $drawn_cnt = count($draw_data[pds]);
                    }
                    //exit;
                    if (count($draw_data[pds])) {
                        foreach ($draw_data[pds] as $val1) {
                            $tmp_argv3 = array();
                            $tmp_argv3[prize_id] = $prize[id];
                            $tmp_argv3[member_id] = $val1[id];
                            if ($RQT[PHP_quota_id]) {
                                $tmp_argv3[quota_id] = $RQT[PHP_quota_id];
                            }
                            $tmp_argv3[project_id] = $ProjectInfo[id];
                            //$przlst_obj->debug = true;
                            //echo "<pre>"; print_r($tmp_argv3);
                            if ($prize[status_ary][IS_STAR1]) {    //四星彩頭獎
                                $tmp_argv3[status_ary][IS_STAR1] = 1;
                            }

                            #2008.01.21.
                            $tmp_argv3[create_time] = date('Y-m-d H:i:s');
                            $tmp_argv3[seq_no] = $prize_seq_now;
                            if($prize[status_ary][IS_DRAWN] != 1){
                            $tmp_argv[status_ary][IS_DRAWN] = 1;
                            $przlst_obj->db_add($tmp_argv3) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0005', $przlst_obj->msg->get(2));
                            }
                            $prize_seq_now--;

                            if ($prize[group_num]) {
                                $tmp_argv4 = array();
                                $tmp_argv4[id] = $val1[id];
                                $tmp_argv4[groupmark] = ($val1[groupmark] | pow(2, $prize[group_num] - 1));
                                $member_obj->db_modify($tmp_argv4) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0006', $member_obj->msg->get(2));
                            }
                            //	$i++;
                        }
                    }
                }
            }
        }

        // 設定該獎項已開獎
        $tmp_argv = array();
        if ($RQT[PHP_quota_id]) {
            $tmp_argv[id] = $RQT[PHP_quota_id];
            $tmp_argv[status_ary][IS_DRAWN] = 1;
            $cm_quota_obj->db_modify($tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0007', $cm_quota_obj->msg->get(2));
        } else {
            $tmp_argv[id] = $prize[id];
            $tmp_argv[status_ary][IS_DRAWN] = 1;
            $cm_obj->db_modify($tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0007', $cm_obj->msg->get(2));
        }

        require_once _DIR_LIB_DBCFG . 'config.sys_config.php';
        $scroll_speed = $sys_cfg_obj->get_db_detail(1);
        //yao auto speed qty>500
        //if ($prize[quota] > 500 || $prize[qty] > 500)
            $op[scroll_speed] = $scroll_speed[scroll_speed];
            $op[scroll_count] = $scroll_speed[scroll_count];
        //else
        //    $op[scroll_speed] = 0;
        // 得獎名單
        $tmp_argv = array();
        if ($RQT[PHP_quota_id]) {
            $tmp_argv[sr_quota_id] = $RQT[PHP_quota_id];
        } else {
            $tmp_argv[sr_prize_id] = $RQT[PHP_id];
        }
        $tmp_argv[sr_not_deleted] = 1;
        $tmp_argv[sr_project_id] = $ProjectInfo[id];
        $przlst_obj->CFG[DB_COLS_SORT] = " PRZ.id ";
        $przlst_obj->CFG[DB_COLS_SORT] = " PRZLST.seq_no DESC";
        unset($przlst_obj->CFG[DB_COLS_GROUP]);
        $przlst_obj->CFG[BROWSE_SQL_TITLE] = $przlst_obj->CFG[BROWSE_SQL_TITLE_LIST];
        //echo "<pre>"; print_r($przlst_obj);exit;
        //$przlst_obj->debug = true;
        $prize_list = $przlst_obj->db_browse("LIST_ALL", $tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0008', $przlst_obj->msg->get(2));

        // 固定寬度 2008.01.08.
        $prize_number = 3;        // 獎項編號
        #$member_code_no = 7;	// 工號字數
        #2009.01.20. Gilbert.
        $member_code_no = 8;    // 工號字數
        $name_no = 4;            // 姓名字數
        $group_no = 11;            // 事業群字數
        $memo_no = 16;            // 備註字數
        #2009.01.15. Gilbert.
        $department_no = 10;            // 部門字數
        $lottery_no = 6 ;

        $cnt = 1;
        foreach ($prize_list[pds] AS $kk => $vv) {
            /*$prize_list[pds][$kk][cnt] = sprintf("%03d", $cnt);*/
            #2009.01.15. Gilbert.
            $prize_list[pds][$kk][cnt] = sprintf("%02d", $cnt);
            $cnt++;


            // 獎項編號
            $prize_number_length = strlen($vv[seq_no]);
            $seq_no = $vv[seq_no];
            for ($i = 0; $i < ($prize_number - $prize_number_length); $i++) {
                $seq_no = '0' . $seq_no;
            }
            $prize_list[pds][$kk][seq_no] = $seq_no;


            // 工號
            $member_code_length = mb_strlen($vv[member_code], 'utf8');
            for ($i = $member_code_length; $i < $member_code_no; $i++) {
                #$prize_list[pds][$kk][member_code] .= "&nbsp;";
                #2009.01.15. Gilbert.
                #$prize_list[pds][$kk][member_code] .= " ";
                #2009.01.20. Gilbert.
                $prize_list[pds][$kk][member_code] .= "&nbsp;";
            }

            // 姓名
            $name_length = mb_strlen($vv[name], 'utf8');
            for ($i = $name_length; $i < $name_no; $i++) {
                $prize_list[pds][$kk][name] .= "　";
            }

            // 備註 2008/1/24
            $prize_list[pds][$kk][memo] = mb_substr($vv[memo], 0, $memo_no, 'utf8');
            // 獎卷
            $prize_list[pds][$kk][lottery_no] = mb_substr($vv[lottery_no], 0, $lottery_no, 'utf8');

            // 部門
            $prize_list[pds][$kk][department] = mb_substr($vv[department], 0, $department_no, 'utf8');

            // 事業群 2008/1/24
            #$business_group = mb_substr($vv[business_group], 0, $group_no, 'utf8');
            #2009.01.19. 若是特別動畫，事業群最多抓十個字
            if ($prize[status_ary][IS_SPECIAL]) {
                $business_group = mb_substr($vv[business_group], 0, 11, 'utf8');
            } else {
                $business_group = mb_substr($vv[business_group], 0, $group_no, 'utf8');
            }
            //$business_group = $vv[business_group];
            $business_group = str_replace('A', 'Ａ', $business_group);
            $business_group = str_replace('B', 'Ｂ', $business_group);
            $business_group = str_replace('C', 'Ｃ', $business_group);
            $business_group = str_replace('D', 'Ｄ', $business_group);
            $business_group = str_replace('E', 'Ｅ', $business_group);
            $business_group = str_replace('F', 'Ｆ', $business_group);
            $business_group = str_replace('G', 'Ｇ', $business_group);
            $business_group = str_replace('H', 'Ｈ', $business_group);
            $business_group = str_replace('I', 'Ｉ', $business_group);
            $business_group = str_replace('J', 'Ｊ', $business_group);
            $business_group = str_replace('K', 'Ｋ', $business_group);
            $business_group = str_replace('L', 'Ｌ', $business_group);
            $business_group = str_replace('M', 'Ｍ', $business_group);
            $business_group = str_replace('N', 'Ｎ', $business_group);
            $business_group = str_replace('O', 'Ｏ', $business_group);
            $business_group = str_replace('P', 'Ｐ', $business_group);
            $business_group = str_replace('Q', 'Ｑ', $business_group);
            $business_group = str_replace('R', 'Ｒ', $business_group);
            $business_group = str_replace('S', 'Ｓ', $business_group);
            $business_group = str_replace('T', 'Ｔ', $business_group);
            $business_group = str_replace('U', 'Ｕ', $business_group);
            $business_group = str_replace('V', 'Ｖ', $business_group);
            $business_group = str_replace('W', 'Ｗ', $business_group);
            $business_group = str_replace('X', 'Ｘ', $business_group);
            $business_group = str_replace('Y', 'Ｙ', $business_group);
            $business_group = str_replace('Z', 'Ｚ', $business_group);

            $business_group = str_replace('a', 'ａ', $business_group);
            $business_group = str_replace('b', 'ｂ', $business_group);
            $business_group = str_replace('c', 'ｃ', $business_group);
            $business_group = str_replace('d', 'ｄ', $business_group);
            $business_group = str_replace('e', 'ｅ', $business_group);
            $business_group = str_replace('f', 'ｆ', $business_group);
            $business_group = str_replace('g', 'ｇ', $business_group);
            $business_group = str_replace('h', 'ｈ', $business_group);
            $business_group = str_replace('i', 'ｉ', $business_group);
            $business_group = str_replace('j', 'ｊ', $business_group);
            $business_group = str_replace('k', 'ｋ', $business_group);
            $business_group = str_replace('l', 'ｌ', $business_group);
            $business_group = str_replace('m', 'ｍ', $business_group);
            $business_group = str_replace('n', 'ｎ', $business_group);
            $business_group = str_replace('o', 'ｏ', $business_group);
            $business_group = str_replace('p', 'ｐ', $business_group);
            $business_group = str_replace('q', 'ｑ', $business_group);
            $business_group = str_replace('r', 'ｒ', $business_group);
            $business_group = str_replace('s', 'ｓ', $business_group);
            $business_group = str_replace('t', 'ｔ', $business_group);
            $business_group = str_replace('u', 'ｕ', $business_group);
            $business_group = str_replace('v', 'ｖ', $business_group);
            $business_group = str_replace('w', 'ｗ', $business_group);
            $business_group = str_replace('x', 'ｘ', $business_group);
            $business_group = str_replace('y', 'ｙ', $business_group);
            $business_group = str_replace('z', 'ｚ', $business_group);

            $business_group = str_replace('/', '／', $business_group);

            $group_length = mb_strlen($business_group, 'utf8');
            for ($i = $group_length; $i < $group_no; $i++) {
                //$prize_list[pds][$kk][business_group] .= "　";
                //$business_group .= "　";
            }
            $prize_list[pds][$kk][business_group] = $business_group;

        }

        $op[prize_cnt] = count($prize_list[pds]);
        $op[prize_list] = $prize_list[pds];
        $op[current_item] = $RQT[PHP_current_item];
        // 畫面延遲設定
        $op[delay] = $SysConfig[prize_list_time];

        /**
         * Added by tenchi
         */
        if ($ProjectInfo[last_3] != 0) {
            $op[prize_list][0][member_code] = '';
            $op[prize_list][0][business_group] = '';
            $op[prize_list][0][result] = $result;
            $layout->assign("result",$op[prize_list][0][result]);
            $splitNumber = str_split($result[0]);
            $layout->assign("length",$splitNumber);
            $layout->display('draw.prize_list.special5.tpl', $op);

        } elseif (!$prize[status_ary][IS_SPECIAL]) {
            $layout->display('draw.prize_list.marquee.tpl', $op);
//			$layout->display('draw.prize_list.tpl', $op);
        } else {
            // 特別動畫的得獎人名特殊處理
            /*$winner_name = $op[prize_list][0][name];
            $winner_name = str_replace('　', '', $winner_name);
            $winner_name_length = mb_strlen($winner_name);
            switch ($winner_name_length) {
                case 1:
                    $winner_name = '　' . $winner_name . '　　';
                    break;
                case 2:
                    $winner_name = '　' . $winner_name . '　';
                    break;
                case 3:
                    $winner_name = '&nbsp;' . $winner_name . '&nbsp;';
                    break;
                default:
                    $winner_name = $winner_name;
                    break;
            }
            $op[prize_list][0][name] = $winner_name;
            */

            # 特別動畫，不用補字，以便顯示時能夠置中。
            $op[prize_list][0][member_code] = str_replace('&nbsp;', '', $op[prize_list][0][member_code]);
            $op[prize_list][0][name] = str_replace('　', '', $op[prize_list][0][name]);
            $op[prize_list][0][business_group] = str_replace('　', '', $op[prize_list][0][business_group]);

            $layout->display('draw.prize_list.special.tpl', $op);
        }
        break;

}

?>
