<?php
/**
 *
 *	程式名稱：	登入後的系統主程式
 *	說　　明：	負責處理使用者登入後的功能。
 *	檔案名稱：	main.php
 *	版　　本：	1.0.0.
 *	作　　者：	Gilbert Chiao <gilbert@price.com.tw>
 *	著作聲明：	Price Co. Ltd.
 *	起草日期：	2005.05.24.
 *	更新日期：	2005.05.24.
 *
 */



/* 載入系統組態檔。*/
require_once 'config.inc.php';

/* 簡化常用變數 */
$SELF=basename($_SERVER[PHP_SELF]);
$RQT=$_REQUEST;
$op[UserInfo] = $UserInfo;
$op[ProjectInfo] = $ProjectInfo;
$layout->assign($op);

/* 如果已登入且為受限制之前台功能，則轉至該功能頁面 */
if($ProjectInfo[drawing]){
	gotoUrl('draw.php');
}

if($ProjectInfo[button]){
	gotoUrl('button.php');
}

/* 進入本功能後設定 _SESSION 變數使系統只能執行本項功能*/
$ProjectInfo[confirming] = 1;

// ===== 初始化物件
require_once _DIR_LIB_DBCFG . 'config.prize_list.php';

require_once _DIR_LIB_FUNCTION . 'JSescape.php';
require_once _DIR_LIB_CLASS . 'class.Javascript.php';


// ===== 模組化參數設定
$cm_title = '領獎';
$cm_func = 'confirm';
$cm_func2 = 'CONFIRM';
$cm_obj = $przlst_obj;
$op[cm_func] = $cm_func;
$op[cm_title] = $cm_title;
$op[cm_url] = $SELF;

# 除錯設定
$op[cm_debug] = true;
#$layout->smarty->debugging = true;
$layout->smarty->clear_compiled_tpl();

$layout->assign($op);


// ===== 常用變數
$return = $SELF . '?PHP_dType=' . $cm_func;
$action = $_REQUEST['PHP_dType'];

# 列表
//$xxx_list = $xxx_obj->db_browse('LIST_ALL', array('sr_not_deleted'=>1));
//$op[xxx_list] = $store_list[pds];

switch($action){

	/* 系統首頁 */
	default:

		$op[onloadJavascript] = 'document.form1.PHP_lottery_no.focus()';
		$layout->display('confirm.main.tpl', $op);

		break;

	/* 得獎確認 */
	case 'submit_confirm':

		$tmp_argv = array();
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_lottery_no] = $RQT[PHP_lottery_no];
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_need_confirm] = 1;
		$op[lottery_no] = $RQT[PHP_lottery_no];
		//$cm_obj->debug = true;
		$op[datas] = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
		// 設定獎項為確認
		foreach($op[datas][pds] as $val){
			$tmp_argv = array();
			$tmp_argv[id] = $val[id];
			$tmp_argv[status_ary][IS_CONFIRMED] = 1;
			$flag0 = $cm_obj->db_modify($tmp_argv);
			if(!$flag0){
				$tmp_msg[] = "更新確認狀態失敗，編號：".$val[id]."<br>\n";
			}
		}
		if(count($tmp_msg)){
			echo "<pre>"; print_r($tmp_msg);
		}
		else{
			$op[onloadJavascript] ="parent.document.getElementById('confirm_frame').height= document.getElementById('result_tbl').offsetHeight;parent.document.form1.PHP_lottery_no.value='';parent.document.form1.PHP_lottery_no.focus()";
			$layout->display('confirm.confirm.tpl', $op);
		}
		break;

	/* 查詢 */
	case 'query':

		$tmp_argv = $RQT;
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_need_confirm] = 1;
		//$cm_obj->debug = true;
		$op[datas] = $cm_obj->db_browse("LIST_ALL", $tmp_argv);

		$op[onloadJavascript] ="parent.document.getElementById('query_frame').height= document.getElementById('result_tbl').offsetHeight;parent.document.form1.PHP_lottery_no.value='';parent.document.form1.PHP_lottery_no.focus()";
		$layout->display('confirm.query.tpl', $op);

		break;
}

?>