<?php


##############################################################################################
# CLASS NAME: MSG_HANDLE
#
# CLASS DESCRIPTION:
#				用來handle message的
#
# @author       Ming-Hsien Lee (pipperl@pchome.com.tw)
# @version      1.0.2
# @copyright    
# @since        2002/01/01
#				2002/01/29 : (1.0.1) 新增 clean() func
#				2002/03/08 : (1.0.2) merge func 預設merge後把msg clean掉，除非$mode=1
#
# @access       public
#
#

CLASS MSG_HANDLE {
	var $display_msg_ary;
	var $error_flag;

	############################################################ 初始化
	function MSG_HANDLE() {
		$this->display_msg_ary = array();
		$error_flag = 0;
		
	}


	############################################################# 加入msg
	function add($msg=0) {
		$this->display_msg_ary[] = $msg;


		return true;
	}

	
	##############################################################################################
	# FUNCTION NAME: clean
	#
	# FUNCTION DESCRIPTION:
	#				清除$display_msg_ary中的內容
	#
	#
	# @param		
	#
	# @version      1.0.0
	# @since        2002/01/29
	# @return       T/F
	#
	
	function clean() {
	    $this->display_msg_ary = array();
		return true;
	} // end func

	############################################################## 取得display_msg內的資料
																 # mode=0 : HTML格式(預設)
																 # mode=1 : Plain TEXT
																 # mode=2 : 傳回msg_array
																 # mode=3 : 傳回 HTMLIZE的$msg_array

	function get($mode=0) {

		$msg_ary= $this->display_msg_ary;
		$return_str="";

		if ($mode == 0 ) {

			if (!$msg_ary) {
				return '<TABLE border=1 align="center"><TR><TD> </TD></TR></TABLE>'."\n";
			}
		
			$return_str .= "<TABLE border=1>\n";
			foreach ($msg_ary AS $val){
				$return_str .= "<TR><TD><font size=2>". nl2br(ereg_replace(" ", " &nbsp;", htmlspecialchars($val))). "</font></TD></TR>\n";
//				$return_str .= "<TR><TD><font size=2>". nl2br($val). "</font></TD></TR>\n";
			}
			$return_str .= "</TABLE>\n";
			return $return_str;

		}
		elseif ($mode == 1) {
			if (!$msg_ary) {
				return "\n";
			}

			foreach ($msg_ary AS $val){
				$return_str .= $val."\n";
			}

			return $return_str;

		}
		elseif ($mode==2) {
//			$ret = array();
			 return $msg_ary;
		    
		}
		elseif ($mode==3) {
		    foreach ($msg_ary AS  $key=>$val  ) {
				$tmp = htmlspecialchars($val);
		        $html_ary[$key] = strtr($tmp,array(" "=>"&nbsp;"));
		    }
		    return $html_ary;
		}

	
	}

	############################################################# check if error happens
																# mode=0: have message
																# mode="error": error happens
	function check($mode=0) {

		foreach ($this->msg AS $key=>$val) {
			if (strstr($val,"錯誤") || stristr($val,"Error")) {
				$this->error_flag = 1;
			}
		}

		if ($mode="error" && $this->error_flag==1) {
			return true;
		}
		
		if (count($this->display_msg_ary) > 0) {
			return true;

		}
		
		return false;

	
	}

		
	##############################################################################################
	# FUNCTION NAME:	merge
	#
	# FUNCTION DESCRIPTION:
	#				把另一個msg的內容merge過來，並清除其內容
	#
	# @param	
	#				$msg_object : 另一個msg
	#				$mode		: 0: clean掉
	#							  1: 保留不clean
	#
	# @version      1.1.0
	# @since        2002/01/01
	#				2002/03/08 : (1.1.0) 加mode
	# @return       void
	#
		
	function merge($msg_object,$mode=0) {
	
		if (get_class($msg_object) != "msg_handle") {
			$this->add("錯誤: 無法merge msg object。");
			$this->add("原因：要merge的不是MSG_HANDLE 物件 ");
			$this->add("      object:". get_class($msg_object));

			return false;
		}

		foreach($msg_object->display_msg_ary AS $key=>$val) {
				$this->display_msg_ary[] = $val;
			}
		if ($mode==0) {
		    $msg_object->clean();			    
		}

		return true;
	}


	########################################################################################
	# FUNCTION NAME: lenth
	#
	# FUNCTION DESCRIPTION:
	#				回傳訊息長度
	#
	#
	# @param		
	#
	# @version      1.0.0
	# @since        2002/01/29
	# @return       $length
	#
	
	function length() {
		return count($this->display_msg_ary);
	} // end func


}

?>