<?php

#########################################################################################
#	CLASS NAME： JavaScript
#
#	
# 

class Javascript {

	var $scripts;


	###############################################################################
	#	FUNCTION NAME： Javascript
	#
	#	DESCRIPTION			物件初始化
	# 

	function Javascript(){

			$this->scripts=array();

			return true;
	}


	###############################################################################
	#	FUNCTION NAME： action_start
	#
	#	DESCRIPTION			執行Javascript, 也就是print out script內容
	# 
	
	function action_start(){

		echo "<script>";
		echo join("\n",$this->scripts);
		echo "</script>";
	}

	###############################################################################
	#	FUNCTION NAME： add_script
	#
	#	DESCRIPTION			新增指令
	# 

	function add_script($script){
		$scripts=is_array($script)?$script:array($script);
		$this->scripts=array_merge($this->scripts, $scripts);
		//$this->scripts[]=$script;

	}

	###############################################################################
	#	FUNCTION NAME： alert
	#
	#	DESCRIPTION			利用Javascript alert function顯示訊息
	# 

	function alert($msg){

		if(is_array($msg)):
			$msg=join("\\n",$msg);
		endif;

		$this->scripts[]="alert(\"{$msg}\");";

		return true;
	}


	###############################################################################
	#	FUNCTION NAME： clean
	#
	#	DESCRIPTION			清空目前的scripts內容
	# 
	
	function clean(){

		$this->scripts=array();
		return true;

	}



	###############################################################################
	#	FUNCTION NAME： fillout_text
	#
	#	DESCRIPTION			將值填入文字欄位
	# 

	function fillout_text($form_obj,$text_obj,$value){

		$this->scripts[]="{$form_obj}.elements['{$text_obj}'].value=\"{$value}\";";
	}


	###############################################################################
	#	FUNCTION NAME： iframe_reload
	#
	#	DESCRIPTION			重新載入Iframe資料
	# 

	function iframe_reload($iframe_id,$src,$target="parent"){

		$this->scripts[]="{$target}.document.getElementById('{$iframe_id}').contentWindow.location.replace(\"{$src}\");"; 

	}


	###############################################################################
	#	FUNCTION NAME： focus
	#
	#	DESCRIPTION			將焦點移到指定的欄位
	# 

	function focus($form_obj,$field){

		$this->scripts[]="{$form_obj}.elements['{$field}'].focus();";

	}

	###############################################################################
	#	FUNCTION NAME： select
	#
	#	DESCRIPTION			選取指定欄位的內容
	# 

	function select($form_obj,$field){

		$this->scripts[]="{$form_obj}.elements['{$field}'].select();";

	}

	###############################################################################
	#	FUNCTION NAME： run
	#
	#	DESCRIPTION			執行Javascript, 
	# 
	#	@Parm						$mode:	0: no redirect /  1: redirect
	#										$Svar:		記錄Script的Session變數
	#										$URL:		執行Script的鏈結
	
	function run($mode=0,$Svar=0,$URL=0){

		if($mode):
			$Svar=$this->scripts;
			header("Location:".$URL);
		else:
			echo "<html><head><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=big5\"></head><body>";
			echo "<script>";
			echo join("\n",$this->scripts);
			echo "</script>";
			echo "</body></html>";
		endif;
	}


	###############################################################################
	#	FUNCTION NAME： set_style
	#
	#	DESCRIPTION			設定style
	# 

	function set_style($id,$property,$value,$target="parent",$mode=0){

		if(!$mode):
			$this->scripts[]="{$target}.document.getElementById('{$id}').style.{$property}=\"{$value}\";";
		else:
			$this->scripts[]="{$target}.elements['{$id}'].style.{$property}=\"{$value}\";";
		endif;
	}


	###############################################################################
	#	FUNCTION NAME： resetOptions
	#
	#	DESCRIPTION			設定選單內容
	# 

	function resetOptions($form_obj,$select_obj,$options){

			$this->scripts[]="with({$form_obj}.elements['{$select_obj}']){";
			$this->scripts[]="menulength=options.length-1; ";
			$this->scripts[]="for (var i = menulength; i >=1; i--) { options[i] = null; }";
			foreach($options AS $key=>$val){
				$this->scripts[]="options[{$key}]=new Option('{$val[text]}','{$val[value]}'); ";
				if($val[id]): $this->scripts[]="options[{$key}].id='{$val[id]}';"; endif;
			}
			$this->scripts[]="options[0].selected=true;";
			$this->scripts[]="}";

	}

	###############################################################################
	#	FUNCTION NAME： window_open
	#
	#	DESCRIPTION			開啟新視窗
	# 

	function window_open($url,$winTitle,$option){

		$this->scripts[]="window.open('{$url}','{$winTitle}','{$option}');"; 

	}


	###############################################################################
	#	FUNCTION NAME： window_close
	#
	#	DESCRIPTION			關閉視窗
	# 

	function window_close($winName="window"){

		$this->scripts[]="{$winName}.close();"; 

	}

	###############################################################################
	#	FUNCTION NAME： jsdie
	#
	#	DESCRIPTION			終止程式
	# 

	function jsdie($msg=array()){

		$this->alert($msg);
		$this->run();
		exit;
		

	}


} //end of class declaration


?>
