<?php 

/*
 *
 *	程式名稱：	系統使用者資料表 [sys_user] DB設定檔
 *	檔案名稱：	config.sys_user.php
 *	版　　本：	1.0.0.
 *	作　　者：	Hsiao-Chuan Huang <dolly@price.com.tw>, Gilbert Chiao <gilbert@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2005.05.24.
 *	更新日期：	2005.05.24.
 *	說　　明：	
 *	版本介紹：	
 *
 */

$tbl_name = _TBL_USER;
$tbl_alias = _TBL_AS_USER;
$tbl_store_name = _TBL_SYS_STORE;
$tbl_store_alias = _TBL_AS_SYS_STORE;


$CFG[SYS_USER_TBL] = array();

// 資料表名稱
$CFG[SYS_USER_TBL][DB_TABLE] = $tbl_name;

// 資料表別名
$CFG[SYS_USER_TBL][TABLE_ALIAS] = $tbl_alias;

// 資料表欄位定義
// * 新增時所需的欄位定義(for db_add function)
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["status"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["level"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["account"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["password"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["store_id"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["name"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["tel"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["mobile"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["email"] = array("CHK" => "AA,B"); 

$CFG[SYS_USER_TBL][DB_COLS_INSERT]["memo"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["create_time"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["create_user"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["modify_time"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["modify_user"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["modify_time2"] = array("CHK" => "AA,B"); 
$CFG[SYS_USER_TBL][DB_COLS_INSERT]["modify_user2"] = array("CHK" => "AA,B"); 

// * 修改時所需的欄位定義(for db_modify function)
$CFG[SYS_USER_TBL][DB_COLS_UPDATE] = $CFG[SYS_USER_TBL][DB_COLS_INSERT];
$CFG[SYS_USER_TBL][DB_COLS_UPDATE_KEY]["id"] = array("CHK" => "AA,!B","MSG" => "你沒有指定資料庫流水號");

// 上層關聯性資料設定
$CFG[SYS_USER_TBL][CLASS_DEF] = array();

// 狀態欄位內容定義
$CFG[SYS_USER_TBL][DB_STATUS_DEF]=array();
$CFG[SYS_USER_TBL][DB_STATUS_DEF][IS_DELETED] = 1;		// 刪除
$CFG[SYS_USER_TBL][DB_STATUS_DEF][IS_LEFT] = 2;				// 離職
$CFG[SYS_USER_TBL][DB_STATUS_DEF][IS_MASTER] = 4;				// 聯盟管理人員 可管理門市，執行聯盟回收相關功能 2006.12.08

// 以下為db_browse function所需額外設定
// * 設定搜尋SQL字串主體
$CFG[SYS_USER_TBL][BROWSE_SQL_TITLE] = "SELECT {$tbl_alias}.*, {$tbl_store_alias}.store_name FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$tbl_store_name} AS {$tbl_store_alias} ON ({$tbl_alias}.store_id={$tbl_store_alias}.id)";
#$CFG[SYS_USER_TBL][BROWSE_SQL_TITLE] = "SELECT {$tbl_alias}.*, {$tbl_store_alias}.store_name FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$tbl_store_name} AS {$tbl_store_alias} ON ({$tbl_alias}.store_id={$tbl_store_alias}.id) WHERE {$tbl_alias}.id>10";


// * 搜尋規則定義
$CFG[SYS_USER_TBL][DB_SEARCH_RULE] = array();
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_id"] = array(					// 編號
		"RULE" => "{$tbl_alias}.id='\$str'",
		"PARM_KEY" => "sr_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_account"] = array(			// 帳號
		"RULE" => "{$tbl_alias}.account='\$str'",
		"PARM_KEY" => "sr_account",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_store_id"] = array(			// 門市
		"RULE" => "{$tbl_alias}.store_id='\$str'",
		"PARM_KEY" => "sr_store_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_name"] = array(			// 姓名
		"RULE" => "{$tbl_alias}.name LIKE '%\$str%'",
		"PARM_KEY" => "sr_name",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_tel"] = array(			// 電話
		"RULE" => "{$tbl_alias}.tel LIKE '%\$str%'",
		"PARM_KEY" => "sr_tel",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_mobile"] = array(			// 手機
		"RULE" => "{$tbl_alias}.mobile LIKE '%\$str%'",
		"PARM_KEY" => "sr_mobile",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_email"] = array(			// Email
		"RULE" => "{$tbl_alias}.email LIKE '%\$str%'",
		"PARM_KEY" => "sr_email",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_level"] = array(			// 權限
		"RULE" => "{$tbl_alias}.level='\$str'",
		"PARM_KEY" => "sr_level",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);



$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_not_deleted"] = array(		// 未刪除
		"RULE" => "{$tbl_alias}.status & 1 =0",
		"PARM_KEY" => "sr_not_deleted",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "1",
		);

$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_is_deleted"] = array(		// 已刪除
		"RULE" => "{$tbl_alias}.status & 1 <>0",
		"PARM_KEY" => "sr_is_deleted",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "1",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_not_left"] = array(		// 未離職
		"RULE" => "{$tbl_alias}.status & 2 =0",
		"PARM_KEY" => "sr_not_left",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "1",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_is_left"] = array(		// 已離職
		"RULE" => "{$tbl_alias}.status & 2 <>0",
		"PARM_KEY" => "sr_is_left",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "1",
		);
$CFG[SYS_USER_TBL][DB_SEARCH_RULE]["sr_is_client"] = array(		// 客戶人員
		"RULE" => "{$tbl_alias}.id>10",
		"PARM_KEY" => "sr_is_client",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "1",
		);


// * 資料管理頁面
$CFG[SYS_USER_TBL][LAYOUT]=array(
	"MAIN"=>"sys_user.main.tpl",			// 主選單
	"BROWSE"=>"sys_user.browse.tpl",		// 瀏　覽
	"ADD"=>"sys_user.edit.tpl",			// 新　增
	"MODIFY"=>"sys_user.edit.tpl",			// 修　改
	"VIEW"=>"sys_user.view.tpl",			// 檢　視	
);

if ($mysql_obj){
	$user_obj = new DB();
	$user_obj->init($mysql_obj, $CFG[SYS_USER_TBL]) OR DIE("系統發生錯誤: 使用者無法初始化!<br>".join("<br>", $user_obj->msg->get(2)));
}

?>