<?php

/*
 *
 *	程式名稱：	獎項類別配額[prize_quota] DB 設定檔
 *	檔案名稱：	config.prize_quota.php
 *	版　　本：	1.0.0.
 *	作　　者：	Jacky Jou <starjou@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2006.12.21
 *	更新日期：
 *	說　　明：
 *	版本介紹：
 *
 */

$tbl_name=_TBL_PRIZE_QUOTA;
$tbl_alias=_TBL_AS_PRIZE_QUOTA;

$tbl_prize_name=_TBL_PRIZE;
$tbl_prize_alias=_TBL_AS_PRIZE;

$tbl_class_name=_TBL_CLASS;
$tbl_class_alias=_TBL_AS_CLASS;

$CFG[PRIZE_QUOTA_TBL] = array();

// 資料表名稱
$CFG[PRIZE_QUOTA_TBL][DB_TABLE] = $tbl_name;

// 資料表別名
$CFG[PRIZE_QUOTA_TBL][TABLE_ALIAS] = $tbl_alias;

// 資料表欄位定義
// * 新增時所需的欄位定義(for db_add function)
$CFG[PRIZE_QUOTA_TBL][DB_COLS_INSERT]["prize_id"] = array("CHK" => "AA,!B","MSG"=>"你沒有指定獎項流水號碼");
$CFG[PRIZE_QUOTA_TBL][DB_COLS_INSERT]["class_id"] = array("CHK" => "AA,!B","MSG"=>"你沒有指定類別流水號");
$CFG[PRIZE_QUOTA_TBL][DB_COLS_INSERT]["quota"] = array("CHK" => "AA,B");	//配額
$CFG[PRIZE_QUOTA_TBL][DB_COLS_INSERT]["status"] = array("CHK" => "AA,B");

$CFG[PRIZE_QUOTA_TBL][DB_COLS_INSERT]["create_time"] = array("CHK" => "AA,B");
$CFG[PRIZE_QUOTA_TBL][DB_COLS_INSERT]["create_user"] = array("CHK" => "AA,B");
$CFG[PRIZE_QUOTA_TBL][DB_COLS_INSERT]["modify_time"] = array("CHK" => "AA,B");
$CFG[PRIZE_QUOTA_TBL][DB_COLS_INSERT]["modify_user"] = array("CHK" => "AA,B");

// * 修改時所需的欄位定義(for db_modify function)
$CFG[PRIZE_QUOTA_TBL][DB_COLS_UPDATE] = $CFG[PRIZE_QUOTA_TBL][DB_COLS_INSERT];
$CFG[PRIZE_QUOTA_TBL][DB_COLS_UPDATE_KEY]["id"] = array("CHK" => "AA,!B","MSG" => "你沒有指定資料庫流水號");

// 上層關聯性資料設定
$CFG[PRIZE_QUOTA_TBL][CLASS_DEF] = array();

// 狀態欄位內容定義
$CFG[PRIZE_QUOTA_TBL][DB_STATUS_DEF]=array();
//$CFG[PRIZE_QUOTA_TBL][DB_STATUS_DEF][IS_DELETED] = 1;				// 刪除
$CFG[PRIZE_QUOTA_TBL][DB_STATUS_DEF][IS_DRAWN] = 16;				// 本類別已抽獎
$CFG[PRIZE_QUOTA_TBL][DB_STATUS_DEF][IS_STAR1] = 128;				// 四星彩頭獎

// 以下為db_browse function所需額外設定
// * 設定搜尋SQL字串主體
$CFG[PRIZE_QUOTA_TBL][BROWSE_SQL_TITLE] = "SELECT {$tbl_alias}.* FROM {$tbl_name} AS {$tbl_alias}";

// BROWSE_SQL_TITLE_CURRENT_ITEM 用的 status 是 config.prize.php 的 status，因此將 status_ary 的定義比照 config.prize.php 的定義。
$CFG[PRIZE_QUOTA_TBL][BROWSE_SQL_TITLE_CURRENT_ITEM] = "SELECT {$tbl_alias}.id AS quota_id, {$tbl_alias}.quota, {$tbl_alias}.class_id, {$tbl_prize_alias}.*, {$tbl_class_alias}.class_name FROM {$tbl_name} AS {$tbl_alias} LEFT JOIN {$tbl_prize_name} AS {$tbl_prize_alias} ON {$tbl_alias}.prize_id = {$tbl_prize_alias}.id LEFT JOIN {$tbl_class_name} AS {$tbl_class_alias} ON {$tbl_alias}.class_id = {$tbl_class_alias}.id";
// * 搜尋規則定義
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE] = array();
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_id"] = array(		# 編號
		"RULE" => "{$tbl_alias}.id='\$str'",
		"PARM_KEY" => "sr_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_prize_id"] = array(		# 獎項編號
		"RULE" => "{$tbl_alias}.prize_id='\$str'",
		"PARM_KEY" => "sr_prize_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_project_id"] = array(		# 專案編號
		"RULE" => "{$tbl_prize_alias}.project_id='\$str'",
		"PARM_KEY" => "sr_project_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_class_id"] = array(		# 配額類別編號
		"RULE" => "{$tbl_alias}.class_id='\$str'",
		"PARM_KEY" => "sr_class_id",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_not_deleted"] = array(		# 未刪除
		"RULE" => "{$tbl_alias}.status & 1 = 0",
		"PARM_KEY" => "sr_not_deleted",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_not_drawn"] = array(		# 未抽獎
		"RULE" => "{$tbl_alias}.status & 16 = 0",
		"PARM_KEY" => "sr_not_drawn",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_prize_not_hide"] = array(		# 獎項非隱藏
		"RULE" => "{$tbl_prize_alias}.status & 32 = 0",
		"PARM_KEY" => "sr_prize_not_hide",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_prize_not_star234"] = array(		# 非為四星彩234獎
		"RULE" => "{$tbl_prize_alias}.status & 256 = 0 AND {$tbl_prize_alias}.status & 512 = 0 AND {$tbl_prize_alias}.status & 1024 = 0 ",
		"PARM_KEY" => "sr_prize_not_star234",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_prize_is_quota"] = array(		# 有配額
		"RULE" => "{$tbl_prize_alias}.status & 2 <> 0",
		"PARM_KEY" => "sr_prize_is_quota",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_prize_draw_once"] = array(		# 一次抽完
		"RULE" => "{$tbl_prize_alias}.status & 2048 <> 0",
		"PARM_KEY" => "sr_prize_draw_once",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_prize_not_draw_once"] = array(		# 非一次抽完
		"RULE" => "{$tbl_prize_alias}.status & 2048 = 0",
		"PARM_KEY" => "sr_prize_not_draw_once",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);
$CFG[PRIZE_QUOTA_TBL][DB_SEARCH_RULE]["sr_not_zero"] = array(		# 配額不為0
		"RULE" => "{$tbl_alias}.quota > 0",
		"PARM_KEY" => "sr_not_zero",
		"PARM_VAL" => "\$str",
		"OPTION"	=> "T",
		);



// * 資料管理頁面
//$CFG[PRIZE_QUOTA_TBL][LAYOUT] = array(
//	"MAIN"=>".main.tpl",			// 主選單
//	"BROWSE"=>".browse.tpl",		// 瀏　覽
//	"ADD"=>".edit.tpl",			// 新　增
//	"MODIFY"=>".edit.tpl",			// 修　改
//	"VIEW"=>".view.tpl",			// 檢　視
//);



if ($mysql_obj){
	$przqt_obj = new DB();
	$przqt_obj->init($mysql_obj, $CFG[PRIZE_QUOTA_TBL]) OR DIE("系統發生錯誤: 獎項類別配額資料庫物件初始化失敗<br>".join("<br>", $przqt_obj->msg->get(2)));
}


