<?php
/**
 *
 *	程式名稱：	專案管理
 *	檔案名稱：	module.project.php
 *	版　　本：	1.0.0.
 *	作　　者：	Jacky Jou<starjou@price.com.tw>
 *				Gilbert Chiao <gilbert@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2006.12.22.
 *	更新日期：	2007.12.11.
 *	說　　明：
 *
 */


// ===== 初始化物件
require_once _DIR_LIB_DBCFG . 'config.project.php';

require_once _DIR_LIB_FUNCTION . 'JSescape.php';
require_once _DIR_LIB_CLASS . 'class.Javascript.php';

// ===== 模組化參數設定
$cm_title = '專案';
$cm_func = 'project';
$cm_func2 = 'PROJECT';
$cm_obj = $prj_obj;
$op[cm_func] = $cm_func;
$op[cm_title] = $cm_title;
$op[cm_url] = $SELF;

// * 圖檔上傳所需設定
$cm_image_dir = _DIR_UPLOAD . 'project_img/';			// 圖檔存放資料夾
$cm_image_url = _URL_UPLOAD . 'project_img/';			// 圖檔資料夾URL

# 除錯設定
$op[cm_debug] = false;
$layout->assign($op);


// ===== 常用變數
$return = $SELF . '?PHP_dType=' . $cm_func;
$action = $_REQUEST['PHP_action'];

$layout->assign($op);

// ===== 主程式
switch($action){
#########################
#	@ 主選單
#########################
	default:
	case 'main':
		// 未結案專案清單
		$tmp_argv=array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_not_closed] = 1;
		$prj_list = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
		$op[prj_list] = $prj_list[pds];

		$layout->display($cm_obj->CFG[LAYOUT]['MAIN'], $op);
		break;



#########################
#	@ 新增
#########################
	case 'add':
		// =====初始化資料
		$op = array();

		// * 讀取儲存失敗的暫存資料
		if ($data=$GSID[$cm_func2."_ADD_BUF"]) {
			unset($GSID[$cm_func2."_ADD_BUF"]);
		} else {
			$data=array();
			$data['start_time'] = date("Y-m-d 00:00:00");
			$data['end_time'] = date("Y-m-d 23:59:59");
		}
		$op[data]=$data;

		// ===== 顯示畫面
		$op[cm_action] = "submit_add";
		$op[onloadJavascript] = "document.form1.elements['input[name]'].focus();";

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][ADD], $op);
		break;



#########################
#	@ 新增儲存
#########################
	case 'submit_add':
		// ===== 輸入資料處理
		$tmp_argv = array();
		$tmp_argv = $RQT[input];
		$tmp_argv[status_ary][IS_EXPORTED]=$tmp_argv[status_ary][IS_EXPORTED]?1:0;
		$tmp_argv[status_ary][IS_CLOSED]=$tmp_argv[status_ary][IS_CLOSED]?1:0;
		$tmp_argv[status_ary][IS_NEED_PRESENT]=$tmp_argv[status_ary][IS_NEED_PRESENT]?1:0;

		// * 建檔資訊
		$tmp_argv[create_time]=date("Y-m-d H:i:s");
		$tmp_argv[create_user]=$GSID[UserInfo][account];
		$GSID[$cm_func2."_ADD_BUF"]=$tmp_argv;

		// ===== 資料庫存取
		$cm_obj->db_add($tmp_argv) OR gotoUrl($return.'&PHP_action=add', "新增{$cm_title}進資料庫時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0002', $cm_obj->msg->get(2));
		$new_id=$cm_obj->get_new_id();


		// 上傳圖檔
		if ($_FILES[PHP_project_pic][tmp_name]){
			$image_name = $new_id.".".fileext($_FILES[PHP_project_pic][name]);
			copy ($_FILES[PHP_project_pic][tmp_name], $cm_image_dir.$image_name);
			$tmp_argv = array();
			$tmp_argv[id] = $new_id;
			$tmp_argv[image] = $cm_image_url.$image_name;
			$cm_obj->db_modify($tmp_argv);
		}

		// ===== 回傳結果
		unset($GSID[$cm_func2."_ADD_BUF"]);
		if (!$cm_obj->msg->length()) {
			gotoUrl($return."&PHP_action=view&PHP_id={$new_id}", "{$cm_title}資料新增成功!", 2);
		} else {
			$tmp_msg=array("新增{$cm_title}資料時發生錯誤!");
			$tmp_msg=array_merge($tmp_msg, $cm_obj->msg->get(2));
			gotoUrl($return."&PHP_action=view&PHP_id={$new_id}", $tmp_msg, 5, array(), _ER_USER_NOTICE, 'ER_PROJECT_0013', $tmp_msg);
		}

		break;



#########################
#	@ 修改
#########################
	case 'modify':
		// ===== 輸入資料確認
		$RQT[PHP_id] OR gotoUrl($return, "無法讀取{$cm_title}資料!", 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0003', array("無法讀取{$cm_title}資料!", "使用者未指定資料編號!"));

		// ===== 資料讀取
		// * Case1: 儲存失敗時的暫存資料優先
		$data=$GSID[$cm_func2.'_MODIFY_BUF'];

		// * Case2: 資料庫存取
		if (!$data) {
			$data = $cm_obj->get_db_detail($RQT[PHP_id]) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0004', $cm_obj->msg->get(2));
		} else {
			unset($GSID[$cm_func2."_MODIFY_BUF"]);
		}

		// ===== 資料存取狀態確認
		if ($data[status_ary][IS_DELETED]) {
			gotoUrl($return, array("{$cm_title}資料存取失敗!", "原因：您所指定的{$cm_title}資料已經刪除!!"), 5, array(), _ER_USER_NOTICE, 'ER_PROJECT_0005', array("{$cm_title}資料存取失敗", "原因：使用者所指定的資料已經刪除!"));
		}

		// ===== 顯示頁面
		$op[data] = $data;
		$op[cm_action]="submit_modify";

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][MODIFY], $op);
		break;



#########################
#	@ 修改儲存
#########################
	case 'submit_modify':
		// ===== 輸入資料處理
		$tmp_argv = array();
		$tmp_argv = $RQT[input];
		$tmp_argv[status_ary][IS_EXPORTED]=$tmp_argv[status_ary][IS_EXPORTED]?1:0;
		$tmp_argv[status_ary][IS_CLOSED]=$tmp_argv[status_ary][IS_CLOSED]?1:0;
		$tmp_argv[status_ary][IS_NEED_PRESENT]=$tmp_argv[status_ary][IS_NEED_PRESENT]?1:0;
		$GSID[$cm_func2."_MODIFY_BUF"]=$tmp_argv;

		// * 資料狀態確認
		$data=$cm_obj->get_db_detail($tmp_argv[id]) OR gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", "檢查資料狀態時發生錯誤!", 3, array(), _ER_USER_WARNING, 'ER_PROJECT_0006', $cm_obj->msg->get(2));
		if ($data[status_ary][IS_DELETED]) {
			gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", array("錯誤! 無法更新{$cm_title}資料!", " 原因, 您所指定的資料已經被刪除!"), 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0007', array("無法更新{$cm_title}資料", "資料已經被刪除!"));
		}

		if ($tmp_argv[password] && ($tmp_argv[old_password] != $data[password])){
			unset($tmp_argv[password]);
			$tmp_msg=array("舊密碼錯誤，密碼變更失敗!");
		}
		if (!$tmp_argv[password]){
			unset($tmp_argv[password]);
		}

		// * 取得更新記錄
		$tmp_argv=array_merge($tmp_argv, createUpdateLog($data, $GSID[UserInfo][account]));

		// 刪除舊圖檔
		if ($RQT[remove_image] || $_FILES[PHP_project_pic][tmp_name]) {
			unlink($data[image]);
			$tmp_argv[image] = "";
		}
		// 上傳圖檔
		if ($_FILES[PHP_project_pic][tmp_name]) {
			$image_name = $tmp_argv[id].".".fileext($_FILES[PHP_project_pic][name]);
			copy ($_FILES[PHP_project_pic][tmp_name], $cm_image_dir.$image_name);
			$tmp_argv[image] = $cm_image_url.$image_name;
		}

		// ===== 資料庫存取
		$flag0 = $cm_obj->db_modify($tmp_argv) OR gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", "儲存{$cm_title}進資料庫時發生錯誤!!", 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0008', $cm_obj->msg->get(2));

		// ===== 回傳結果
		unset($GSID[$cm_func2."_MODIFY_BUF"]);

		if (count($tmp_msg)) {
			$tmp_msg=array_merge( "更新{$cm_title}資料時發生錯誤!",$tmp_msg);
			$tmp_msg=array_merge($tmp_msg, $cm_obj->msg->get(2));
			gotoUrl($return."&PHP_action=view&PHP_id={$tmp_argv[id]}", $tmp_msg, 2, array(), _ER_USER_NOTICE, "ER_PROJECT_0014", $tmp_msg);
		} else {
			// 若為目前工作 Project，更新 Session
			if ($tmp_argv[id] == $_SESSION['ProjectInfo']['id']){
				$_SESSION['ProjectInfo'] = $tmp_argv;
			}
			gotoUrl($return."&PHP_action=view&PHP_id={$tmp_argv[id]}", "{$cm_title}資料更新成功!", 2);
		}
		break;



#########################
#	@ 檢視
#########################
	case 'view':
		$cm_id = $RQT[PHP_id];

		if (!$cm_id) {
			gotoUrl($return, '未指定專案編號', 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', array('未指定資料編號'));
		}

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_id] = $cm_id;

		$cm_list = $cm_obj->db_browse('LIST_ALL', $tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $cm_obj->msg->get(2));

		$op[data] = $cm_list[pds][0];


		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][VIEW], $op);
		break;



#########################
#	@ 資料瀏覽及搜尋
#########################
	case 'browse':
		// ===== DB物件分頁設定
		$cm_obj->CFG[ROW_PER_PAGE] = 30;
		if ($RQT[PHP_sr_page]) {
			$RQT[PHP_sr_startno] = ($RQT[PHP_sr_page] - 1) * $cm_obj->CFG[ROW_PER_PAGE];
		}

		// ===== 設定排序
		$cm_obj->CFG[DB_COLS_SORT] = "id";

		// ===== 執行搜尋
		$RQT[sr_not_deleted] = 1;
		$datas = $cm_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $cm_obj->msg->get(2));

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][BROWSE], $datas);
		break;



#########################
#	@ 選擇專案
#########################
	case 'choose':

		$cm_id = $RQT[PHP_id];

		if (!$cm_id) {
			gotoUrl($return, '未指定專案編號', 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', array('未指定資料編號'));
		}

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_id] = $cm_id;

		$op[data] = $cm_obj->get_db_detail($cm_id) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $cm_obj->msg->get(2));

		if ($op[data][status_ary][IS_DELETE]){
			gotoUrl($return."&PHP_action=browse&sr_not_closed=1", '所選擇專案已刪除，無法選擇!', 3);
		}
		if ($op[data][status_ary][IS_CLOSED]){
			gotoUrl($return."&PHP_action=browse&sr_not_closed=1", '所選擇專案已結案，無法選擇!', 3);
		}

		$op[cm_action]="submit_choose";

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][CHOOSE], $op);
		// 結案專案無法選擇

		// 輸入專案密碼

		break;



#########################
#	@ 確定選擇專案
#########################
	case 'submit_choose':

		$cm_id = $RQT[PHP_id];

		if (!$cm_id) {
			gotoUrl($return, '未指定專案編號', 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', array('未指定資料編號'));
		}

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_id] = $cm_id;

		$op[data] = $cm_obj->get_db_detail($cm_id) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $cm_obj->msg->get(2));

		if ($op[data][status_ary][IS_DELETE]) {
			gotoUrl($return."&PHP_action=browse&sr_not_closed=1", '所選擇專案已刪除，無法選擇!', 3);
		}
		if ($op[data][status_ary][IS_CLOSED]) {
			gotoUrl($return."&PHP_action=browse&sr_not_closed=1", '所選擇專案已結案，無法選擇!', 3);
		}
		if ($op[data][password]!=$RQT[password]) {
			gotoUrl($return."&PHP_action=choose&PHP_id={$cm_id}", '密碼錯誤!!', 3);
		}

		// 設定目前執行專案
		$_SESSION[ProjectInfo] = $op[data];
		gotoUrl("main.php");

		break;



#########################
#	@ 結案
#########################
	case 'submit_close':

		// * 資料狀態確認
		$data=$cm_obj->get_db_detail($RQT[PHP_id]) OR gotoUrl($return."&PHP_action=modify&PHP_id={$RQT[PHP_id]}", "檢查資料狀態時發生錯誤!", 3, array(), _ER_USER_WARNING, 'ER_PROJECT_0006', $cm_obj->msg->get(2));
		if ($data[status_ary][IS_DELETED]) {
			gotoUrl($return."&PHP_action=modify&PHP_id={$RQT[PHP_id]}", array("錯誤! 無法更新{$cm_title}資料!", " 原因, 您所指定的資料已經被刪除!"), 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0007', array("無法更新{$cm_title}資料", "資料已經被刪除!"));
		}

		// 已經結案專案無法重覆結案
		if ($data[status_ary][IS_CLOSED]) {
			gotoUrl($return."&PHP_action=modify&PHP_id={$RQT[PHP_id]}", array("錯誤! 無法重覆結案本{$cm_title}!", " 原因, 您所指定的資料已經結案!"), 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0007', array("無法重覆結案{$cm_title}資料", "資料已經被結案!"));
		}

		// * 取得更新記錄
		$tmp_argv = array("id"=>$data[id]);
		$tmp_argv=array_merge($tmp_argv, createUpdateLog($data, $GSID[UserInfo][account]));
		$tmp_argv[status_ary][IS_CLOSED] = 1;

		// ===== 資料庫存取
		$flag0 = $cm_obj->db_modify($tmp_argv) OR gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", "儲存{$cm_title}進資料庫時發生錯誤!!", 3, array(), _ER_USER_ERROR, 'ER_PROJECT_0008', $cm_obj->msg->get(2));

		// ===== 回傳結果
		if (!$cm_obj->msg->length()) {
			gotoUrl($return."&PHP_action=view&PHP_id={$tmp_argv[id]}", "{$cm_title}資料更新成功!", 2);
		} else {
			$tmp_msg=array("更新{$cm_title}資料時發生錯誤!");
			$tmp_msg=array_merge($tmp_msg, $cm_obj->msg->get(2));
			gotoUrl($return."&PHP_action=view&PHP_id={$tmp_argv[id]}", $tmp_msg, 2, array(), _ER_USER_NOTICE, "ER_PROJECT_0014", $tmp_msg);
		}
		break;



#########################
#	@ 匯出
#########################
#	case 'export':
#		gotoUrl($return, "本功能尚未完成！", 3);
#		break;



#########################
#	@ 刪除
#########################
	case "submit_delete":
		// ===== 輸入資料確認
		$RQT[PHP_id] OR gotoUrl($return, array("刪除{$cm_title}時發生錯誤!!", "您沒有指定{$cm_title}資料編號"),  5, array(), _ER_USER_NOTICE, 'ER_PROJECT_0009', array("刪除{$cm_title}時發生錯誤!!", "使用者未指定{$cm_title}資料編號!"));

		// ===== 資料狀態確認
		$data = $cm_obj->get_db_detail($RQT[PHP_id]) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0010', $cm_obj->msg->get(2));
		if($data[status_ary][IS_DELETED]):
			gotoUrl($return, array("您所指定的資料已經刪除!", "已刪除資料不可重複刪除!"), 3, array(), _ER_USER_NOTICE, 'ER_PROJECT_0011', array("已刪除資料不可重複刪除!"));
		endif;

		// ===== 資料庫存取
		$tmp_argv = array("id"=>$RQT[PHP_id]);
		$tmp_argv[status_ary]=array("IS_DELETED"=>1);
		$tmp_argv[modify_time]=date("Y-m-d H:i:s");
		$tmp_argv[modify_user]=$GSID[UserInfo][account];

		$cm_obj->db_modify($tmp_argv) OR gotoUrl($return."&PHP_action=modify&PHP_id={$RQT[PHP_id]}", "刪除{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0012', $cm_obj->msg->get(2));

		// ===== 回傳結果
		gotoUrl($return, "{$cm_title}資料刪除成功! ", 2);

		break;

#########################
#	@ 簡訊賀詞設定
#########################
	case "cong_msg":
		// ===== 資料讀取
		// * Case1: 儲存失敗時的暫存資料優先
		$data=$GSID[$cm_func2.'_MODIFY_BUF'];

		// * Case2: 資料庫存取
		if (!$data) {
			$data = $cm_obj->get_db_detail($ProjectInfo[id]) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0004', $cm_obj->msg->get(2));
		} else {
			unset($GSID[$cm_func2."_MODIFY_BUF"]);
		}


		// ===== 資料存取狀態確認
		if ($data[status_ary][IS_DELETED]) {
			gotoUrl($return, array("{$cm_title}資料存取失敗!", "原因：您所指定的{$cm_title}資料已經刪除!!"), 5, array(), _ER_USER_NOTICE, 'ER_MEMBER_0005', array("{$cm_title}資料存取失敗", "原因：使用者所指定的資料已經刪除!"));
		}

		$op[data] = $data;
		$op[cm_action] = "submit_cong_msg";
		$layout->display($cm_obj->CFG[LAYOUT][CONG_MSG], $op);
		break;



#########################
#	@ 儲存簡訊賀詞設定
#########################
	case "submit_cong_msg":
		$RQT[input][id] = $ProjectInfo[id];
		$RQT[input][cong_msg] = trim($RQT[input][cong_msg]);
		$cm_obj->db_modify($RQT[input]);
		$ProjectInfo[cong_msg] = $RQT[input][cong_msg];
		gotoUrl($return."&PHP_action=view&PHP_id={$RQT[input][id]}", $tmp_msg, 2, array(), _ER_USER_NOTICE, "ER_PROJECT_0014", $tmp_msg);
		break;
}



?>