<?php

/**
 *	程式名稱：	出席管理
 *	檔案名稱：	module.present.php
 *	版　　本：	1.0.0.
 *	作　　者：	Jacky Jou<starjou@price.com.tw>
 *				Gilbert Chiao <gilbert@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2006.12.22.
 *	更新日期：	2007.12.11.
 *	說　　明：
 */


// ===== 初始化物件
require_once _DIR_LIB_DBCFG . 'config.member.php';
require_once _DIR_LIB_FUNCTION . 'JSescape.php';
require_once _DIR_LIB_CLASS . 'class.Javascript.php';



$ProjectInfo = $_SESSION['ProjectInfo'];



// ===== 模組化參數設定
$cm_title = '出席';
$cm_func = 'present';
$cm_func2 = 'PRESENT';
$cm_obj = $member_obj;
$op[cm_func] = $cm_func;
$op[cm_title] = $cm_title;
$op[cm_url] = $SELF;

# 除錯設定
$op[cm_debug] = false;
$layout->assign($op);


// ===== 常用變數
$return = $SELF . '?PHP_dType=' . $cm_func;
$action = $_REQUEST['PHP_action'];
$layout->assign($op);



// ===== 主程式
switch($action) {
#########################
#	@ 主選單
#########################
	default:
	case 'main':
		$op[is_run] = ($ProjectInfo[status_ary][IS_RUN]) ? 1 : 0;

		// ============= add 2016
		$op['fetch_start_time'] = date('Y-m-d').'T08:00:00.0000';

		$layout->display($cm_obj->CFG[LAYOUT]['PRESENT'], $op);
		break;



#########################
#	@ 抽獎號碼查詢搜尋
#########################
	case 'query_lottery_no':
		$RQT[sr_not_deleted] = 1;
		$RQT[sr_project_id] = $ProjectInfo[id];
		$datas = $cm_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_PROJECT_0001', $cm_obj->msg->get(2));
		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][LOTTERY_NO_QUERY], $datas);
		break;



#########################
#	@ 設定出席
#########################
	case 'submit_present':
		$cm_lottery_no = $RQT[PHP_lottery_no];

		if (!$cm_lottery_no)
			exit;

		$JS = new Javascript();

		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_lottery_no] = $RQT[PHP_lottery_no];
		$tmp_argv[sr_not_deleted] = 1;
		$datas = $cm_obj->db_browse("LIST_ALL",$tmp_argv);

		if(count($datas[pds]) == 0){
			$JS->alert("無此抽獎號碼");
			$JS->run();
			exit;
		}
		elseif(count($datas[pds]) > 1){
			$JS->alert("此抽獎號碼查詢結果多於一筆，請重新輸入完整精確之抽獎號碼");
			$JS->run();
			exit;
		}
		else{
			if($datas[pds][0][status_ary][IS_PRESENT]) {
				$JS->alert("此抽獎號碼原先已被設為出席。");
				$JS->run();
				exit;
			}
		}

		$tmp_argv = array();
		$tmp_argv[id] = $datas[pds][0][id];
		$tmp_argv[status_ary][IS_PRESENT] = 1;
		$tmp_argv[status_ary][IS_MANUAL_PRESENT] = 1;
		$tmp_argv[manual_present_time] = date("Y-m-d H:i:s");
		$flag0 = $cm_obj->db_modify($tmp_argv) OR $JS->alert("更新出席狀態失敗！".join($cm_obj->msg->get(2) )) ;
		if($flag0){
			$JS->alert($RQT[PHP_lottery_no]." 已設定為出席。");
		}
		$JS->run();

		break;



#########################
#	@ 匯入出席資料
#########################
	case 'import':

		$file_tmp = "upload/tmp_present.csv";

		#檔案上傳
		if(file_exists($file_tmp)){
			unlink($file_tmp);
		}
		copy($_FILES['upload_file']['tmp_name'], $file_tmp);

		$fp = fopen($file_tmp, "r");

		$tmp_msg = array();

		$incomplete = array();
		while ($data = fgetcsv ($fp, 65534, ",")) {
			if(!empty($data[0])){
				$tmp_argv = array();
				$tmp_argv[sr_lottery_no_exact] = $data[0];
				$tmp_argv[sr_project_id] = $ProjectInfo[id];
				$tmp_member = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
				$tmp_member = $tmp_member[pds][0];
				if((!empty($tmp_member)) && (!$tmp_member[status_ary][IS_DELETED]) && $tmp_member[project_id] = $ProjectInfo[id]){
					//修改出席狀態
					$tmp_argv[id] = $tmp_member[id];
					$tmp_argv[status_ary][IS_PRESENT] = 1;
					$tmp_argv[modify_time] = date("Y-m-d H:i:s");
					$tmp_argv[modify_user] = $GSID[UserInfo][account];
					$flag0 = $cm_obj->db_modify($tmp_argv);
					if (!$flag0) {
						$tmp_msg[] = "新增{$cm_title}資料時發生錯誤!";
						$tmp_msg[] = $cm_obj->msg->get(2);
					}
				}
				else{
					$incomplete[] = $data[0];
				}
			}
		}
		fclose ($fp);

		// ===== 回傳結果
		if ((!$cm_obj->msg->length()) && count($tmp_msg) == 0) {
			if ((count($incomplete) == 0)) {
				gotoUrl($return."&PHP_action=main", "{$cm_title}資料匯入成功!", 2 );
			}
			else {
				$incomplete = array_merge("{$cm_title}資料匯入完成，部份資料未匯入!", $incomplete);
				gotoUrl($return."&PHP_action=main",$incomplete , 10, array(), _ER_USER_NOTICE, 'ER_MEMBER_0030', $incomplete );
			}
		} else {
			if (count($incomplete)) {
				$tmp_msg = array_merge("{$cm_title}資料匯入完成，部份資料未匯入!", $incomplete, $tmp_msg);
			}
			gotoUrl($return."&PHP_action=main", $tmp_msg, 60, array(), _ER_USER_NOTICE, 'ER_MEMBER_0031', $tmp_msg);
		}
		break;



#########################
#	@ 批次設定出席
#########################
	case 'submit_batch_present':
		$q_str = "UPDATE member SET status = status | 2 WHERE status & 1 = 0 AND project_id = " . $ProjectInfo[id];
		$cm_obj->sql->query($q_str);

		echo "<script charset='utf-8' type='text/javascript'>alert('已設定所有參加人員為出席！')</script>";
		/*
		$JS = new Javascript();
		$JS->alert("已設定所有參加人員為出席！");
		$JS->run();
		*/
		break;
// ============= add 2016
/**
 * 匯入香信生活頻道之簽到人員名單
 */
case 'fetch_signin':
	// input parameters
	$start_time = trim($_POST['start_time']);
	$max_record_num = (int) $_POST['max_record_num'];
	$activity_id = 1;
	
	// request content
	$request = <<<EOT
<xml>
	<activity_id>{$activity_id}</activity_id>
	<start_time>{$start_time}</start_time>
	<max_record_num>{$max_record_num}</max_record_num>
</xml>
EOT;

	//$request_url = 'http://icivetapps.foxconn.com.tw/SaaS/000001/ClubApi/ExportSignRec';
	

	// send request
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $request_url);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: text/plain'));
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	$response = curl_exec($ch); 
	curl_exec($ch);
	curl_close($ch);

	// record request & response to file: ./upload/signin_[time].log
	$fp = fopen('./upload/signin_' . time() . '.log', 'w+');
	fwrite($fp, "Request:\r\n");
	fwrite($fp, $request."\r\n");
	fwrite($fp, "Response:\r\n");
	fwrite($fp, $response."\r\n");
	fclose($fp);
	
	// parse response
	$data = xml_parse_into_assoc($response);
	$person_num = 0;
	if (isset($data['person_num'])) {
		$person_num = (int) $data['person_num'];
	}
	if ($person_num > 0) {
		if (isset($data['persons']) && is_array($data['persons'])) {
			foreach ($data['persons'] AS $empid) {
				$lottery_no = trim($empid);				
				if (!$lottery_no) {
					continue;
				}

				// update member status
				$q_str = sprintf(
					"UPDATE member SET status = status | 2 WHERE status & 1 = 0 AND project_id = %d AND lottery_no='%s'",
					$ProjectInfo[id],
					$lottery_no
				);
				$cm_obj->sql->query($q_str);
			}
		}
	}
	
	$JS = new Javascript();
	$JS->alert('sign-in person number: ' . $person_num);
	$JS->run();
	break;
// ============= End: add 2016



#########################
#	@ 批次清除出席
#########################
	case 'submit_batch_not_present':
		$q_str = "UPDATE member SET status = status & ~2 WHERE status & 1 = 0 AND project_id = " . $ProjectInfo[id];
		$cm_obj->sql->query($q_str);

		echo "<script charset='utf-8' type='text/javascript'>alert('已設定所有參加人員為未出席！')</script>";
		/*
		$JS = new Javascript();
		$JS->alert("已設定所有參加人員為未出席！");
		$JS->run();
		*/
		break;



#########################
#	@ 資料瀏覽及搜尋
#########################
	case 'manual_present_browse':
		$cm_obj->CFG[ROW_PER_PAGE] = 30;
		if ($RQT[PHP_sr_page])
			$RQT[PHP_sr_startno] = ($RQT[PHP_sr_page] - 1) * $cm_obj->CFG[ROW_PER_PAGE];

		// ===== 設定要排序的欄位
/*		$sorttypes = array(
		"id"=>"MBR.id",
		"lottery_no"=>"MBR.lottery_no",
		"department"=>"MBR.department",
		"family_name"=>"MBR.family_name",
		"family_code"=>"MBR.family_code",
		"name"=>"name",
		);

		//設定查詢資料時之排序欄位/預設排序欄位
		$sorttype = $RQT[PHP_sr_sorttype]? $RQT[PHP_sr_sorttype]: "uid";
		foreach($sorttypes AS $key=>$val){
			$sortstr = ($sorttype == "d{$key}")? "{$val} DESC": $sortstr;
			$sortstr = ($sorttype == "u{$key}")? $val: $sortstr;
		}
		$cm_obj->CFG[DB_COLS_SORT] = $sortstr;
		$cm_obj->CFG[DB_SORT_TYPE] = $sorttype;*/

		$cm_obj->CFG[DB_COLS_SORT] = "manual_present_time";

		// ===== 執行搜尋
		$RQT[sr_not_deleted] = 1;
		$RQT[sr_present] = 1;
		$RQT[sr_manual_present] = 1;
		$RQT[sr_project_id] = $ProjectInfo[id];
		//echo "<pre>"; print_r($RQT);

//		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_EXPORT];
		//$cm_obj->debug=true;
		$datas = $cm_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0001', $cm_obj->msg->get(2));

		//echo "<pre>";print_r($datas);

		// ===== 產生各種排序所需的鏈結
		// 這部份要在 db_browse 之後做，且 $op 必須是 db_browse 回傳之物件。若使用其它變數名稱則改為其它變數。
/*		foreach ($sorttypes AS $key=>$val){
			$im = "<a href='{$datas[cgistr_get]}&PHP_sr_sorttype=d{$key}'><img src=\"images/down.gif\" width=13 height=13 border=0 align=absmiddle></a>";
			$datas["im".$key] = ($datas[sorttype]=="d{$key}")?"<a href='{$datas[cgistr_get]}&PHP_sr_sorttype=u{$key}'><img src=\"images/downy.gif\" width=13 height=13 border=0 align=absmiddle></a>":$im;
			$datas["im".$key]=($datas[sorttype]=="u{$key}")?"<a href='{$datas[cgistr_get]}&PHP_sr_sorttype=d{$key}'><img src=\"images/upy.gif\" width=13 height=13 border=0 align=absmiddle></a>":$datas["im".$key];
		} */

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][MANUAL_PRESENT_BROWSE], $datas);
		break;



#########################
#	@ 資料瀏覽及搜尋
#########################
	case 'present_statistic':
		$op[print_time] = date("Y-m-d H:i", time());

		require_once _DIR_LIB_DBCFG. 'config.class.php';
		$class_obj->CFG[DB_COLS_SORT] = "id";
		$op[class_list] = $class_obj->db_browse("LIST_ALL", array("sr_project_id"=>$ProjectInfo[id]));

		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_PRESENT_STATISTIC];
		$cm_obj->CFG[DB_COLS_GROUP] = " business_group " ;
		$tmp_argv = array();
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_not_deleted] = 1;
		$op[datas] = $cm_obj->db_browse("LIST_ALL", $tmp_argv) ;
		if(count($op[datas][pds])){
			foreach($op[datas][pds] as $key=>$val) {
				$cm_obj->CFG[DB_COLS_SORT] = "class_id";
				$cm_obj->CFG[DB_COLS_GROUP] = "business_group, class_id" ;
				$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_PRESENT_STATISTIC_CLASS];

				if ($val[business_group]) {
					$tmp_argv[sr_business_group] = $val[business_group];
					unset($tmp_argv[sr_business_group_empty]);
				}
				else {
					$tmp_argv[sr_business_group_empty] = 1;
					unset($tmp_argv[sr_business_group]);
				}

				unset($tmp_argv[sr_present]);
				$tmp_class_total = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
				$tmp_argv[sr_present] = 1;
				$tmp_class_present = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
				$cnt = count($op[class_list][pds]);
				for($i = 0; $i < $cnt; $i++){
					$op[datas][pds][$key][class_statistic][$i]=array("class_total"=>0, "class_id"=>$op[class_list][pds][$i][id]);
					foreach($tmp_class_total[pds] as $total_cnt){
						if ($total_cnt[class_id] == $op[class_list][pds][$i][id]){
							$op[datas][pds][$key][class_statistic][$i][class_total]=$total_cnt[cnt];
//							$op[datas][pds][$key][class_statistic][$i]=array("class_total"=>$tmp_class_total[pds][$i][cnt]);
							//echo $op[datas][pds][$key][class_statistic][$i][class_total]." ".$total_cnt[cnt] ." ". $total_cnt[class_id] ." ". $class_val[id] . "<br>";
							break;
						}
					}
					//	echo $op[datas][pds][$key][class_statistic][$i][class_total]." ".$total_cnt[cnt] ." ". $total_cnt[class_id] ." ". $class_val[id] . "<br>";
					foreach($tmp_class_present[pds] as $present){
						if ($present[class_id] == $op[datas][pds][$key][class_statistic][$i][class_id]){
							$op[datas][pds][$key][class_statistic][$i]['present'] = $present[cnt];
							break;
						}
					}
				}
				$cm_obj->CFG[DB_COLS_GROUP] = "business_group" ;
				$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_PRESENT_STATISTIC];
				$tmp_business_group = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
				$op[datas][pds][$key][present_cnt] = $tmp_business_group[pds][0][cnt];
				if ($op[datas][pds][$key][cnt]) {
					$op[datas][pds][$key][percent] = $op[datas][pds][$key][present_cnt] / $op[datas][pds][$key][cnt] * 100;
				}
				else{
					$op[datas][pds][$key][percent]  = 0;
				}
			}
		}
		$tmp_argv = array();
		$tmp_argv[sr_project_id] = $ProjectInfo[id];
		$tmp_argv[sr_not_deleted] = 1;
		$cm_obj->CFG[DB_COLS_SORT] = "class_id";
		$cm_obj->CFG[DB_COLS_GROUP] = "class_id" ;
		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_PRESENT_STATISTIC_CLASS];
		$total = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
		$tmp_argv[sr_present] = 1;
		$confirm_total = $cm_obj->db_browse("LIST_ALL", $tmp_argv);
		$tmp_total = array();
		$tmp_total[business_group] = "總計";
		$i = 0;
		$sum = 0;
		$confirm_sum = 0;
		foreach($total[pds] as $val){
			$tmp_total[class_statistic][$i][class_total] = $val[cnt];
			$sum = $sum + $val[cnt];
			foreach($confirm_total[pds] as $val2){
				if ($val2[class_id] == $val[class_id]) {
					$tmp_total[class_statistic][$i][present] = $val2[cnt];
					$confirm_sum = $confirm_sum + $val2[cnt];
					break;
				}
			}
			$i = $i+1;
		}
		$tmp_total[percent] = $sum?$confirm_sum/$sum*100:0;
		$op[datas][pds][] = $tmp_total;

		$layout->display($cm_obj->CFG[LAYOUT][PRESENT_STATISTIC], $op);
		break;



	#########################
	#	@ 啟用入口 check in 系統
	#	2007.12.11. Gilbert.
	#########################
	case 'turnon':
		require_once _DIR_LIB_DBCFG . 'config.project.php';

		$tmp_argv = array();
		$tmp_argv[id] = $ProjectInfo[id];
		$tmp_argv[status_ary][IS_RUN] = 1;
		$flag = $project_obj->db_modify($tmp_argv);

		if ($flag) {
			$_SESSION[ProjectInfo][status_ary][IS_RUN] = 1;
		}

		gotoUrl($return."&PHP_action=main", "啟用入口 check in 系統", 3, array());

		break;



	#########################
	#	@ 關閉入口 check in 系統
	#	2007.12.11. Gilbert.
	#########################
	case 'turnoff':
		require_once _DIR_LIB_DBCFG . 'config.project.php';

		$tmp_argv = array();
		$tmp_argv[id] = $ProjectInfo[id];
		$tmp_argv[status_ary][IS_RUN] = 0;
		$flag = $project_obj->db_modify($tmp_argv);

		if ($flag) {
			$_SESSION[ProjectInfo][status_ary][IS_RUN] = 0;
		}

		gotoUrl($return."&PHP_action=main", "關閉入口 check in 系統", 3, array());

		break;



	#########################
	#	@ 匯出出席彩券清單
	#########################
	case 'export_present':

		if (!$_project_id) {
			$log->err("無法匯出出席彩券清單！未指定專案編號");
			die('未指定專案編號');
		}

		$q_str = "(SELECT lottery_no FROM checkin_log WHERE project_id='{$_project_id}' GROUP BY lottery_no) UNION (SELECT lottery_no FROM member WHERE project_id='{$_project_id}' AND status&2!=0 AND status&1=0 GROUP BY lottery_no)";
		$rlt = mysql_query($q_str, $db_link_master);

		if ($rlt === false) {
			die(mysql_error());
		}

		ob_start();

		if (headers_sent()) {
			echo "error!";
			exit;
		}
		header("Content-Type: text/plain");
		header("Content-Disposition: attachment; filename=present.csv");
		header('Pragma: no-cache');
		header('Expires: 0');

		while ($g_s = mysql_fetch_assoc($rlt)) {
			echo $g_s[lottery_no] . "\r\n";
		}

		ob_flush();

		mysql_close($db_link_master);

		break;



	#########################
	#	@ 匯出出席人員清單
	#	2009.01.14. Gilbert.
	#########################
	case 'export_present_members':

		if (!$_project_id) {
			$log->err("無法匯出出席人員清單！未指定專案編號");
			die('未指定專案編號');
		}

		#$q_str = "(SELECT lottery_no FROM checkin_log WHERE project_id='{$_project_id}' GROUP BY lottery_no) UNION (SELECT lottery_no FROM member WHERE project_id='{$_project_id}' AND status&2!=0 AND status&1=0 GROUP BY lottery_no)";
		#2009.01.14. Gilbert.
		$q_str = "SELECT lottery_no,legal_person,business_group,department,member_code,name,family_name,memo FROM member WHERE project_id='{$_project_id}' AND status&2!=0 AND status&1=0";
		$rlt = mysql_query($q_str, $db_link_master);

		if ($rlt === false) {
			die(mysql_error());
		}

		ob_start();

		if (headers_sent()) {
			echo "error!";
			exit;
		}
		#header("Content-Type: text/plain");
		header("Content-type: application/csv; charset=utf-8");
		header("Content-Disposition: attachment; filename=join_members_" . date('YmdHis') . ".csv");

		// BOM for Windows
		echo(chr(239).chr(187).chr(191));

		header('Pragma: no-cache');
		header('Expires: 0');

		echo '"抽獎號碼","法人","事業群","部門","工號","姓名","眷屬姓名","備註"' . chr(13) . chr(10);

		while ($g_s = mysql_fetch_assoc($rlt)) {
			echo '"' . join('","', $g_s) . '"' . "\r\n";
		}

		ob_flush();

		mysql_close($db_link_master);

		break;

}

// ============= add 2016
//
// parse xml response data
//
function xml_parse_into_assoc($data) {
	$p = xml_parser_create();
	xml_parser_set_option($p, XML_OPTION_CASE_FOLDING, 0);
	xml_parser_set_option($p, XML_OPTION_SKIP_WHITE, 1);
	xml_parse_into_struct($p, $data, $vals, $index);
	xml_parser_free($p);

	$xml = array(
		'person_num' => 0,
		'persons' => array()
	);

	foreach ($vals AS $vv) {
		if ($vv['tag']=='person_num') {
			$xml['person_num'] = $vv['value'];
			continue;
		}
		
		if ($vv['tag']=='empid' && $vv['level']==4) {
			$xml['persons'][] = $vv['value'];
			continue;
		}
	}

	return $xml;
}
// ============= End: add 2016

?>
