<?php
/**
 *
 *	程式名稱：	參加人員管理
 *	檔案名稱：	module.member.php
 *	版　　本：	1.0.0.
 *	作　　者：	Jacky Jou<starjou@price.com.tw>
 *	著作聲明：	Price Co., Ltd.
 *	起草日期：	2006.12.22.
 *	更新日期：
 *	說　　明：
 *
 */


// ===== 初始化物件
require_once _DIR_LIB_DBCFG . 'config.member.php';
require_once _DIR_LIB_DBCFG . 'config.class.php';

require_once _DIR_LIB_FUNCTION . 'JSescape.php';
require_once _DIR_LIB_CLASS . 'class.Javascript.php';


// ===== 模組化參數設定
$cm_title = '參加人員';
$cm_func = 'member';
$cm_func2 = 'MEMBER';
$cm_obj = $member_obj;
$op[cm_func] = $cm_func;
$op[cm_title] = $cm_title;
$op[cm_url] = $SELF;

// * 圖檔上傳所需設定
$cm_image_dir = _DIR_UPLOAD . 'member_img/';			// 圖檔存放資料夾
$cm_image_url = _URL_UPLOAD . 'member_img/';			// 圖檔資料夾URL

# 除錯設定
$op[cm_debug] = true;
#$layout->smarty->debugging = true;
$layout->smarty->clear_compiled_tpl();

$layout->assign($op);


// ===== 常用變數
$return = $SELF . '?PHP_dType=' . $cm_func;
$action = $_REQUEST['PHP_action'];

# 列表
$class_obj->CFG[DB_COLS_SORT] = "id";
$class_list = $class_obj->db_browse('LIST_ALL', array('sr_not_deleted'=>1, 'sr_project_id'=>$ProjectInfo[id]));
$op[class_list] = $class_list[pds];

$layout->assign($op);

// ===== 主程式
switch($action){
#########################
#	@ 主選單
#########################
	default:
	case 'main':
		$layout->display($cm_obj->CFG[LAYOUT]['MAIN'], $op);
		break;

#########################
#	@ 資料瀏覽及搜尋
#########################
	case 'browse':
		$cm_obj->CFG[ROW_PER_PAGE] = 50;
		if ($RQT[PHP_sr_page])
			$RQT[PHP_sr_startno] = ($RQT[PHP_sr_page] - 1) * $cm_obj->CFG[ROW_PER_PAGE];

		// ===== 設定要排序的欄位
		$sorttypes = array(
			"id"=>"MBR.id",
			"lottery_no"=>"MBR.lottery_no",
			"department"=>"MBR.department",
			"member_code"=>"MBR.member_code",
			"family_name"=>"MBR.family_name",
			"family_code"=>"MBR.family_code",
			"name"=>"name",
		);

		//設定查詢資料時之排序欄位/預設排序欄位
		$sorttype = $RQT[PHP_sr_sorttype]? $RQT[PHP_sr_sorttype]: "uid";
		foreach($sorttypes AS $key=>$val){
			$sortstr = ($sorttype == "d{$key}")? "{$val} DESC": $sortstr;
			$sortstr = ($sorttype == "u{$key}")? $val: $sortstr;
		}
		$cm_obj->CFG[DB_COLS_SORT] = $sortstr;
		$cm_obj->CFG[DB_SORT_TYPE] = $sorttype;


		// ===== 執行搜尋
		$RQT[sr_not_deleted] = 1;
		$RQT[sr_project_id] = $ProjectInfo[id];
		//echo "<pre>"; print_r($RQT);

		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_EXPORT];
		//$cm_obj->debug=true;
		$datas = $cm_obj->db_browse('LIST_ALL',$RQT) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0001', $cm_obj->msg->get(2));

		//echo "<pre>";print_r($datas);

		// ===== 產生各種排序所需的鏈結
		// 這部份要在 db_browse 之後做，且 $op 必須是 db_browse 回傳之物件。若使用其它變數名稱則改為其它變數。
		foreach ($sorttypes AS $key=>$val){
			$im = "<a href='{$datas[cgistr_get]}&PHP_sr_sorttype=d{$key}'><img src=\"images/down.gif\" width=13 height=13 border=0 align=absmiddle></a>";
			$datas["im".$key] = ($datas[sorttype]=="d{$key}")?"<a href='{$datas[cgistr_get]}&PHP_sr_sorttype=u{$key}'><img src=\"images/downy.gif\" width=13 height=13 border=0 align=absmiddle></a>":$im;
			$datas["im".$key]=($datas[sorttype]=="u{$key}")?"<a href='{$datas[cgistr_get]}&PHP_sr_sorttype=d{$key}'><img src=\"images/upy.gif\" width=13 height=13 border=0 align=absmiddle></a>":$datas["im".$key];
		}

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][BROWSE], $datas);
		break;

#########################
#	@ 新增
#########################
	case 'add':
		// =====初始化資料
		$op=array();

		// * 讀取儲存失敗的暫存資料
		if ($data=$GSID[$cm_func2."_ADD_BUF"]) {
			unset($GSID[$cm_func2."_ADD_BUF"]);
		} else {
			$data=array();
		}
		$op[data]=$data;

		// ===== 顯示畫面
		$op[cm_action]="submit_add";
		$op[onloadJavascript]="document.form1.elements['input[lottery_no]'].focus();";

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][ADD], $op);
		break;

#########################
#	@ 新增儲存
#########################
	case 'submit_add':

		// ===== 輸入資料處理
		$tmp_argv = array();
		$tmp_argv = $RQT[input];
		$tmp_argv[status_ary][IS_PRESENT]=$tmp_argv[status_ary][IS_PRESENT]?1:0;
		$tmp_argv[project_id] = $ProjectInfo[id];

		// 轉換抽獎資格為 1BYTE
		$tmp_argv[qualification1] = $tmp_argv[qualification1]?1:0;
		$tmp_argv[qualification2] = $tmp_argv[qualification2]?1:0;
		$tmp_argv[qualification3] = $tmp_argv[qualification3]?1:0;
		$tmp_argv[qualification4] = $tmp_argv[qualification4]?1:0;
		$tmp_argv[qualification5] = $tmp_argv[qualification5]?1:0;
		$tmp_argv[qualification6] = $tmp_argv[qualification6]?1:0;
		$tmp_argv[qualification7] = $tmp_argv[qualification7]?1:0;
		$tmp_argv[qualification8] = $tmp_argv[qualification8]?1:0;

		#2008.12.28. Gilbert.
		$tmp_argv[qualification9] = $tmp_argv[qualification9]?1:0;
		$tmp_argv[qualification10] = $tmp_argv[qualification10]?1:0;
		$tmp_argv[qualification11] = $tmp_argv[qualification11]?1:0;
		$tmp_argv[qualification12] = $tmp_argv[qualification12]?1:0;
		$tmp_argv[qualification13] = $tmp_argv[qualification13]?1:0;
		$tmp_argv[qualification14] = $tmp_argv[qualification14]?1:0;
		$tmp_argv[qualification15] = $tmp_argv[qualification15]?1:0;
		$tmp_argv[qualification16] = $tmp_argv[qualification16]?1:0;
		$tmp_argv[qualification17] = $tmp_argv[qualification17]?1:0;
		$tmp_argv[qualification18] = $tmp_argv[qualification18]?1:0;
		$tmp_argv[qualification19] = $tmp_argv[qualification19]?1:0;
		$tmp_argv[qualification20] = $tmp_argv[qualification20]?1:0;

		#$tmp_argv[qualification] = $tmp_argv[qualification1] + $tmp_argv[qualification2] *  2 + $tmp_argv[qualification3] *  4 + $tmp_argv[qualification4] * 8 + $tmp_argv[qualification5] * 16 + $tmp_argv[qualification6] * 32 + $tmp_argv[qualification7] *64 + $tmp_argv[qualification8] * 128;
		#2008.12.28. Gilbert.
		$tmp_argv[qualification] = 0;
		$tmp_argv[qualification] += $tmp_argv[qualification1] * pow(2, 0);
		$tmp_argv[qualification] += $tmp_argv[qualification2] * pow(2, 1);
		$tmp_argv[qualification] += $tmp_argv[qualification3] * pow(2, 2);
		$tmp_argv[qualification] += $tmp_argv[qualification4] * pow(2, 3);
		$tmp_argv[qualification] += $tmp_argv[qualification5] * pow(2, 4);
		$tmp_argv[qualification] += $tmp_argv[qualification6] * pow(2, 5);
		$tmp_argv[qualification] += $tmp_argv[qualification7] * pow(2, 6);
		$tmp_argv[qualification] += $tmp_argv[qualification8] * pow(2, 7);
		$tmp_argv[qualification] += $tmp_argv[qualification9] * pow(2, 8);
		$tmp_argv[qualification] += $tmp_argv[qualification10] * pow(2, 9);
		$tmp_argv[qualification] += $tmp_argv[qualification11] * pow(2, 10);
		$tmp_argv[qualification] += $tmp_argv[qualification12] * pow(2, 11);
		$tmp_argv[qualification] += $tmp_argv[qualification13] * pow(2, 12);
		$tmp_argv[qualification] += $tmp_argv[qualification14] * pow(2, 13);
		$tmp_argv[qualification] += $tmp_argv[qualification15] * pow(2, 14);
		$tmp_argv[qualification] += $tmp_argv[qualification16] * pow(2, 15);
		$tmp_argv[qualification] += $tmp_argv[qualification17] * pow(2, 16);
		$tmp_argv[qualification] += $tmp_argv[qualification18] * pow(2, 17);
		$tmp_argv[qualification] += $tmp_argv[qualification19] * pow(2, 18);
		$tmp_argv[qualification] += $tmp_argv[qualification20] * pow(2, 19);

		// * 建檔資訊
		$tmp_argv[create_time]=date("Y-m-d H:i:s");
		$tmp_argv[create_user]=$GSID[UserInfo][account];
		$GSID[$cm_func2."_ADD_BUF"]=$tmp_argv;


		// ===== 資料庫存取
		$cm_obj->db_add($tmp_argv) OR gotoUrl($return.'&PHP_action=add', "新增{$cm_title}進資料庫時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0002', $cm_obj->msg->get(2));
		$new_id=$cm_obj->get_new_id();


		// 上傳圖檔
		if ($_FILES[upload_file][tmp_name]){
			$image_name = $new_id.".".fileext($_FILES[upload_file][name]);
			copy ($_FILES[upload_file][tmp_name], $cm_image_dir.$image_name);
			$tmp_argv = array();
			$tmp_argv[id] = $new_id;
			$tmp_argv[image] = $cm_image_url.$image_name;
			$cm_obj->db_modify($tmp_argv);
		}

		// ===== 回傳結果
		unset($GSID[$cm_func2."_ADD_BUF"]);
		if(!$cm_obj->msg->length()):
			gotoUrl($return."&PHP_action=view&PHP_id={$new_id}", "{$cm_title}資料新增成功!", 2);
		else:
			$tmp_msg=array("新增{$cm_title}資料時發生錯誤!");
			$tmp_msg=array_merge($tmp_msg, $cm_obj->msg->get(2));
			gotoUrl($return."&PHP_action=view&PHP_id={$new_id}", $tmp_msg, 5, array(), _ER_USER_NOTICE, 'ER_MEMBER_0003', $tmp_msg);
		endif;

		break;

#########################
#	@ 修改
#########################
	case 'modify':
		// ===== 輸入資料確認
		$RQT[PHP_id] OR gotoUrl($return, "無法讀取{$cm_title}資料!", 3, array(), _ER_USER_NOTICE, 'ER_MEMBER_0004', array("無法讀取{$cm_title}資料!", "使用者未指定資料編號!"));

		// ===== 資料讀取
		// * Case1: 儲存失敗時的暫存資料優先
		$data=$GSID[$cm_func2.'_MODIFY_BUF'];

		// * Case2: 資料庫存取
		if(!$data):
			$data = $cm_obj->get_db_detail($RQT[PHP_id]) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0005', $cm_obj->msg->get(2));
		else:
			unset($GSID[$cm_func2."_MODIFY_BUF"]);
		endif;

		// 轉換 qualification
		$data[qualification1] = $data[qualification] & 1;
		$data[qualification2] = $data[qualification] & 2;
		$data[qualification3] = $data[qualification] & 4;
		$data[qualification4] = $data[qualification] & 8;
		$data[qualification5] = $data[qualification] & 16;
		$data[qualification6] = $data[qualification] & 32;
		$data[qualification7] = $data[qualification] & 64;
		$data[qualification8] = $data[qualification] & 128;
		#2008.12.28. Gilbert.
		$data[qualification9] = $data[qualification] & (pow(2, 8));
		$data[qualification10] = $data[qualification] & (pow(2, 9));
		$data[qualification11] = $data[qualification] & (pow(2, 10));
		$data[qualification12] = $data[qualification] & (pow(2, 11));
		$data[qualification13] = $data[qualification] & (pow(2, 12));
		$data[qualification14] = $data[qualification] & (pow(2, 13));
		$data[qualification15] = $data[qualification] & (pow(2, 14));
		$data[qualification16] = $data[qualification] & (pow(2, 15));
		$data[qualification17] = $data[qualification] & (pow(2, 16));
		$data[qualification18] = $data[qualification] & (pow(2, 17));
		$data[qualification19] = $data[qualification] & (pow(2, 18));
		$data[qualification20] = $data[qualification] & (pow(2, 19));

		// ===== 資料存取狀態確認
		if ($data[status_ary][IS_DELETED]) {
			gotoUrl($return, array("{$cm_title}資料存取失敗!", "原因：您所指定的{$cm_title}資料已經刪除!!"), 5, array(), _ER_USER_NOTICE, 'ER_MEMBER_0006', array("{$cm_title}資料存取失敗", "原因：使用者所指定的資料已經刪除!"));
		}

		// ===== 顯示頁面
		$op[data] = $data;
		$op[cm_action]="submit_modify";

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][MODIFY], $op);
		break;

#########################
#	@ 修改儲存
#########################
	case 'submit_modify':
		// ===== 輸入資料處理
		$tmp_argv = array();
		$tmp_argv = $RQT[input];
		$tmp_argv[status_ary][IS_EXPORTED]=$tmp_argv[status_ary][IS_EXPORTED]?1:0;
		$tmp_argv[status_ary][IS_CLOSED]=$tmp_argv[status_ary][IS_CLOSED]?1:0;
		// 轉換抽獎資格為 1BYTE
		$tmp_argv[qualification1] = $tmp_argv[qualification1]?1:0;
		$tmp_argv[qualification2] = $tmp_argv[qualification2]?1:0;
		$tmp_argv[qualification3] = $tmp_argv[qualification3]?1:0;
		$tmp_argv[qualification4] = $tmp_argv[qualification4]?1:0;
		$tmp_argv[qualification5] = $tmp_argv[qualification5]?1:0;
		$tmp_argv[qualification6] = $tmp_argv[qualification6]?1:0;
		$tmp_argv[qualification7] = $tmp_argv[qualification7]?1:0;
		$tmp_argv[qualification8] = $tmp_argv[qualification8]?1:0;

		#2008.12.28. Gilbert.
		$tmp_argv[qualification9] = $tmp_argv[qualification9]?1:0;
		$tmp_argv[qualification10] = $tmp_argv[qualification10]?1:0;
		$tmp_argv[qualification11] = $tmp_argv[qualification11]?1:0;
		$tmp_argv[qualification12] = $tmp_argv[qualification12]?1:0;
		$tmp_argv[qualification13] = $tmp_argv[qualification13]?1:0;
		$tmp_argv[qualification14] = $tmp_argv[qualification14]?1:0;
		$tmp_argv[qualification15] = $tmp_argv[qualification15]?1:0;
		$tmp_argv[qualification16] = $tmp_argv[qualification16]?1:0;
		$tmp_argv[qualification17] = $tmp_argv[qualification17]?1:0;
		$tmp_argv[qualification18] = $tmp_argv[qualification18]?1:0;
		$tmp_argv[qualification19] = $tmp_argv[qualification19]?1:0;
		$tmp_argv[qualification20] = $tmp_argv[qualification20]?1:0;

		#$tmp_argv[qualification]= $tmp_argv[qualification1] + $tmp_argv[qualification2] *  2 + $tmp_argv[qualification3] *  4 + $tmp_argv[qualification4] * 8 + $tmp_argv[qualification5] * 16 + $tmp_argv[qualification6] * 32 + $tmp_argv[qualification7] *64 + $tmp_argv[qualification8] * 128;
		#2008.12.28. Gilbert.
		$tmp_argv[qualification] = 0;
		$tmp_argv[qualification] += $tmp_argv[qualification1] * pow(2, 0);
		$tmp_argv[qualification] += $tmp_argv[qualification2] * pow(2, 1);
		$tmp_argv[qualification] += $tmp_argv[qualification3] * pow(2, 2);
		$tmp_argv[qualification] += $tmp_argv[qualification4] * pow(2, 3);
		$tmp_argv[qualification] += $tmp_argv[qualification5] * pow(2, 4);
		$tmp_argv[qualification] += $tmp_argv[qualification6] * pow(2, 5);
		$tmp_argv[qualification] += $tmp_argv[qualification7] * pow(2, 6);
		$tmp_argv[qualification] += $tmp_argv[qualification8] * pow(2, 7);
		$tmp_argv[qualification] += $tmp_argv[qualification9] * pow(2, 8);
		$tmp_argv[qualification] += $tmp_argv[qualification10] * pow(2, 9);
		$tmp_argv[qualification] += $tmp_argv[qualification11] * pow(2, 10);
		$tmp_argv[qualification] += $tmp_argv[qualification12] * pow(2, 11);
		$tmp_argv[qualification] += $tmp_argv[qualification13] * pow(2, 12);
		$tmp_argv[qualification] += $tmp_argv[qualification14] * pow(2, 13);
		$tmp_argv[qualification] += $tmp_argv[qualification15] * pow(2, 14);
		$tmp_argv[qualification] += $tmp_argv[qualification16] * pow(2, 15);
		$tmp_argv[qualification] += $tmp_argv[qualification17] * pow(2, 16);
		$tmp_argv[qualification] += $tmp_argv[qualification18] * pow(2, 17);
		$tmp_argv[qualification] += $tmp_argv[qualification19] * pow(2, 18);
		$tmp_argv[qualification] += $tmp_argv[qualification20] * pow(2, 19);

		$GSID[$cm_func2."_MODIFY_BUF"]=$tmp_argv;

		// * 資料狀態確認
		$data=$cm_obj->get_db_detail($tmp_argv[id]) OR gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", "檢查資料狀態時發生錯誤!", 3, array(), _ER_USER_WARNING, 'ER_MEMBER_0007', $cm_obj->msg->get(2));
		if($data[status_ary][IS_DELETED]):
			gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", array("錯誤! 無法更新{$cm_title}資料!", " 原因, 您所指定的資料已經被刪除!"), 3, array(), _ER_USER_ERROR, 'ER_MEMBER_0008', array("無法更新{$cm_title}資料", "資料已經被刪除!"));
		endif;

		if($tmp_argv[password] && ($tmp_argv[old_password] != $data[password])){
			unset($tmp_argv[password]);
			$tmp_msg=array("舊密碼錯誤，密碼變更失敗!");
		}
		if(!$tmp_argv[password]){
			unset($tmp_argv[password]);
		}


		// * 取得更新記錄
		$tmp_argv=array_merge($tmp_argv, createUpdateLog($data, $GSID[UserInfo][account]));

		// 刪除舊圖檔
		if($RQT[remove_image] || $_FILES[upload_file][tmp_name]){
			unlink($data[image]);
			$tmp_argv[image] = "";
		}
		// 上傳圖檔
		if ($_FILES[upload_file][tmp_name]){
			$image_name = $tmp_argv[id].".".fileext($_FILES[upload_file][name]);
			copy ($_FILES[upload_file][tmp_name], $cm_image_dir.$image_name);
			$tmp_argv[image] = $cm_image_url.$image_name;
		}


		// ===== 資料庫存取
		$flag0 = $cm_obj->db_modify($tmp_argv) OR gotoUrl($return."&PHP_action=modify&PHP_id={$tmp_argv[id]}", "儲存{$cm_title}進資料庫時發生錯誤!!", 3, array(), _ER_USER_ERROR, 'ER_MEMBER_0009', $cm_obj->msg->get(2));

		// ===== 回傳結果
		unset($GSID[$cm_func2."_MODIFY_BUF"]);

		if(count($tmp_msg)):
			$tmp_msg=array_merge( "更新{$cm_title}資料時發生錯誤!",$tmp_msg);
			$tmp_msg=array_merge($tmp_msg, $cm_obj->msg->get(2));
			gotoUrl($return."&PHP_action=view&PHP_id={$tmp_argv[id]}", $tmp_msg, 2, array(), _ER_USER_NOTICE, "ER_MEMBER_0010", $tmp_msg);
		else:
			gotoUrl($return."&PHP_action=view&PHP_id={$tmp_argv[id]}", "{$cm_title}資料更新成功!", 2);
		endif;

		break;

#########################
#	@ 檢視
#########################
	case 'view':
		$cm_id = $RQT[PHP_id];

		if (!$cm_id)
			gotoUrl($return, '未指定專案編號', 3, array(), _ER_USER_ERROR, 'ER_MEMBER_0011', array('未指定資料編號'));

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_id] = $cm_id;

		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_EXPORT];
		$cm_list = $cm_obj->db_browse('LIST_ALL', $tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0012', $cm_obj->msg->get(2));

		$op[data] = $cm_list[pds][0];


		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][VIEW], $op);
		break;

#########################
#	@ 刪除
#########################
	case "submit_delete":

		// ===== 輸入資料確認
		$RQT[PHP_id] OR gotoUrl($return, array("刪除{$cm_title}時發生錯誤!!", "您沒有指定{$cm_title}資料編號"),  5, array(), _ER_USER_NOTICE, 'ER_MEMBER_0013', array("刪除{$cm_title}時發生錯誤!!", "使用者未指定{$cm_title}資料編號!"));

		// ===== 資料狀態確認
		$data = $cm_obj->get_db_detail($RQT[PHP_id]) OR gotoUrl($return, "讀取{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0014', $cm_obj->msg->get(2));
		if($data[status_ary][IS_DELETED]):
			gotoUrl($return, array("您所指定的資料已經刪除!", "已刪除資料不可重複刪除!"), 3, array(), _ER_USER_NOTICE, 'ER_MEMBER_0015', array("已刪除資料不可重複刪除!"));
		endif;

		// ===== 資料庫存取
		$tmp_argv = array("id"=>$RQT[PHP_id]);
		$tmp_argv[status_ary]=array("IS_DELETED"=>1);
		$tmp_argv[modify_time]=date("Y-m-d H:i:s");
		$tmp_argv[modify_user]=$GSID[UserInfo][account];

		$cm_obj->db_modify($tmp_argv) OR gotoUrl($return."&PHP_action=modify&PHP_id={$RQT[PHP_id]}", "刪除{$cm_title}資料時發生錯誤!!", 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0016', $cm_obj->msg->get(2));

		// ===== 回傳結果
		gotoUrl($return, "{$cm_title}資料刪除成功! ", 2);

		break;

#########################
#	@ 匯出配額
#########################
	case 'export':
		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_project_id] = $ProjectInfo[id];

		$cm_obj->CFG[BROWSE_SQL_TITLE] = $cm_obj->CFG[BROWSE_SQL_TITLE_EXPORT];
		$cm_obj->CFG[DB_COLS_SORT] = "id";

		$datas = $cm_obj->db_browse('LIST_ALL',$tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0017', $cm_obj->msg->get(2));
		$op[datas] = $datas[pds];
		unset($datas);
		$layout->assign($op);
		$content = $layout->fetch($cm_obj->CFG[LAYOUT]['EXPORT']);
		ob_start();
		// 產生CSV檔
		if (headers_sent()) {
			echo "error!";
			exit;
		}
		header("Content-Type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=member.xls");
		header('Pragma: no-cache');
		header('Expires: 0');
		echo $content;
		ob_flush();

		break;

#########################
#	@ 匯入配額
#########################
	case 'import':

		// 暫存檔
		#$file_tmp = "upload/tmp_member.csv";
		$file_tmp = tempnam("upload/memberList/", "ML".date("ymdHis"));

		// 第一行是否為欄位名稱？是，匯入時要略過。
		$skipfirst = ($_REQUEST['skip']) ? true : false;

		// 匯入檔案格式
		$src_mode = $_REQUEST["mode"];
		switch ($src_mode) {
			default:
			case 'ansi':
				$mode = "ansi";
				$delimiter = ",";
				break;
			case 'unicode':
				$mode = "unicode";
				$delimiter = "\t";
				#$delimiter = iconv("UTF-16LE", "UTF-8", "\t");
				break;
			case 'utf8':
				$mode = "utf8";
				$delimiter = "\t";
				break;
		}

		// 清除舊資料
		$q_try = "DELETE FROM member WHERE project_id = " . $_SESSION['ProjectInfo']['id'];
		$cm_obj->sql->query($q_try);

		// 載入編碼轉換函式
		require_once _DIR_LIB_FUNCTION . 'big5_func/big5_func.inc';

		// 檔案上傳
		#檔案上傳
		#if (file_exists($file_tmp)) {
		#	unlink($file_tmp);
		#}
		#copy($_FILES['upload_file']['tmp_name'], $file_tmp);
		move_uploaded_file($_FILES['upload_file']['tmp_name'], $file_tmp);

#		$contents = file($file_tmp);
#		$fp = fopen($file_tmp, "w");
#		foreach ($contents AS $line) {
#			fwrite($fp, big5_utf8_encode($line));
#		}
#		fclose($fp);

		// 將檔案轉成 utf8
		switch ($mode) {
			case "ansi":
				$contents = file($file_tmp);
				$fp = fopen($file_tmp, "w");
				foreach ($contents AS $line) {
					fwrite($fp, big5_utf8_encode($line));
				}
				fclose($fp);
				break;
			case "unicode":
				$contents = file($file_tmp);
				$fp = fopen($file_tmp, "w");
				foreach ($contents AS $line) {
					fwrite($fp, iconv("UTF-16LE", "UTF-8", $line));
				}
				fclose($fp);
				break;
			case "utf8":
			default:
				break;
		}

		// 將人員資料寫入資料庫
		$fp = fopen($file_tmp, "r");
		$tmp_msg = array();
		$class_id = array();
		foreach($class_list[pds] AS $key=>$val) {
#			$class_id[big5_utf8_encode($val[class_name])]=$val[id];
			$class_id[$val[class_name]] = $val[id];
		}

		$cnt = 0;
		#while ($data = fgetcsv($fp, 65534, "\t")) {
		while ($data = fgetcsv($fp, 65534, $delimiter)) {
			$cnt++;
#			if($data[0] == big5_utf8_encode('抽獎號碼')){
#			if ($data[0] == '抽獎號碼') {
#				continue;
#			}
			if ($skipfirst && $cnt==1) {
				continue;
			}

			for ($c=0; $c<9; $c++) {
#				$data[$c] = mysql_escape_string(big5_utf8_decode($data[$c]));
#				$data[$c] = mysql_escape_string($data[$c]);
				$data[$c] = mysql_real_escape_string($data[$c]);
			}

			# 欄位順序：抽獎號碼、法人、事業群、部門、工號、姓名、眷屬姓名、手機、備註、幸運圖騰編號、配額類別、資格1、資格2、資格3、資格4、資格5、資格6、資格7、資格8

			# 資料是否完整判斷，至少須有前10欄
			if (count($data) < 10) {
				# 若欄位數不足 加入問題清單
				$tmp_incomplete = '';
				for($i = 0; $i < count($data); $i++){
 					$tmp_incomplete .= $data[$i];
				}
				$tmp_incomplete .= " \n";
				$incomplete[] = $tmp_incomplete;
			} else {
				//　轉換配額類別為對應　id
				if (!empty($data[10])) {
					$data[class_id] = $class_id[$data[10]];
				}

				// 轉換抽獎資格為 1 BYTE
				$data[11] = $data[11]?$data[11]:0;
				$data[12] = $data[12]?$data[12]:0;
				$data[13] = $data[13]?$data[13]:0;
				$data[14] = $data[14]?$data[14]:0;
				$data[15] = $data[15]?$data[15]:0;
				$data[16] = $data[16]?$data[16]:0;
				$data[17] = $data[17]?$data[17]:0;
				$data[18] = $data[18]?$data[18]:0;

				#2008.12.28. Gilbert.
				$data[19] = $data[19]?$data[19]:0;
				$data[20] = $data[20]?$data[20]:0;
				$data[21] = $data[21]?$data[21]:0;
				$data[22] = $data[22]?$data[22]:0;
				$data[23] = $data[23]?$data[23]:0;
				$data[24] = $data[24]?$data[24]:0;
				$data[25] = $data[25]?$data[25]:0;
				$data[26] = $data[26]?$data[26]:0;
				$data[27] = $data[27]?$data[27]:0;
				$data[28] = $data[28]?$data[28]:0;
				$data[29] = $data[29]?$data[29]:0;
				$data[30] = $data[30]?$data[30]:0;

				#$data[qualification]= $data[11] + $data[12] *  2 + $data[13] *  4 + $data[14] * 8 + $data[15] * 16 + $data[16] * 32 + $data[17] *64 + $data[18] * 128;
				#2008.12.28. Gilbert.
				$data[qualification] = 0;
				$data[qualification] += $data[11] * pow(2, 0);
				$data[qualification] += $data[12] * pow(2, 1);
				$data[qualification] += $data[13] * pow(2, 2);
				$data[qualification] += $data[14] * pow(2, 3);
				$data[qualification] += $data[15] * pow(2, 4);
				$data[qualification] += $data[16] * pow(2, 5);
				$data[qualification] += $data[17] * pow(2, 6);
				$data[qualification] += $data[18] * pow(2, 7);
				$data[qualification] += $data[19] * pow(2, 8);
				$data[qualification] += $data[20] * pow(2, 9);
				$data[qualification] += $data[21] * pow(2, 10);
				$data[qualification] += $data[22] * pow(2, 11);
				$data[qualification] += $data[23] * pow(2, 12);
				$data[qualification] += $data[24] * pow(2, 13);
				$data[qualification] += $data[25] * pow(2, 14);
				$data[qualification] += $data[26] * pow(2, 15);
				$data[qualification] += $data[27] * pow(2, 16);
				$data[qualification] += $data[28] * pow(2, 17);
				$data[qualification] += $data[29] * pow(2, 18);
				$data[qualification] += $data[30] * pow(2, 19);

				//新增員工資料
				$tmp_argv = array();
				$tmp_argv[project_id] = $ProjectInfo[id];
				$tmp_argv[lottery_no] = $data[0];
				#$tmp_argv[legal_person] = $data[1];
				$tmp_argv[legal_person] = trim($data[1]);
				#$tmp_argv[business_group] = $data[2];
				$tmp_argv[business_group] = trim($data[2]);
				#$tmp_argv[department] = $data[3];
				$tmp_argv[department] = trim($data[3]);
				$tmp_argv[member_code] = $data[4];
				#$tmp_argv[name] = $data[5];
				$tmp_argv[name] = trim($data[5]);
				#$tmp_argv[family_name] = $data[6];
				$tmp_argv[family_name] = trim($data[6]);
				$tmp_argv[cell] = $data[7];
				#$tmp_argv[memo] = $data[8];
				$tmp_argv[memo] = trim($data[8]);
				$tmp_argv[totem] = $data[9];
				$tmp_argv[class_id] = $data[class_id];
				$tmp_argv[qualification] = $data[qualification];
				$tmp_argv[create_time] = date("Y-m-d H:i:s");
				$tmp_argv[create_user] = $GSID[UserInfo][account];
				$flag0 = $cm_obj->db_add($tmp_argv);
				if (!$flag0) {
					$tmp_msg[] = "新增{$cm_title}資料時發生錯誤!";
					$tmp_msg[] = $cm_obj->msg->get(2);
				}
				unset($tmp_argv);
			}
		}
		fclose ($fp);

		// ===== 回傳結果
		if ((!$cm_obj->msg->length()) && count($tmp_msg) == 0) {
			if((count($incomplete) == 0)){
				gotoUrl($return."&PHP_action=browse", "{$cm_title}資料匯入成功!", 2 );
			}
			else{
				$incomplete = array_merge("{$cm_title}資料匯入完成，部份資料未匯入!", $incomplete);
				gotoUrl($return."&PHP_action=browse",$incomplete , 10, array(), _ER_USER_NOTICE, 'ER_MEMBER_0018', $incomplete );
			}
		} else {
			gotoUrl($return."&PHP_action=browse", $tmp_msg, 10, array(), _ER_USER_NOTICE, 'ER_MEMBER_0019', $tmp_msg);
		}

		break;



#########################
#	@ 檢查參加人員名單
#	2007.12.11. Gilbert.
#########################
	case 'check':

		$tmp_argv = array();
		$tmp_argv[sr_not_deleted] = 1;
		$tmp_argv[sr_project_id] = $_SESSION['ProjectInfo']['id'];

		$cm_obj->CFG[DB_COLS_SORT] = "MBR.lottery_no ASC";

		$datas = $cm_obj->db_browse('LIST_ALL',$tmp_argv) OR gotoUrl($return, '資料庫存取失敗!', 5, array(), _ER_USER_ERROR, 'ER_MEMBER_0001', $cm_obj->msg->get(2));

		$op[member_list] = $datas[pds];

		// ===== 顯示畫面
		$layout->display($cm_obj->CFG[LAYOUT][CHECK], $op);

		break;
}

?>