<?php

/*
*
*	程式名稱：	登入後的系統主程式
*	說　　明：	負責處理使用者登入後的功能。
*	檔案名稱：	main.php
*	版　　本：	1.0.0.
*	作　　者：	Gilbert Chiao <gilbert@price.com.tw>
*						Hsiao Chuan Huang <dolly@price.com.tw>
*	著作聲明：	Price Co. Ltd.
*	起草日期：	2005.05.24.
*	更新日期：	2005.05.24.
*
*/



/* 載入系統組態檔。*/
require_once 'config.inc.php';

/* 簡化常用變數 */
$SELF=basename($_SERVER[PHP_SELF]);
$RQT=$_REQUEST;
$op[UserInfo] = $UserInfo;
$op[ProjectInfo] = $ProjectInfo;
$layout->assign($op);

/* 如果已登入且為受限制之前台功能，則轉至該功能頁面 */
if($ProjectInfo[drawing]){
	gotoUrl('draw.php');
}

if($ProjectInfo[confirming]){
	gotoUrl('confirm.php');
}

if($ProjectInfo[button]){
	gotoUrl('button.php');
}

switch($RQT[PHP_dType]){

	/* 系統首頁 */
	default:

		$layout->display('sys.main.tpl', $op);

		break;

	/* 專案管理 */
	case "project":
			require _DIR_MGR_MOD."module.project.php";
		break;
	
	/* 類別管理 */
	case "class":
			require _DIR_MGR_MOD."module.class.php";
		break;
	
	/* 獎項管理 */
	case "prize":
			require _DIR_MGR_MOD."module.prize.php";
		break;
	
	/* 參加者管理 */
	case "member":
			require _DIR_MGR_MOD."module.member.php";
		break;
	
	/* 出席管理 */
	case "present":
			require _DIR_MGR_MOD."module.present.php";
		break;
	
	/* 得獎名單 */
	case "prize_list":
			require _DIR_MGR_MOD."module.prize_list.php";
		break;
	
	/* 抽獎 */
	case "draw":
		$layout->display('draw.enter.tpl', $op);
		break;
	
	/* 領獎 */
	case "confirm":
		$layout->display('confirm.enter.tpl', $op);
		break;
	
	/* 領獎 */
	case "button":
		$layout->display('button.enter.tpl', $op);
		break;
	
	/* 系統設定 */
	case "sys_config":
			require _DIR_MGR_MOD."module.sys_config.php";
		break;
	
	case "test":

		header ("Content-type: image/png");
		$width=65;
		$height=30;
		$im = @imagecreatetruecolor($width, $height) or die("Cannot Initialize new GD image stream");
		$text_color = imagecolorallocate($im, 233, 14, 91);
		imagestring($im, 20, 6, 6,  "ABCDEF", $text_color);
		
		$im_dest=@imagecreatetruecolor($width, $height);
		for($x=0;$x<$width;$x++){
			for($y=0;$y<$height;$y++){
				$color = imagecolorsforindex($im, ImageColorAt($im, $x, $y));
				$colorid=imagecolorallocate ( $im_dest, $color[red], $color[green], $color[blue]);
				$y1=$y+sin($x);
				imagesetpixel($im_dest, $x, $y1, $colorid);
			}
		}

		imagepng($im_dest);
		imagedestroy($im);
		imagedestroy($im_dest);
		
		break;
}

?>