<?php

/*
*
*	程式名稱：	系統組態檔
*	說　　明：	系統中所有程式必須預先載入此檔案，以進行初始化設定。
*	檔案名稱：	config.inc.php
*	版　　本：	1.0.0.
*	作　　者：	Gilbert Chiao <gilbert@price.com.tw>
*							Hsiao Chuan Huang <dolly@price.com.tw>
*	著作聲明：	Price Co. Ltd.
*	起草日期：	2005.04.24.
*	更新日期：	2005.04.24.
*
*/


/*
載入系統設定 2005.04.11. Gilbert.
包含檔案目錄常數設定、php系統參數設定、MySQL參數設定。
*/
require_once 'php_lib_FC/Manager/config.system.php';

/* 初始化系統執行時所需的基本物件及函式 2005.04.12. Dolly. */
require_once _DIR_LIB_SMARTY . 'Smarty.class.php';
require_once _DIR_LIB_CLASS . 'class.layout.php';
require_once _DIR_LIB_CLASS . 'class.msg_handle.php';
require_once _DIR_LIB_CLASS . 'class.mysql.php';
require_once _DIR_LIB_CLASS . 'class.db.php';
require_once _DIR_LIB_FUNCTION . 'gotoUrl.php';
require_once _DIR_LIB_FUNCTION . 'createUpdateLog.php';
//require_once _DIR_LIB_FUNCTION . 'fileext.php';

/* MySQL連線初始化 */
require _DIR_LIB_MGR . 'config.mysql.php';

/* 載入客戶資訊 */
require _DIR_MGR_CRS . 'config.client.php';

/* SESSION初始化 */
ini_set('session.save_path', _DIR_SESSION);
session_start();

/* Layout 物件初始化 */
$layout = new LAYOUT();
$layout->assign($CRS);

/*
顯示系統訊息 2005.04.13. Dolly.
搭配gotoUrl錯誤處理函式的機制
*/
if ($_SESSION['GSID']['SystemMessage']){
	$layout->assign($_SESSION['GSID']['SystemMessage']);
	unset($_SESSION['GSID']['SystemMessage']);
	$tpl = $_SESSION['GSID']['SystemMessage']['TemplateVars']['FileName'];
	$tpl = $tpl? $tpl: 'sys.msg.html';
	$layout->display($tpl);
	exit;
}

// 載入 PEAR 的 Log 套件並初始化
require_once _DIR_LIB_CLASS . 'Log.php';
#$log = Log::factory('file', _DIR_LOG . 'pear.log', session_id(), array(), PEAR_LOG_DEBUG);
# 測試時用下面這行，上線之後再換上面那行。
$log = Log::factory('file', _DIR_LOG . 'pear.log', substr(session_id(), 0, 6), array(), PEAR_LOG_DEBUG);


/* 使用者存取權限認證 */
$bypass_phps = array("index.php", "checkin.php", "verify.php");
#if (!$_SESSION['GSID']['UserInfo'] && basename($_SERVER['PHP_SELF'])!='index.php'){
if (!$_SESSION['GSID']['UserInfo'] && !in_array(basename($_SERVER['PHP_SELF']), $bypass_phps)) {
	gotoUrl('index.php?PHP_action=login');
}



// 若已選擇專案，則取得目前出席人員 2007.12.24.
if ($_SESSION[ProjectInfo][id]) {
	$_project_id = $_SESSION[ProjectInfo][id];
	$q_str = "SELECT COUNT(*) AS cnt FROM member WHERE status&2!=0 AND project_id='{$_project_id}' ";
	$rlt = mysql_query($q_str);
	$g_s = mysql_fetch_assoc($rlt);
	$total_no = $g_s[cnt];
	$op[total_no] = $total_no;
	$layout->assign($op);
}



# 不顯示錯誤。2006.06.19. Gilbert.
#error_reporting(0);

?>
