<?php

/*
*
*	程式名稱：	登入後的系統主程式
*	說　　明：	負責處理使用者登入後的功能。
*	檔案名稱：	main.php
*	版　　本：	1.0.0.
*	作　　者：	Gilbert Chiao <gilbert@price.com.tw>
*						Hsiao Chuan Huang <dolly@price.com.tw>
*	著作聲明：	Price Co. Ltd.
*	起草日期：	2005.05.24.
*	更新日期：	2005.05.24.
*
*/


/* 載入系統組態檔。*/
require_once 'config.inc.php';

/* 如果已登入且為受限制之前台功能，則轉至該功能頁面 */
if($ProjectInfo[drawing]){
	gotoUrl('draw.php');
}

if($ProjectInfo[confirming]){
	gotoUrl('confirm.php');
}

//新增顯示目前獎項列表 by Wun-Hao Liu @ 2012/01/09
// ===== 初始化物件
require_once _DIR_LIB_DBCFG . 'config.prize.php';
require_once _DIR_LIB_DBCFG . 'config.prize_quota.php';
$cm_obj = $prize_obj;
$cm_quota_obj = $przqt_obj;


/* 簡化常用變數 */
$SELF=basename($_SERVER[PHP_SELF]);
$RQT=$_REQUEST;
$op[UserInfo] = $UserInfo;
$op[ProjectInfo] = $ProjectInfo;
// ===== 模組化參數設定
$cm_title = '抽獎';
$cm_func = 'button';
$cm_func2 = 'BUTTON';
$op[cm_func] = $cm_func;
$op[cm_title] = $cm_title;
$op[cm_url] = $SELF;
$layout->assign($op);



/* 進入本功能後設定 _SESSION 變數使系統只能執行本項功能*/
$ProjectInfo[button] = 1;



switch($RQT['PHP_dType']){

	//顯示目前抽獎項目 by Wun-Hao Liu @ 2012/01/09
	/* ajax 查詢目前抽獎項目 */
	case "check_current_item":
		require_once _DIR_LIB_DBCFG . 'config.project.php';
		$current_item = $prj_obj->get_db_detail($ProjectInfo[id]);
		$current_item = $current_item[current_item];
		header( "Content-Type: application/xml; charset=utf-8");
		header( "Expires: Mon, 26 Jul 1997 05:00:00 GMT" );  // disable IE caching
		header( "Last-Modified: " . gmdate( "D, d M Y H:i:s" ) . "GMT" );
		header( "Cache-Control: no-cache, must-revalidate" );
		header( "Pragma: no-cache" );

		$op[data] = $cm_obj->get_db_detail($current_item);
		
		echo "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
		echo "<current_item>".$op[data][prize_name]."</current_item>";
		break;

	/* ajax 檢查抽獎狀態 */
	case "check_status":
		require_once _DIR_LIB_DBCFG . 'config.sys_config.php';
		$sys_config = $sys_cfg_obj->get_db_detail(1);
		$draw_status = $sys_config[status_ary][IS_DRAW]?1:0;
		header( "Content-Type: application/xml; charset=utf-8");
		header( "Expires: Mon, 26 Jul 1997 05:00:00 GMT" );  // disable IE caching
		header( "Last-Modified: " . gmdate( "D, d M Y H:i:s" ) . "GMT" );
		header( "Cache-Control: no-cache, must-revalidate" );
		header( "Pragma: no-cache" );
		echo "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
		echo "<draw_status>".$draw_status."</draw_status>";
		break;



	/* 系統首頁 */
	default:
//		$op[onloadJavascript] = 'document.form1.PHP_lottery_no.focus()';
		$layout->display('button.main.tpl', $op);
		break;



	// 抽獎
	case "draw":
		$tmp_argv= array();
		$tmp_argv[id] = 1;
		$tmp_argv[status_ary][IS_DRAW] = 1;
		require_once _DIR_LIB_DBCFG . 'config.sys_config.php';
		$sys_cfg_obj->db_modify($tmp_argv);

		$status_str = "ready=1";
		$fp = fopen("status.txt", "w");
		fwrite($fp, $status_str);
		fclose($fp);
		$layout->display('button.done.tpl', $op);
		break;

}

?>